<?php
/**
 * @copyright Intermesh 2004
 * @author Merijn Schering <mschering@intermesh.nl>
 * @version $Revision: 1.24 $ $Date: 2006/01/30 15:59:14 $
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 */

require_once("Group-Office.php");
require_once($GO_LANGUAGE->get_language_file('users'));

//modules user get's access to.
//$modules_read = array('products', 'filesystem');
$modules_read = array_map('trim', explode(',',$GO_CONFIG->register_modules_read));
$modules_write = array_map('trim', explode(',',$GO_CONFIG->register_modules_write));

//user groups the user will be added to.
$user_groups = $GO_GROUPS->groupnames_to_ids(array_map('trim',explode(',',$GO_CONFIG->register_user_groups)));

//user groups that this user will be visible to
$visible_user_groups = $GO_GROUPS->groupnames_to_ids(array_map('trim',explode(',',$GO_CONFIG->register_visible_user_groups)));

$task = isset($_POST['task']) ? $_POST['task'] : '';

if(!$GO_CONFIG->allow_registration)
{
	header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
	exit();
}
$birthday = isset($_REQUEST['birthday']) ? $_REQUEST['birthday'] : '';
$birthday_picker = new date_picker('birthday', $GO_CONFIG->date_formats[0], $birthday);
$GO_HEADER['head'] = $birthday_picker->get_header();



if(file_exists($GO_CONFIG->root_path.'login_screens/'.$GO_CONFIG->login_screen.'/login_header.inc'))
{
	require_once($GO_CONFIG->root_path.'login_screens/'.$GO_CONFIG->login_screen.'/login_header.inc');
}

$user['first_name'] = isset($_POST['first_name']) ?  smart_stripslashes(trim($_POST['first_name'])) : '';
$user['middle_name'] = isset($_POST['middle_name']) ?  smart_stripslashes(trim($_POST['middle_name'])) : '';
$user['last_name'] = isset($_POST['last_name']) ?  smart_stripslashes(trim($_POST['last_name'])) : '';
$user['initials'] = isset($_POST['initials']) ? smart_stripslashes($_POST["initials"]) : '';
$user['title'] = isset($_POST['title']) ? smart_stripslashes($_POST["title"]) : '';
$user['birthday'] = isset($_POST['birthday']) ? smart_stripslashes($_POST["birthday"]) : '';
$user['email'] = isset($_POST['email']) ? smart_stripslashes($_POST["email"]) : '';
$user['home_phone'] = isset($_POST['home_phone']) ? smart_stripslashes($_POST["home_phone"]) : '';
$user['work_phone'] = isset($_POST['work_phone']) ? smart_stripslashes($_POST["work_phone"]) : '';
$user['fax'] = isset($_POST['fax']) ? smart_stripslashes($_POST["fax"]) : '';
$user['cellular'] = isset($_POST['cellular']) ? smart_stripslashes($_POST["cellular"]) : '';
$user['country_id'] = isset($_POST['country_id']) ? smart_addslashes($_POST["country_id"]) : '';
$user['state'] = isset($_POST['state']) ? smart_stripslashes($_POST["state"]) : '';
$user['city'] = isset($_POST['city']) ? smart_stripslashes($_POST["city"]) : '';
$user['zip'] = isset($_POST['zip']) ? smart_stripslashes($_POST["zip"]) : '';
$user['address'] = isset($_POST['address']) ? smart_stripslashes($_POST["address"]) : '';
$user['company'] = isset($_POST['company']) ? smart_stripslashes($_POST["company"]) : '';
$user['department'] =  isset($_POST['department']) ? smart_stripslashes($_POST["department"]) : '';
$user['function'] =  isset($_POST['function']) ? smart_stripslashes($_POST["function"]) : '';
$user['sex'] = isset($_POST['sex']) ? smart_stripslashes($_POST["sex"]) : 'M';
$user['language'] = isset($_POST['SET_LANGUAGE']) ? $_POST['SET_LANGUAGE'] : $GO_LANGUAGE->language['code'];
$user['theme'] = $GO_CONFIG->theme;
$user['username'] = isset($_POST['username']) ? smart_stripslashes($_POST['username']) : '';


if ($task == "register")
{
	$pass1 = smart_stripslashes($_POST["pass1"]);
	$pass2 = smart_stripslashes($_POST["pass2"]);
	$user['password'] = smart_stripslashes($_POST["pass1"]);
	
	$user = array_map('addslashes',$user);

	if (
	empty($user['username']) || 
	empty($pass1) || empty ($pass2) || 
	empty($user['first_name']) || 
	empty($user['last_name'])
	)
	{
		$feedback = $error_missing_field."</p>";
	}elseif(!validate_email($user['email']))
	{
		$feedback = $error_email;
	}elseif($GO_USERS->get_user_by_username($_POST['username']))
	{
		$feedback = $error_username_exists;
	}elseif($GO_USERS->email_exists($_POST['email']))
	{
		$feedback = $error_email_exists;
	}elseif($pass1 != $pass2)
	{
		$feedback = $error_match_pass;		
	}else
	{
		$user['birthday'] = date_to_db_date($_POST['birthday']);
		
		if ($new_user_id = $GO_USERS->add_user($user, $user_groups, $visible_user_groups, $modules_read, $modules_write	))
		{

			//send email to the user with password
			$registration_mail_body = str_replace("%sex%", $sir_madam[$_POST['sex']], $registration_mail_body);
			// If $title is not set, then use $sex (sir_madam) instead for $title.
			$registration_mail_body = str_replace("%title%", ( ($user['title'] != '') ? $user['title'] : $sir_madam[$_POST['sex']] ), $registration_mail_body);
			$registration_mail_body = str_replace("%last_name%", smart_stripslashes($_POST['last_name']), $registration_mail_body);
			$registration_mail_body = str_replace("%middle_name%", smart_stripslashes($_POST['middle_name']), $registration_mail_body);
			$registration_mail_body = str_replace("%first_name%", smart_stripslashes($_POST['first_name']), $registration_mail_body);
			$registration_mail_body = str_replace("%username%",smart_stripslashes($_POST['username']), $registration_mail_body);
			$registration_mail_body = str_replace("%password%",smart_stripslashes($_POST['pass1']), $registration_mail_body);
			$registration_mail_body = str_replace("%groupoffice_title%",$GO_CONFIG->title, $registration_mail_body);
			$registration_mail_body .= "\n\n".$GO_CONFIG->full_url;
			
			$registration_mail_subject = str_replace("%groupoffice_title%",$GO_CONFIG->title, $registration_mail_subject);

			sendmail($user['email'],  $GO_CONFIG->webmaster_email, $GO_CONFIG->title, $registration_mail_subject, $registration_mail_body);

			//create Group-Office home directory
			$old_umask = umask(000);
			mkdir($GO_CONFIG->file_storage_path.stripslashes($user['username']), $GO_CONFIG->create_mode);
			umask($old_umask);

			//confirm registration to the user and exit the script so the form won't load
			
			$p = new html_element('p',  $registration_success.' ');
			$p->add_html_element(new html_element('b',$user['email']));
			
			echo $p->get_html();

			$link = 'index.php?username='.urlencode(smart_stripslashes($_POST['username']));

			if(isset($_REQUEST['return_to']))
			{
				$link .= '&return_to='.urlencode($_REQUEST['return_to']);
			}

			$button = new button($cmdLogin, "javascript:document.location='".$link."';");
			echo $button->get_html();
			require_once($GO_CONFIG->root_path.'login_screens/'.$GO_CONFIG->login_screen.'/login_footer.inc');
			exit();
		}else
		{
			$error = $registration_failure;
		}
	}
}
if ($GO_USERS->max_users_reached())
{
	$h1 = new html_element('h1', $max_user_limit);
	$p = new html_element('p', $max_users_text);
	echo $ht->get_html().$p->get_html();
	require_once($GO_THEME->theme_path."footer.inc");
	exit();
}

$form = new form('register_form');

$form->add_html_element(new html_element('br'));

if (isset($_REQUEST['return_to']))
{
	$form->add_html_element(new input('hidden', 'return_to', $_REQUEST['return_to']));
}
$form->add_html_element(new input('hidden', 'task'));

if (isset($feedback))
{
  $p = new html_element('p', $feedback);
  $p->set_attribute('class','Error');
  $form->add_html_element($p);
}

$form->add_html_element(new html_element('h1', str_replace("%groupoffice_title%",$GO_CONFIG->title, $registration_title)));

$table = new table();

$row = new table_row();
$row->add_cell(new table_cell($reg_language.':'));

$select = new select('SET_LANGUAGE', $user['language']);
$select->set_attribute('onchange', 'javascript:document.register_form.submit();');
$languages = $GO_LANGUAGE->get_languages();
foreach($languages as $language)
{
	$select->add_value($language['code'], $language['description']);
}
$row->add_cell(new table_cell($select->get_html()));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strCompany.':'));
$input = new input('text','company', $user['company']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','50');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);


$row = new table_row();
$row->add_cell(new table_cell($strFirstName.'*:'));
$input = new input('text','first_name',$user['first_name']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','50');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strMiddleName.':'));
$input = new input('text','middle_name',$user['middle_name']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','50');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);


$row = new table_row();
$row->add_cell(new table_cell($strLastName.'*:'));
$input = new input('text','last_name', $user['last_name']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','50');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strTitle.' / '.$strInitials.':'));
$input1 = new input('text','title', $user['title']);
$input1->set_attribute('style','width:135px');
$input1->set_attribute('maxlength','12');

$span = new html_element('span', ' / ');
$span->set_attribute('style', 'width: 20px;text-align:center;');

$input2 = new input('text','initials', $user['initials']);
$input2->set_attribute('style','width:135px');
$input2->set_attribute('maxlength','50');

$row->add_cell(new table_cell($input1->get_html().$span->get_html().$input2->get_html()));
$table->add_row($row);


$row = new table_row();
$row->add_cell(new table_cell($strSex.':'));
$radiogroup = new radiogroup('sex', $user['sex']);
$male_button = new radiobutton('sex_m', 'M');
$female_button = new radiobutton('sex_f', 'F');

$row->add_cell(new table_cell($radiogroup->get_option($male_button, $strSexes['M']).$radiogroup->get_option($female_button, $strSexes['F'])));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strBirthday.':'));
$row->add_cell(new table_cell($birthday_picker->get_html()));
$table->add_row($row);

$row = new table_row();
$cell = new table_cell('&nbsp;');
$cell->set_attribute('colspan','2');
$row->add_cell($cell);
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strAddress.':'));
$input = new input('text','address', $user['address']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','50');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strZip.':'));
$input = new input('text','zip', $user['zip']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','20');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strCity.':'));
$input = new input('text','city', $user['city']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','50');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strState.':'));
$input = new input('text','state', $user['state']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','30');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strCountry.':'));
$select = new select('country_id', $user['country_id']);
$select->add_value('0', $cmdPleaseSelect);
$GO_USERS->get_countries();
while($GO_USERS->next_record())
{
	$select->add_value($GO_USERS->f('id'), $GO_USERS->f('name'));
}
$row->add_cell(new table_cell($select->get_html()));
$table->add_row($row);


$row = new table_row();
$row->add_cell(new table_cell($strEmail.'*'));
$input = new input('text','email', $user['email']);
$input->set_attribute('style','width:280px');
$input->set_attribute('maxlength','50');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);

$row = new table_row();
$cell = new table_cell('&nbsp;');
$cell->set_attribute('colspan','2');
$row->add_cell($cell);
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($strUsername.'*:'));
$input = new input('text', 'username');
$input->set_attribute('style','width:200px');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);
	
$row = new table_row();
$row->add_cell(new table_cell($admin_password.':'));
$input = new input('password', 'pass1');
$input->set_attribute('style','width:200px');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);

$row = new table_row();
$row->add_cell(new table_cell($admin_confirm_password.':'));
$input = new input('password', 'pass2');
$input->set_attribute('style','width:200px');
$row->add_cell(new table_cell($input->get_html()));
$table->add_row($row);


$form->add_html_element($table);

$button = new button($cmdOk, 'javascript:register_user();');
$form->add_html_element($button);
$button = new button($cmdReset, 'javascript:document.forms[0].reset();');
$form->add_html_element($button);
$link = 'index.php';

if(isset($_REQUEST['return_to']))
{
	$link .= '&return_to='.urlencode($_REQUEST['return_to']);
}
$button = new button($cmdCancel, "javascript:document.location='".$link."';");
$form->add_html_element($button);

$form->add_html_element(new html_element('br'));

echo $form->get_html();
?>

<script type="text/javascript">
document.forms[0].company.focus();
function register_user()
{
	document.forms[0].task.value='register';
	document.forms[0].submit();	
}
</script>
<?php
if(file_exists($GO_CONFIG->root_path.'login_screens/'.$GO_CONFIG->login_screen.'/login_footer.inc'))
{
	require_once($GO_CONFIG->root_path.'login_screens/'.$GO_CONFIG->login_screen.'/login_footer.inc');
}
?>
