<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once("../../Group-Office.php");
$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('users');
require_once($GO_LANGUAGE->get_language_file('users'));
require_once($GO_LANGUAGE->get_base_language_file('common'));

$user_id = isset($_REQUEST['user_id']) ? $_REQUEST['user_id'] : 0;

$module_acl = isset($_POST['module_acl']) ? $_POST['module_acl'] : array();

$return_to = isset($_REQUEST['return_to']) ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$onsuccess_goto = isset($_REQUEST['onsuccess_goto']) ? $_REQUEST['onsuccess_goto'] : $return_to;

//$user['id'] = 0;
$user['first_name'] = isset($_POST['first_name']) ?  smart_stripslashes(trim($_POST['first_name'])) : '';
$user['middle_name'] = isset($_POST['middle_name']) ?  smart_stripslashes(trim($_POST['middle_name'])) : '';
$user['last_name'] = isset($_POST['last_name']) ?  smart_stripslashes(trim($_POST['last_name'])) : '';
$user['initials'] = isset($_POST['initials']) ? smart_stripslashes($_POST["initials"]) : '';
$user['title'] = isset($_POST['title']) ? smart_stripslashes($_POST["title"]) : '';
$user['birthday'] = isset($_POST['birthday']) ? smart_stripslashes($_POST["birthday"]) : '';
$user['email'] = isset($_POST['email']) ? smart_stripslashes($_POST["email"]) : '';
$user['home_phone'] = isset($_POST['home_phone']) ? smart_stripslashes($_POST["home_phone"]) : '';
$user['work_phone'] = isset($_POST['work_phone']) ? smart_stripslashes($_POST["work_phone"]) : '';
$user['fax'] = isset($_POST['fax']) ? smart_stripslashes($_POST["fax"]) : '';
$user['cellular'] = isset($_POST['cellular']) ? smart_stripslashes($_POST["cellular"]) : '';
$user['country_id'] = isset($_POST['country_id']) ? smart_addslashes($_POST["country_id"]) : '';
$user['state'] = isset($_POST['state']) ? smart_stripslashes($_POST["state"]) : '';
$user['city'] = isset($_POST['city']) ? smart_stripslashes($_POST["city"]) : '';
$user['zip'] = isset($_POST['zip']) ? smart_stripslashes($_POST["zip"]) : '';
$user['address'] = isset($_POST['address']) ? smart_stripslashes($_POST["address"]) : '';
$user['company'] = isset($_POST['company']) ? smart_stripslashes($_POST["company"]) : '';
$user['department'] =  isset($_POST['department']) ? smart_stripslashes($_POST["department"]) : '';
$user['function'] =  isset($_POST['function']) ? smart_stripslashes($_POST["function"]) : '';
$user['work_country_id'] = isset($_POST['work_country_id']) ?  smart_addslashes($_POST["work_country_id"]) : '';
$user['work_state'] = isset($_POST['work_state']) ? smart_stripslashes($_POST["work_state"]) : '';
$user['work_city'] = isset($_POST['work_city']) ? smart_stripslashes($_POST["work_city"]) : '';
$user['work_zip'] = isset($_POST['work_zip']) ? smart_stripslashes($_POST["work_zip"]) : '';
$user['work_address'] = isset($_POST['work_address']) ? smart_stripslashes($_POST["work_address"]) : '';
$user['work_fax'] = isset($_POST['work_fax']) ? smart_stripslashes($_POST["work_fax"]) : '';
$user['homepage'] = isset($_POST['homepage']) ? smart_stripslashes($_POST["homepage"]) : '';
$user['sex'] = isset($_POST['sex']) ? smart_stripslashes($_POST["sex"]) : 'M';
$user['language'] = isset($_POST['language']) ? smart_stripslashes($_POST['language']) : $GO_CONFIG->language;
$user['theme'] = isset($_POST['theme']) ? smart_stripslashes($_POST['theme']) : $GO_CONFIG->theme;
$user['username'] = isset($_POST['username']) ? smart_stripslashes($_POST['username']) : '';
if($_SERVER['REQUEST_METHOD'] != 'POST')
{
	$user['enabled'] = '1';
}else
{
	$user['enabled'] = isset($_POST["enabled"]) ? '1' : '0';
}


if ($_SERVER['REQUEST_METHOD'] == "POST")
{
	$pass1 = smart_stripslashes($_POST["pass1"]);
	$pass2 = smart_stripslashes($_POST["pass2"]);
	$user['password'] = smart_addslashes($_POST["pass1"]);

	if (
	empty($user['username']) || 
	empty($pass1) || empty ($pass2) || 
	empty($user['first_name']) || 
	empty($user['last_name'])	
	)
	{
		$feedback = $error_missing_field;
	}elseif(!validate_email($user['email']))
	{
		$feedback = $error_email;
	}elseif($GO_USERS->get_user_by_username($_POST['username']))
	{
		$feedback = $error_username_exists;
	}elseif($GO_USERS->email_exists($_POST['email']))
	{
		$feedback = $error_email_exists;
	}elseif($pass1 != $pass2)
	{
		$feedback = $error_match_pass;
	}else
	{
		$user['birthday'] = date_to_db_date($_POST['birthday']);
		//register the new user. function returns new user_id or -1 on failure.
		
		$user_groups = isset($_POST['user_groups']) ? $_POST['user_groups'] : array();
		$modules_read =  isset($_POST['modules_read']) ? $_POST['modules_read'] : array();
		$modules_write =  isset($_POST['modules_write']) ? $_POST['modules_write'] : array();
		$visible_user_groups = isset($_POST['visible_user_groups']) ? $_POST['visible_user_groups'] : array();
		
		$user = array_map('addslashes',$user);
		if ($new_user_id = $GO_USERS->add_user($user, $user_groups, $visible_user_groups, $modules_read, $modules_write))
		{
			//send email to the user with password
			$registration_mail_body = str_replace("%sex%", $sir_madam[$_POST['sex']], $registration_mail_body);
			// If $title is not set, then use $sex (sir_madam) instead for $title.
			$registration_mail_body = str_replace("%title%", ( ($user['title'] != '') ? $user['title'] : $sir_madam[$_POST['sex']] ), $registration_mail_body);
			$registration_mail_body = str_replace("%last_name%", smart_stripslashes($_POST['last_name']), $registration_mail_body);
			$registration_mail_body = str_replace("%middle_name%", smart_stripslashes($_POST['middle_name']), $registration_mail_body);
			$registration_mail_body = str_replace("%first_name%", smart_stripslashes($_POST['first_name']), $registration_mail_body);
			$registration_mail_body = str_replace("%username%",smart_stripslashes($_POST['username']), $registration_mail_body);
			$registration_mail_body = str_replace("%password%",smart_stripslashes($_POST['pass1']), $registration_mail_body);
			$registration_mail_body = str_replace("%groupoffice_title%",$GO_CONFIG->title, $registration_mail_body);
			$registration_mail_body .= "\n\n".$GO_CONFIG->full_url;
			
			$registration_mail_subject = str_replace("%groupoffice_title%",$GO_CONFIG->title, $registration_mail_subject);

			
			sendmail($user['email'], $GO_CONFIG->webmaster_email, $GO_CONFIG->title, $registration_mail_subject, $registration_mail_body);


			//set module permissions
			for ($i=0;$i<count($module_acl);$i++)
			{
				$GO_SECURITY->add_user_to_acl($new_user_id, $_POST['module_acl'][$i]);
			}

			//create Group-Office home directory
			$old_umask = umask(000);
			mkdir($GO_CONFIG->file_storage_path.'users/'.$user['username'], $GO_CONFIG->create_mode);
			umask($old_umask);

			//confirm registration to the user and exit the script so the form won't load
			
			require_once($GO_THEME->theme_path."header.inc");
			$b = new html_element('b', $user['email']);
			
			$p = new html_element('p',$registration_success.' '.$b->get_html());
			echo $p->get_html();
			$onsuccess_goto = add_params_to_url($onsuccess_goto, 'id='.$new_user_id);

			$button = new button($cmdContinue, "javascript:document.location='".$onsuccess_goto."';");
			echo $button->get_html();
			require_once($GO_THEME->theme_path."footer.inc");
			exit();
		}else
		{
			$feedback = $registration_failure;
		}
	}
}

$birthday_picker = new date_picker('birthday', $_SESSION['GO_SESSION']['date_format'], $user['birthday']);
$GO_HEADER['head'] = $birthday_picker->get_header();

$page_title = $registration_title;
require_once($GO_THEME->theme_path."header.inc");

if (!$GO_USERS->max_users_reached())
{
	require_once("register_form.inc");
}else
{
	$h1 = new html_element('h1', $max_user_limit);
	$p = new html_element('p', $max_users_text);
	echo $ht->get_html().$p->get_html();
}
require_once($GO_THEME->theme_path."footer.inc");
?>
