<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

require_once("../../Group-Office.php");
require_once($GO_LANGUAGE->get_language_file('users'));

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('users');

require_once($GO_CONFIG->class_path.'admin.class.inc');
$admin = new admin();


$query = isset($_POST['query']) ? smart_stripslashes($_POST['query']) : '';

$search_fields = new select('search_field');
$search_fields->add_value('', $strSearchAll);			
$search_fields->add_value('users.first_name', $strFirstName);
$search_fields->add_value('users.last_name', $strLastName);
$search_fields->add_value('users.email', $strEmail);
$search_fields->add_value('users.department',$strDepartment);
$search_fields->add_value('users.function',$strFunction);
$search_fields->add_value('users.address',$strAddress);
$search_fields->add_value('users.city', $strCity);
$search_fields->add_value('users.zip',$strZip);
$search_fields->add_value('users.state',$strState);
$search_fields->add_value('users.country', $strCountry);

$GO_HEADER['head'] = datatable::get_header();
$GO_HEADER['body_arguments'] = 'onload="document.forms[0].query.focus();" onkeypress="executeOnEnter(event, \'search();\');"';
require_once($GO_THEME->theme_path."header.inc");

$form = new form('users_form');

$table = new datatable('users');
$table->set_attribute('width','100%');

if($table->task == 'delete')
{
	foreach($table->selected as $delete_user_id)
	{
		if (($delete_user_id != $GO_SECURITY->user_id) && ($delete_user_id != 1))
  	{
  		$GO_USERS->delete_user($delete_user_id);
  	}else
  	{
  		$feedback = $delete_fail;
  	}
	}
}

$table->add_column(new table_heading($strName, 'name'));
$table->add_column(new table_heading($strUsername, 'username'));
$table->add_column(new table_heading($strCompany, 'company'));
$table->add_column(new table_heading($strLogins, 'logins'));
$table->add_column(new table_heading($ac_lastlogin , 'lastlogin'));
$table->add_column(new table_heading($strRegistrationDate, 'registration_time'));

$count = $GO_USERS->search('%'.$query.'%', $search_fields->value, 0, $table->start, $table->offset, $table->sort_index, $table->sql_sort_order);

$table->set_pagination($count);

while ($GO_USERS->next_record())
{  
  $name = format_name($GO_USERS->f('last_name'),$GO_USERS->f('first_name'),$GO_USERS->f('middle_name'));
  
  $row = new table_row($GO_USERS->f('id'));
  $row->set_attribute('ondblclick', "document.location='edit_user.php?user_id=".$GO_USERS->f("id")."'");
  if($GO_USERS->f('enabled') == '0')
  {
  	$row->set_attribute('class', 'Error');  	
  }
  
  $row->add_cell(new table_cell($name));
  $row->add_cell(new table_cell($GO_USERS->f("username")));
  $row->add_cell(new table_cell(empty_to_stripe($GO_USERS->f("company"))));
  $row->add_cell(new table_cell(
  	number_format($GO_USERS->f("logins"), 0, 
  	$_SESSION['GO_SESSION']['decimal_seperator'], 
  	$_SESSION['GO_SESSION']['thousands_seperator'])));
  $row->add_cell(new table_cell(get_timestamp($GO_USERS->f("lastlogin"))));
  $row->add_cell(new table_cell(get_timestamp($GO_USERS->f("registration_time"))));
  $table->add_row($row);
}

if (isset($feedback)){
	$p = new html_element('p', $feedback);
	$p->set_attribute('class','Error');
	$form->innerHTML .= $p->get_html();
}

if ($GO_CONFIG->max_users == 0 || ($count < $GO_CONFIG->max_users))
{
	$menu = new button_menu();	
	$menu->add_button('user_add',$cmdAdd, 'register.php');
	$menu->add_button('delete_big',$cmdDelete, $table->get_delete_handler());

	$form->innerHTML .= $menu->get_html();
}



$form->add_html_element($search_fields);


$input = new input('text', 'query', $query, false);
$input->set_attribute('style', 'width:300px;');

$form->add_html_element($input);
$form->add_html_element(new button($cmdSearch, 'javascript:search()'));


$div = new html_element('div', $count.' '.$strUsers);

$div->set_attribute('style','text-align:right;');
if ($GO_CONFIG->max_users != 0)
{
  $div->innerHTML .= ' '.$strMaxOf.' '.$GO_CONFIG->max_users;
  $div->set_attribute('class','Error');
}else
{
	$div->set_attribute('class','small');
}
$form->innerHTML .= $div->get_html().
	$table->get_html();
	
echo $form->get_html();
?>
<script type="text/javascript">
function search()
{
	<?php echo $table->set_page_one(); ?>
	document.forms[0].submit();
}
</script>
<?php
require_once($GO_THEME->theme_path."footer.inc");
?>
