<?php
/**
 * @copyright Reggy Ekkebus 2005
 * @author Reggy Ekkebus
 * @version $Revision: 1.3 $ $Date: 2006/04/10 13:21:11 $
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 */
 
 
 // Authenticate to Group-Office
 
 require_once("../../Group-Office.php");


$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('projects');

require_once($GO_LANGUAGE->get_language_file('projects'));
require_once($GO_MODULES->class_path."projects.class.inc");
$projects= new projects();

$categories=array();
if(isset($GO_MODULES->modules['custom_fields']))
{
	require_once($GO_MODULES->modules['custom_fields']['class_path'].'custom_fields.class.inc');
	$cf = new custom_fields();
	$cf->get_authorized_categories(5, $GO_SECURITY->user_id);
	while($cf->next_record())
	{
		$categories[] = $cf->f('id');
	}
}
$users = $projects->get_project_users();

$start_time = date_to_unixtime($_POST['start_date']);
$end_time = date_to_unixtime($_POST['end_date']);


$projects->get_authorized_projects(
			$GO_SECURITY->user_id,
			false,
			$_REQUEST['sort_index'],
			$_REQUEST['sort_order'],
			0,
			0,
			'',
			'',
			'',
			$start_time,
			$end_time
			);

$table = new table();
$table->set_attribute('border','1');
$table->set_attribute('style','border-collapse:collapse;border:1px solid black;white-space:nowrap');

$th = new table_heading($strName);
$th->set_attribute('style','text-align:left;background-color:#f1f1f1;');
$table->add_column($th);
$th = new table_heading($strDescription);
$th->set_attribute('style','text-align:left;background-color:#f1f1f1;');
$table->add_column($th);
$th = new table_heading($pm_start_date);
$th->set_attribute('style','text-align:left;background-color:#f1f1f1;');
$table->add_column($th);
$th = new table_heading($pm_end_date);
$th->set_attribute('style','text-align:left;background-color:#f1f1f1;');
$table->add_column($th);
$th = new table_heading($pm_status);
$th->set_attribute('style','text-align:left;background-color:#f1f1f1;');
$table->add_column($th);
foreach($categories as $category_id)
{
	$cf->get_fields($category_id);
	while($cf->next_record())
	{
		$th = new table_heading($cf->f('name'));
		if($cf->f('datatype') == 'number')
		{
			$th->set_attribute('style','text-align:right;background-color:#f1f1f1;');
		}else
		{
			$th->set_attribute('style','text-align:left;background-color:#f1f1f1;');
		}
		$table->add_column($th);
		
	}
}
$existing_users = array();
foreach($users as $user_id)
{
	if($user = $GO_USERS->get_user($user_id))
	{
		$existing_users[] = $user_id;
		$name = format_name($user['last_name'], $user['first_name'], $user['middle_name'], 'last_name');
		$th = new table_heading($pm_hours.'<br />'.$name);
		$th->set_attribute('style','text-align:center;background-color:#f1f1f1;');
		$table->add_column($th);
		$th = new table_heading($pm_internal_fee);
		$th->set_attribute('style','text-align:center;background-color:#f1f1f1;');
		$table->add_column($th);
		$th = new table_heading($pm_external_fee);
		$th->set_attribute('style','text-align:center;background-color:#f1f1f1;');
		$table->add_column($th);		
	}
}

$th = new table_heading($pm_total_hours);
$th->set_attribute('style','text-align:right;background-color:#f1f1f1;');
$table->add_column($th);
$th = new table_heading($pm_internal_fee);
$th->set_attribute('style','text-align:right;background-color:#f1f1f1;');
$table->add_column($th);
$th = new table_heading($pm_external_fee);
$th->set_attribute('style','text-align:right;background-color:#f1f1f1;');
$table->add_column($th);	
$projects2= new projects();
while($projects->next_record())
{
	$row = new table_row();
	$cell = new table_cell($projects->f('name'));
	$row->add_cell($cell);	
	$cell = new table_cell($projects->f('description'));
	$row->add_cell($cell);	
	$cell = new table_cell(date($_SESSION['GO_SESSION']['date_format'], $projects->f('start_date')));
	$row->add_cell($cell);
	$cell = new table_cell(date($_SESSION['GO_SESSION']['date_format'], $projects->f('end_date')));
	$row->add_cell($cell);
	$cell = new table_cell($projects->f('status_name'));
	$row->add_cell($cell);
	
	foreach($categories as $category_id)
	{
		$link_id = $projects->f('link_id') > 0 ? $projects->f('link_id') : 0;
		$cf->get_fields_with_values($category_id, $link_id);
		
		while($cf->next_record())
		{			
			switch($cf->f('datatype'))
			{
				case 'number':
					$cell = new table_cell(format_number($cf->f('value')));
					$cell->set_attribute('style','text-align:right;');
				break;
				
				case 'date':
					$cell = new table_cell(db_date_to_date($cf->f('value')));
					$cell->set_attribute('style','text-align:left;');
				break;
				
				case 'checkbox':
					$input = new input('checkbox', '','');
					if($cf->f('value')=='1')
					{
						$input->set_attribute('checked','true');
					}
					$cell = new table_cell($input->get_html());
					$cell->set_attribute('style','text-align:center;');
				break;
				
				default:
					$cell = new table_cell($cf->f('value'));
					$cell->set_attribute('style','text-align:left;');
				break;
			}
			$row->add_cell($cell);
		}
	}

	$totals = $projects2->get_total_hours($projects->f('id'));
	$row_totals['int_fee']=0;
	$row_totals['ext_fee']=0;
	$row_totals['time']=0;
	
	foreach($existing_users as $user_id)
	{
		if(!isset($totals[$user_id]['time']))
		{
			$totals[$user_id]['time']=0;
			$totals[$user_id]['int_fee']=0;
			$totals[$user_id]['ext_fee']=0;
		}
		$row_totals['time']+=$totals[$user_id]['time'];
		$row_totals['int_fee']+=$totals[$user_id]['int_fee'];
		$row_totals['ext_fee']+=$totals[$user_id]['ext_fee'];
		
		$cell = new table_cell(format_number($totals[$user_id]['time']/3600));
		$cell->set_attribute('style','text-align:right');
		$row->add_cell($cell);
		$cell = new table_cell(format_number($totals[$user_id]['int_fee']));
		$cell->set_attribute('style','text-align:right');
		$row->add_cell($cell);		
		$cell = new table_cell(format_number($totals[$user_id]['ext_fee']));
		$cell->set_attribute('style','text-align:right');
		$row->add_cell($cell);
	}
	
	$cell = new table_cell(format_number($row_totals['time']/3600));
	$cell->set_attribute('style','text-align:right');
	$row->add_cell($cell);
	
	$cell = new table_cell(format_number($row_totals['int_fee']));
	$cell->set_attribute('style','text-align:right');
	$row->add_cell($cell);
	
	$cell = new table_cell(format_number($row_totals['ext_fee']));
	$cell->set_attribute('style','text-align:right');
	$row->add_cell($cell);
	
	$table->add_row($row);
}
require($GO_THEME->theme_path.'header.inc');
echo $table->get_html();
require($GO_THEME->theme_path.'footer.inc');
?>
