<?php

/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once ("../../Group-Office.php");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('projects');
require_once ($GO_LANGUAGE->get_language_file('projects'));

//check for the addressbook module
$ab_module = isset ($GO_MODULES->modules['addressbook']) ? $GO_MODULES->modules['addressbook'] : false;
if ($ab_module && $ab_module['read_permission']) {
	require_once ($ab_module['class_path'].'addressbook.class.inc');
	$ab = new addressbook();
} else {
	$ab_module = false;
}

$page_title = $lang_modules['projects'];
require_once ($GO_MODULES->class_path."projects.class.inc");
$projects = new projects();

$task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';
$booking_id = isset($_REQUEST['booking_id']) ? smart_addslashes($_REQUEST['booking_id']) : 0;

$link_back = (isset ($_REQUEST['link_back']) && $_REQUEST['link_back'] != '') ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];
$return_to = isset ($_REQUEST['return_to']) ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];

switch ($task) {
	case 'save_hours' :
		$unit_value = isset ($_POST['unit_value']) ? smart_addslashes($_POST['unit_value']) : 0;
		
		$int_fee_value = number_to_phpnumber(smart_addslashes($_POST['int_fee_value']));
		$int_fee_time = smart_addslashes($_POST['int_fee_time']);
		
		$ext_fee_value = number_to_phpnumber(smart_addslashes($_POST['ext_fee_value']));
		$ext_fee_time = smart_addslashes($_POST['ext_fee_time']);
		
		$projects->set_registration_method($GO_SECURITY->user_id, smart_addslashes($_POST['registration_method']), $unit_value, $int_fee_value, $int_fee_time, $ext_fee_value, $ext_fee_time);
		
		$start_time = date_to_unixtime($_POST['book_start_date'].' '.$_POST['start_hour'].':'.$_POST['start_min']);
		$timezone_offset = get_timezone_offset($start_time) * 3600;
		$start_time -= $timezone_offset;

		//if user gave a number of units calulate ending time
		if ($_POST['registration_method'] == 'units') {
			$end_time = $start_time + $unit_value * 60 * $_POST['units'];
			$break_time = 0;
		} else {

			$break_time = ($_POST['break_hours'] * 3600) + ($_POST['break_mins'] * 60);
			$end_time = date_to_unixtime($_POST['book_end_date'].' '.$_POST['end_hour'].':'.$_POST['end_min']);
			$timezone_offset = get_timezone_offset($end_time) * 3600;
			$end_time -= $timezone_offset;

			$unit_value = 0;
		}

		if ($end_time < $start_time) {
			$feedback = '<p class="Error">'.$pm_invalid_period.'</p>';

		}elseif	($_POST['project_id']['value'] < 1)
		{
			$feedback = '<p class="Error">'.$pm_select_project.'</p>';
		}elseif ($booking_id == 0 && $existing_booking_id = $projects->check_hours($_POST['pm_user_id']['value'], $start_time, $end_time)) {
			
			$link = '<a href="'.$_SERVER['PHP_SELF'].'?booking_id='.$existing_booking_id.'&return_to='.urlencode($return_to).'">'.$pm_here.'</a>';
						
			$feedback = '<p class="Error">'.sprintf($pm_already_booked, $link).'</p>';
		} else {
			
			if($booking_id > 0)
			{
				if (!$projects->update_booking($booking_id, 
						$_REQUEST['project_id']['value'], 
						$_POST['pm_user_id']['value'], 
						$start_time, 
						$end_time, 
						$break_time, 
						$unit_value, 
						smart_addslashes($_POST['book_comments']),
						 $int_fee_value, 
						 $int_fee_time,
						 $ext_fee_value, 
						 $ext_fee_time
						)) {
						
					$feedback = '<p class="Error">'.$strSaveError.'</p>';
				} else {
					$feedback = '<p class="Success">'.$pm_add_hours_success.'</p>';
					if ($_POST['close'] == 'true') {
						header('Location: '.$return_to);
						exit ();
					}
				}
			}else
			{
				if (!$projects->add_booking($_REQUEST['project_id']['value'], 
					$_POST['pm_user_id']['value'], 
					$start_time, 
					$end_time, 
					$break_time, 
					$unit_value, 
					smart_addslashes($_POST['book_comments']),
					 $int_fee_value, 
					 $int_fee_time,
						$ext_fee_value, 
						$ext_fee_time)) {
						
					$feedback = '<p class="Error">'.$strSaveError.'</p>';
				} else {
					$feedback = '<p class="Success">'.$pm_add_hours_success.'</p>';
					if ($_POST['close'] == 'true') {
						header('Location: '.$return_to);
						exit ();
					}
				}
			}
		}
		break;
	
	case 'stop_timer' :
		$timer = $projects->get_timer($GO_SECURITY->user_id);
		$timer_start_time = $timer['start_time'] + (get_timezone_offset($timer['start_time']) * 3600);
		$timer_end_time = get_time();

		$projects->stop_timer($GO_SECURITY->user_id);

		$projects->set_registration_method($GO_SECURITY->user_id, 'endtime');

		$active_tab = 'book';
		break;
}
$pm_settings = $projects->get_settings($GO_SECURITY->user_id);

$GO_HEADER['head'] = date_picker::get_header();

$page_title = $lang_modules['projects'];
require_once ($GO_THEME->theme_path."header.inc");
echo '<form method="post" action="'.$_SERVER['PHP_SELF'].'" name="projects_form">';
echo '<input type="hidden" name="close" value="false" />';
//echo '<input type="hidden" name="project_id" value="'.$project_id.'" />';
echo '<input type="hidden" name="task" value="" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';


$time = get_time();
$day = date("j", $time);
$year = date("Y", $time);
$month = date("m", $time);

$date = date($_SESSION['GO_SESSION']['date_format'], $time);

$timer_start_date = isset($timer_start_time) ? date($_SESSION['GO_SESSION']['date_format'], $timer_start_time) : $date;
if($booking_id > 0 && $booking = $projects->get_booking($booking_id))
{
	$title = $pm_edit_data;
	$pm_user_id = $booking['user_id'];
	$project_id = $booking['project_id'];
	$local_start_time = $booking['start_time']+(get_timezone_offset($booking['start_time'])*3600);
	$local_end_time = $booking['end_time']+(get_timezone_offset($booking['start_time'])*3600);

	if ($booking['unit_value'] > 0)
	{
		$unit_value = $booking['unit_value'];
		$break_hours = 0;
		$break_mins = 0;
		
		$registration_method = 'units';		
		$units = ($booking['end_time'] - $booking['start_time'])/($booking['unit_value']*60);
	}else
	{		
		$registration_method = 'endtime';
		$unit_value = $pm_settings['unit_value'];
		$units = '0';
		$break_hours = gmdate('G', gmmktime(0,0,$booking['break_time']));
		$break_mins = gmdate('i', gmmktime(0,0,$booking['break_time']));
	}
			
	$book_start_date = date($_SESSION['GO_SESSION']['date_format'], $local_start_time);	
	$start_hour = date('G',$local_start_time);
	$start_min = date('i',$local_start_time);
	
	$book_end_date = date($_SESSION['GO_SESSION']['date_format'], $local_end_time);
	$end_hour = date('G',$local_end_time);
	$end_min =date('i',$local_end_time);	
	
	$book_comments = $booking['comments'];
	$int_fee_value = $booking['int_fee_value'];
	$int_fee_time = $booking['int_fee_time'];
	$ext_fee_value = $booking['ext_fee_value'];
	$ext_fee_time = $booking['ext_fee_time'];
}else
{
	$title = $pm_enter_data;
	$registration_method = $pm_settings['registration_method'];
	
	if(isset ($_REQUEST['project_id']))
	{
		if(is_array($_REQUEST['project_id']))
		{
				$project_id = $_REQUEST['project_id']['value'];
		}else
		{
			$project_id = $_REQUEST['project_id'];
		}
	}else
	{
		$project_id = 0;
	}
	$pm_user_id = isset($_REQUEST['pm_user_id']['value']) ? $_REQUEST['pm_user_id']['value'] : $GO_SECURITY->user_id;
	$book_start_date = isset($_POST['book_start_date']) ? $_POST['book_start_date'] : $timer_start_date;
	
	$hour = isset($timer_start_time) ? date('G', $timer_start_time) : 8;
	$min = isset($timer_start_time) ? date('i', $timer_start_time) : 0;
	$start_hour = isset($_POST['start_hour']) ? $_POST['start_hour'] : $hour;
	$start_min = isset($_POST['start_min']) ? $_POST['start_min'] : $min;
	
	$timer_end_date = isset($timer_end_time) ? date($_SESSION['GO_SESSION']['date_format'], $timer_end_time) : $date;
	$book_end_date = isset($_POST['book_end_date']) ? $_POST['book_end_date'] : $timer_end_date;
	
	$hour = isset($timer_end_time) ? date('G', $timer_end_time) : 17;
	$end_hour = isset($_POST['end_hour']) ? $_POST['end_hour'] : $hour;
	
	$min = isset($timer_end_time) ? date('i', $timer_end_time) : 0;
	$end_min = isset($_POST['end_min']) ? $_POST['end_min'] : $min;
	
	$unit_value = $pm_settings['unit_value'];
	$units = isset($_POST['units']) ? smart_stripslashes($_POST['units']) : '1';
	
	$break_hours = isset($_POST['break_hours']) ? $_POST['break_hours'] : 0;
	$break_mins = isset($_POST['break_mins']) ? $_POST['break_mins'] : 0;	
	
	$book_comments =  isset($_POST['book_comments']) ? smart_addslashes($_POST['book_comments']) : '';
		
	$int_fee_value = isset($_POST['int_fee_value']) ? $_POST['int_fee_value'] : $pm_settings['int_fee_value'];
	$int_fee_time = isset($_POST['int_fee_time']) ? $_POST['int_fee_time'] : $pm_settings['int_fee_time'];
	
	$ext_fee_value = isset($_POST['ext_fee_value']) ? $_POST['ext_fee_value'] : $pm_settings['ext_fee_value'];
	$ext_fee_time = isset($_POST['ext_fee_time']) ? $_POST['ext_fee_time'] : $pm_settings['ext_fee_time'];
}

if (isset($_REQUEST['delete_hours']))
{
	$projects->delete_hours($_REQUEST['delete_hours']);
}

$tabtable = new tabtable('book_tab', $title, '100%', '400', '120');
$tabtable->print_head($return_to);
?>
<input type="hidden" name="booking_id" value="<?php echo $booking_id; ?>" />
<input type="hidden" name="post_action" />
<table border="0" cellpadding="0" cellspacing="0">
<tr>
	<td class="TableInside" valign="top">
	<?php
	if (isset($feedback)) echo $feedback;

	if ($timer = $projects->get_timer($GO_SECURITY->user_id))
	{
		echo 	'<table border="0" class="alert"><tr><td><img src="'.$GO_THEME->images['alert'].'" border="0" /></td>'.
				'<td><a class="normal" href="'.$_SERVER['PHP_SELF'].'?project_id='.$timer['project_id'].'&task=stop_timer">'.$pm_clocked_in.'</a></td></tr></table>';
	}
	?>
	<table border="0" cellpadding="0" cellspacing="5" width="100%">
	<?php	
	$select = new object_select('project', 'projects_form', 'project_id', $project_id);
	echo '<tr><td>';
	echo $select->get_link($strProject);
	echo ':</td><td>';
	echo $select->get_field();
	echo '</td></tr>';
	if ($GO_MODULES->write_permission)
	{
		$select = new object_select('user', 'projects_form', 'pm_user_id', $pm_user_id);
		echo '<tr><td>';
		echo $select->get_link($pm_employee);
		echo ':</td><td>';
		echo $select->get_field();
		echo '</td></tr>';
	}else
	{
		echo '<input type="hidden" name="pm_user_id[value]" value="'.$GO_SECURITY->user_id.'" />';
	}
	
	$fees = array();
	$fee_count = $projects->get_authorized_fees($GO_SECURITY->user_id);
	while($projects->next_record())
	{
		$fees[] = $projects->Record;
	}

	echo '<tr><td>'.$pm_internal_fee.':</td><td colspan="3">';

	$fee_select = new select('fee_id', '0/0');
	$fee_select->add_value('0/0', $cmdPleaseSelect);
	foreach($fees as $fee)
	{
		$fee_select->add_value(number_format($fee['value'], 2, $_SESSION['GO_SESSION']['decimal_seperator'], 
			$_SESSION['GO_SESSION']['thousands_seperator']).'/'.$fee['time'], $fee['name'].' ('.
			htmlspecialchars($_SESSION['GO_SESSION']['currency']).'&nbsp;'.
			number_format($fee['value'], 2, $_SESSION['GO_SESSION']['decimal_seperator'], 
			$_SESSION['GO_SESSION']['thousands_seperator']).'&nbsp;/&nbsp;'.
			$fee['time'].'&nbsp;'.$pm_mins.')');
	}
	$fee_select->set_attribute('onchange', 'javascript:set_int_fee(this);');
	echo $fee_select->get_html().'&nbsp;'.htmlspecialchars($_SESSION["GO_SESSION"]['currency']).'&nbsp;';
	
	$input = new input('text', 'int_fee_value', format_number($int_fee_value));
	$input->set_attribute('style', 'width:50px;text-align:right');
	$input->set_attribute('onfocus','this.select();');
	$input->set_attribute('onblur', "javascript:this.value=number_format(this.value, 2, '".$_SESSION['GO_SESSION']['decimal_seperator']."', '".$_SESSION['GO_SESSION']['thousands_seperator']."');");
	echo $input->get_html().'&nbsp;/&nbsp;';
	
	$select = new select('int_fee_time',$int_fee_time);
	for ($i=1;$i<=60;$i++)
	{
		$select->add_value($i,$i);
	}
	echo $select->get_html();
	
	echo '</td></tr>';

	echo '<tr><td>'.$pm_external_fee.':</td><td colspan="3">';
	
	$fee_select = new select('fee_id', '0/0');
	$fee_select->add_value('0/0', $cmdPleaseSelect);
	foreach($fees as $fee)
	{
		$fee_select->add_value(number_format($fee['value'], 2, $_SESSION['GO_SESSION']['decimal_seperator'], 
			$_SESSION['GO_SESSION']['thousands_seperator']).'/'.$fee['time'], $fee['name'].' ('.
			htmlspecialchars($_SESSION['GO_SESSION']['currency']).'&nbsp;'.
			number_format($fee['value'], 2, $_SESSION['GO_SESSION']['decimal_seperator'], 
			$_SESSION['GO_SESSION']['thousands_seperator']).'&nbsp;/&nbsp;'.
			$fee['time'].'&nbsp;'.$pm_mins.')');
	}
	
	$fee_select->set_attribute('onchange', 'javascript:set_ext_fee(this);');
	echo $fee_select->get_html().'&nbsp;'.htmlspecialchars($_SESSION["GO_SESSION"]['currency']).'&nbsp;';
	
	$input = new input('text', 'ext_fee_value', format_number($int_fee_value));
	$input->set_attribute('style', 'width:50px;text-align:right');
	$input->set_attribute('onfocus','this.select();');
	$input->set_attribute('onblur', "javascript:this.value=number_format(this.value, 2, '".$_SESSION['GO_SESSION']['decimal_seperator']."', '".$_SESSION['GO_SESSION']['thousands_seperator']."');");
	echo $input->get_html().'&nbsp;/&nbsp;';
	
	$select = new select('ext_fee_time',$ext_fee_time);
	for ($i=1;$i<=60;$i++)
	{
		$select->add_value($i,$i);
	}
	echo $select->get_html();
	
	echo '</td></tr>';

	?>
	<tr>
		<td><?php echo $pm_starttime; ?>:</td>
		<td>
		<?php
				$datepicker= new date_picker('book_start_date', $_SESSION['GO_SESSION']['date_format'], $book_start_date, '', '', 'onchange="javascript:check_date(this.name);"');
				echo $datepicker->get_html();
		echo '&nbsp;';
		$hours = array("00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23", "24");
		for ($i=0;$i<=60;$i++)
		{
			$text = strlen($i) < 2 ? '0'.$i : $i;
			$mins[] = $text;
		}
		
		$dropbox = new dropbox();
		$dropbox->add_arrays($hours, $hours);
		$dropbox->print_dropbox("start_hour", $start_hour, 'onchange="javascript:update_end_hour();"');

		echo '&nbsp;:&nbsp;';	
		
		$dropbox = new dropbox();
		$dropbox->add_arrays($mins, $mins);
		$dropbox->print_dropbox("start_min", $start_min, 'onchange="javascript:document.projects_form.end_min.value=this.value;"');
		?>
		</td>
		<td colspan="2">
		&nbsp;
		</td>
	</tr>
	<tr><td colspan="3">&nbsp;</td></tr>
	<tr>
		<td colspan="2">
		<?php
		if ($registration_method == 'units')
		{
			$unit_check = 'checked';
			$endtime_check = '';
		}else
		{
			$unit_check = '';
			$endtime_check = 'checked';
		}
		?>
		<input type="radio" name="registration_method" value="endtime" onclick="javascript:toggle_registration_method(this.value)" <?php echo $endtime_check; ?> /><?php echo $pm_endtime; ?>
		</td>
		<td colspan="2">
		<input type="radio" name="registration_method" value="units" onclick="javascript:toggle_registration_method(this.value)" <?php echo $unit_check; ?> /><?php echo $pm_units; ?>
		</td>
	</tr>

	<tr>
		<td><?php echo $pm_endtime; ?>:</td>
		<td>
		<?php
		$datepicker= new date_picker('book_end_date', $_SESSION['GO_SESSION']['date_format'], $book_end_date, '', '', 'onchange="javascript:check_date(this.name);"');
		echo $datepicker->get_html();
		echo '&nbsp;';
		$dropbox = new dropbox();
		$dropbox->add_arrays($hours, $hours);
		$dropbox->print_dropbox("end_hour", $end_hour);

		echo '&nbsp;:&nbsp;';
		
		$dropbox = new dropbox();
		$dropbox->add_arrays($mins, $mins);
		$dropbox->print_dropbox("end_min", $end_min);
		?>
		</td>
		<td>
		<?php echo $pm_value; ?>:
		</td>
		<td>
		<?php
		$dropbox = new dropbox();
		for ($i=1;$i<=60;$i++)
		{
			$dropbox->add_value($i,$i);
		}
		$dropbox->print_dropbox('unit_value', $unit_value);
		echo '&nbsp;'.$pm_mins;
		?>
		</td>
	</tr>
	<tr>
		<td><?php echo $pm_breaktime; ?>:</td>
		<td>
		<?php
		$dropbox = new dropbox();
		$dropbox->add_arrays($hours, $hours);
		$dropbox->print_dropbox("break_hours", $break_hours);
		echo '&nbsp;:&nbsp;';
		$dropbox = new dropbox();
		$dropbox->add_arrays($mins, $mins);
		$dropbox->print_dropbox("break_mins", $break_mins);
		?>
		</td>
		<td>
		<?php echo $pm_units; ?>:
		</td>
		<td>
		<input type="text" name="units" value="<?php echo $units; ?>" class="textbox" size="4" />
		</td>
	</tr>
	<tr><td colspan="3">&nbsp;</td></tr>
	<tr>
		<td valign="top"><?php echo $strComments; ?>:</td>
		<td colspan="3">
		<textarea class="textbox" name="book_comments" cols="40" rows="4"><?php echo htmlspecialchars($book_comments, ENT_QUOTES); ?></textarea>
		</td>
	</tr>
	<?php
	echo '<tr><td colspan="4">';
	$button = new button($cmdOk,"javascript:_save('save_hours', 'true')");
	echo $button->get_html();
	$button = new button($cmdApply,"javascript:_save('save_hours', 'false')");
	echo $button->get_html();
	$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
	echo $button->get_html();
	?>
	</table>
	</td>
</tr>
</table>
<?php
$tabtable->print_foot();
echo '</form>';
?>
<script type="text/javascript">
function toggle_registration_method(registration_method)
{
	if (registration_method == "endtime")
	{
		document.projects_form.unit_value.disabled = true;
		document.projects_form.units.disabled = true;
		document.projects_form.end_hour.disabled = false;
		document.projects_form.book_end_date.disabled = false;
		document.projects_form.end_min.disabled = false;
		document.projects_form.break_hours.disabled = false;
		document.projects_form.break_mins.disabled = false;
	}else
	{
		document.projects_form.unit_value.disabled = false;
		document.projects_form.units.disabled = false;
		document.projects_form.book_end_date.disabled = true;
		document.projects_form.end_hour.disabled = true;
		document.projects_form.end_min.disabled = true;
		document.projects_form.break_hours.disabled = true;
		document.projects_form.break_mins.disabled = true;
	}
}
toggle_registration_method("<?php echo $registration_method; ?>");

function check_date(changed_field)
{
	start_date = get_date(document.projects_form.book_start_date.value, '<?php echo $_SESSION['GO_SESSION']['date_format']; ?>', '<?php echo $_SESSION['GO_SESSION']['date_seperator']; ?>');
	end_date = get_date(document.projects_form.book_end_date.value, '<?php echo $_SESSION['GO_SESSION']['date_format']; ?>','<?php echo $_SESSION['GO_SESSION']['date_seperator']; ?>');
	
	if(end_date < start_date)
	{
		if(changed_field == 'book_start_date')
		{
			document.projects_form.book_end_date.value = document.projects_form.book_start_date.value;
		}else
		{
			document.projects_form.book_start_date.value = document.projects_form.book_end_date.value;
		}
	}
}

function set_ext_fee(select)
{
	var arr = select.value.split('/');
	document.forms[0].ext_fee_value.value=number_format(arr[0], 2, 
		'<?php echo $_SESSION['GO_SESSION']['decimal_seperator']; ?>', 
		'<?php echo $_SESSION['GO_SESSION']['thousands_seperator'];  ?>');
	document.forms[0].ext_fee_time.value=arr[1];
}

function set_int_fee(select)
{
	var arr = select.value.split('/');
	document.forms[0].int_fee_value.value=number_format(arr[0], 2, 
		'<?php echo $_SESSION['GO_SESSION']['decimal_seperator']; ?>', 
		'<?php echo $_SESSION['GO_SESSION']['thousands_seperator'];  ?>');
	document.forms[0].int_fee_time.value=arr[1];
}
		
function update_end_hour()
{
	var start_hour = parseInt(document.projects_form.start_hour.value);
	var end_hour = parseInt(document.projects_form.end_hour.value);
	if (start_hour == 23)
	{
		document.projects_form.end_hour.value='23';
		document.projects_form.end_min.value='30';				
	}else
	{
		if (start_hour >= end_hour)
		{		
			end_hour = start_hour+1;
			document.projects_form.end_hour.value=end_hour;
		}
	}
}
function _save(task, close)
{
	document.projects_form.task.value = task;
	document.projects_form.close.value = close;
	document.projects_form.submit();
}
function remove_client()
{
	document.projects_form.contact_id.value = 0;
	document.projects_form.contact_name.value = '';
	document.projects_form.contact_name_text.value = '';
}

function remove_user()
{
	document.projects_form.responsible_user_id.value = 0;
	document.projects_form.user_name.value = '';
	document.projects_form.user_name_text.value = '';
}

</script>
<?php
require_once ($GO_THEME->theme_path."footer.inc");
?>
