<?php

/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once ("../../Group-Office.php");

//authenticate the user
$GO_SECURITY->authenticate();

//see if the user has access to this module
//for this to work there must be a module named 'example'
$GO_MODULES->authenticate('cms');

require_once ($GO_MODULES->class_path.'cms.class.inc');
$cms = new cms();

//get the language file
require_once ($GO_LANGUAGE->get_language_file('cms'));

$task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';
$file_id = isset ($_REQUEST['file_id']) ? $_REQUEST['file_id'] : 0;
$folder_id = isset ($_REQUEST['folder_id']) ? $_REQUEST['folder_id'] : 0;
$link_back = 'edit.php?file_id='.$file_id.'&folder_id='.$folder_id;

if ($folder_id == 0 || $_SESSION['site_id'] == 0) {
	//no folder or site given so back off cowardly
	header('Location: index.php');
	exit ();
}

if ($task != '') {
	$name = smart_addslashes(trim($_POST['name']));
	$hot_item = isset ($_POST['hot_item']) ? '1' : '0';
	//fix for inserted iframes
	$content = preg_replace("'<iframe([^>]*)/>'si", "<iframe$1></iframe>", smart_addslashes($_POST['content']));

	$title = (isset($_POST['title']) && $_POST['title'] != '' && !isset($_POST['auto_meta'])) ? 
			smart_addslashes($_POST['title']) : 
			addslashes($cms->get_title_from_html(smart_stripslashes($content), smart_stripslashes($_POST['title'])));
							
	$description = (isset($_POST['description']) && $_POST['description'] != '' && !isset($_POST['auto_meta'])) ? 
			smart_addslashes($_POST['description']) : 
			addslashes($cms->get_description_from_html(smart_stripslashes($content), smart_stripslashes($_POST['description'])));
			
	$keywords = (isset($_POST['keywords']) && $_POST['keywords'] != '' && !isset($_POST['auto_meta'])) ? 
			smart_addslashes($_POST['keywords']) : 
			addslashes($cms->get_keywords_from_html(smart_stripslashes($content), smart_stripslashes($_POST['keywords'])));
	
	$auto_meta = isset($_POST['auto_meta']) ? '1' : '0';
				
	if ($file_id > 0) {		
		if ($name == '') {
			$feedback = $error_missing_field;
		} else {
			$name .= '.html';
			$existing_id = $cms->file_exists($folder_id, $name);
			if ($existing_id && ($_POST['file_id'] != $existing_id)) {
				$feedback = $fbNameExists;
			} else {				
				$cms->update_file(
					$file_id, 
					$name, 
					smart_addslashes($content), 
					$auto_meta, 
					$title, 
					$description, 
					$keywords, 
					$hot_item, 
					$_POST['template_item_id']);
			}
		}
	} else {

		if ($name == '') {
			$feedback =$error_missing_field;
		} else {
			$filename = $name.'.html';
			

			if ($cms->file_exists($folder_id, $filename)) {
				$feedback = $fbNameExists;
			}elseif (!$file_id = $cms->add_file(
				$folder_id, 
				$filename, 
				smart_addslashes($_POST['content']), 
				$title, 
				$description, 
				$keywords, 
				$_POST['template_item_id'],
				$auto_meta,
				$hot_item))
			{
				$feedback = $strSaveError;
			}
		}
	}
}

//get the site template
if ($site = $cms->get_site($_SESSION['site_id'])) {
	//$language = $cms->get_language($_SESSION['language_id']);
	$template = $cms->get_template($site['template_id']);
}

if ($file_id > 0) {
	$file = $cms->get_file($file_id);	
} else {
	$file['name'] = isset($_POST['name']) ? smart_stripslashes($_POST['name']) : '';	
	$file['hot_item'] = isset ($_POST['hot_item']) ? '1' : '0';
	//fix for inserted iframes
	$file['content'] = isset($_POST['content']) ? preg_replace("'<iframe([^>]*)/>'si", "<iframe$1></iframe>", smart_stripslashes($_POST['content'])) : '';	
	$file['title'] = isset($_POST['title']) ? smart_stripslashes($_POST['title']) : '';	
	$file['description'] = isset($_POST['description']) ? smart_stripslashes($_POST['description']) : '';	
	$file['keywords'] = isset($_POST['keywords']) ? smart_stripslashes($_POST['keywords']) : '';	
	if($task == 'save')
	{
			$file['auto_meta'] = isset($_POST['auto_meta']) ? '1' : '0';
	}else
	{
		$file['auto_meta'] = '1';
	}
	$file['folder_id'] = $folder_id;
	
	if(isset($_REQUEST['template_item_id']))
	{
		$file['template_item_id']=$_REQUEST['template_item_id'];
	}else
	{
		$folder = $cms->get_folder($file['folder_id']);
		$file['template_item_id']=$folder['template_item_id'];
	}
}


//require the header file. This will draw the logo's and the menu
require_once ($GO_THEME->theme_path."header.inc");


$form = new form('editor');
$form->set_attribute('style','height:100%');
$form->add_html_element(new input('hidden', 'file_id', $file_id, false));
$form->add_html_element(new input('hidden', 'folder_id', $file['folder_id']));
$form->add_html_element(new input('hidden', 'unedited', ''));
$form->add_html_element(new input('hidden', 'task', 'save'));

$table = new table();
$table->set_attribute('style','height:100%;width:100%');

if (isset ($feedback))
{
	$cell = new table_cell($feedback);
	$cell->set_attribute('class','Error');
	$cell->set_attribute('colspan','2');
	$row =new table_row();
	$row->add_cell($cell);
	
	$table->add_row($row);
}



$menu = new button_menu();

$menu->add_button('save_big', $cmdSave, "javascript:_save('save');");
if ($file_id > 0) {
	$menu->add_button('magnifier_big', $cms_preview, 'view.php?site_id='.
		$_SESSION['site_id'].'&folder_id='.$file['folder_id'].'&file_id='.$file['id'], array('target'=>'_blank'));
}
$menu->add_button('components', $cms_insert_component, "javascript:popup('components/select.php', '300','400');");
$menu->add_button('close', $cmdClose, 'javascript:confirm_close(\''.$GO_MODULES->url.'browse.php?folder_id='.$file['folder_id'].'\');');

$cell = new table_cell($menu->get_html());
$cell->set_attribute('colspan','2');
$row =new table_row();
$row->add_cell($cell);
$table->add_row($row);


$htmleditor = new htmleditor('content');
$htmleditor->setImagePath('cms/'.$_SESSION['site_id'].'/images/');
$htmleditor->SetConfig('CustomConfigurationsPath', $GO_MODULES->url.'fckconfig.js');
$htmleditor->SetConfig('EditorAreaCSS', $GO_MODULES->url.'stylesheet.php?template_id='.$site['template_id'].'&editor=true');
$htmleditor->Value		=  $file['content'];
$htmleditor->ToolbarSet='cms';

$htmleditor->SetConfig('LinkBrowser',true);
$htmleditor->SetConfig('LinkBrowserURL', $GO_MODULES->modules['cms']['url'].'select.php');

$row = new table_row();
$cell = new table_cell($htmleditor->CreateHtml());
$cell->set_attribute('style','height:100%;');
$row->add_cell($cell);


$cell = new table_cell();
$cell->set_attribute('valign','top');
$cell->set_attribute('style','width:400px;');



$tabstrip = new dynamic_tabstrip('cms_properties', $fbProperties, 160);
$tabstrip->set_attribute('style','width:100%;margin-bottom:20px;');

$subtable = new table();
$subtable->set_attribute('style','width:100%;');
$subrow = new table_row();
$subrow->add_cell(new table_cell($strName.':'));
$input = new input('text','name', strip_extension($file['name']), false);
$input->set_attribute('style','width:100%');
$subrow->add_cell(new table_cell($input->get_html()));
$subtable->add_row($subrow);

$subrow = new table_row();
$subrow->add_cell(new table_cell($cms_template_item.':'));

$select = new select("template_item_id", $file['template_item_id']);
$cms->get_template_items($site['template_id'], true);
while($cms->next_record())
{
	$select->add_value($cms->f('id'), $cms->f('name'));
}
$subcell = new table_cell($select->get_html());
$subrow->add_cell($subcell);
$subtable->add_row($subrow);

$subrow = new table_row();
$checkbox = new checkbox('hot_item','hot_item', '1', $cms_hot_item, ($file['hot_item'] == '1'));
$subcell = new table_cell($checkbox->get_html());
$subcell->set_attribute('colspan','2');
$subrow->add_cell($subcell);
$subtable->add_row($subrow);

$tabstrip->add_tab('properties', $strProperties, $subtable);

$subtable = new table();
$subtable->set_attribute('style','width:100%;');
$subrow = new table_row();
$checkbox = new checkbox('auto_meta','auto_meta','1', $cms_autogenerate_searchengine_info, ($file['auto_meta'] == '1'));
$subcell = new table_cell($checkbox->get_html());
$subcell->set_attribute('colspan','2');
$subrow->add_cell($subcell);
$subtable->add_row($subrow);

$subrow = new table_row();
$subrow->add_cell(new table_cell($strTitle.':'));
$input = new input('text','title', strip_extension($file['title']), false);
$input->set_attribute('style','width:100%');
$subrow->add_cell(new table_cell($input->get_html()));
$subtable->add_row($subrow);


$subrow = new table_row();
$subrow->add_cell(new table_cell($strDescription.':'));
$input = new textarea('description', $file['description']);
$input->set_attribute('style','width:100%;height:60px;');
$subcell = new table_cell($input->get_html());
$subcell->set_attribute('style','width:100%;');
$subrow->add_cell($subcell);
$subtable->add_row($subrow);

$subrow = new table_row();
$subrow->add_cell(new table_cell($cms_keywords.':'));
$input = new textarea('keywords', $file['keywords']);
$input->set_attribute('style','width:100%;height:60px;');
$subcell = new table_cell($input->get_html());
$subcell->set_attribute('style','width:100%;');
$subrow->add_cell($subcell);
$subtable->add_row($subrow);
//$tabstrip->add_html_element($subtable);

$tabstrip->add_tab('meta', $cms_searchengine_info, $subtable);


$cell->add_html_element($tabstrip);

$row->add_cell($cell);
$table->add_row($row);

$form->add_html_element($table);

echo $form->get_html();
?>
  <script type="text/javascript">

  function confirm_close(URL)
  {
  	//TODO: detect if content has been changed
  	//if (confirm('<?php echo $cms_confirm_close; ?>'))
  	//{
  	document.location=URL;
  	//}
  }

  
  function _save(task)
  {
  	document.editor.task.value=task;
  	document.editor.submit();
  }
</script>

<?php
require_once ($GO_THEME->theme_path."footer.inc");
?>
