<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

class cms_site extends cms {
	var $site;
	var $template;
	var $publish_url;
	var $publish_path;
	var $publish_static = false;
	var $template_file_replacements = array ();

	var $folder_id;
	var $file_id;
	var $task;

	var $tags = array (		
		'script', //important as first tag so it can produce tags that will be processed
		'template',
		'home', 
		'folders', 
		'rootfolders', 
		'files', 
		'path', 
		'icon', 
		'login', 
		'back', 
		'active_doc', 
		'document', 
		'folderlist', 
		'hot_items', 
		'languages', 
		'items', 
		'menu', 
		'treeview', 
		'filename'
		);

	function cms_site() {
		global $GO_CONFIG, $GO_LANGUAGE;
		$this->db();

		$this->folder_id = isset ($_REQUEST['folder_id']) ? $_REQUEST['folder_id'] : 0;
		$this->file_id = isset ($_REQUEST['file_id']) ? $_REQUEST['file_id'] : 0;
		$this->task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';

		$site_id = isset ($_REQUEST['site_id']) ? $_REQUEST['site_id'] : 0;

		//If a site_id was passed then get it
		if ($site_id > 0) {
			$this->site = $this->get_site($site_id);
		}else
		{
			/*
			if no site_id was passed then we are not in Group-Office but somebody is
			requesting the site through a domain. Try to get the site by domain.
			
			Get the domain name without this page eg.
			http://www.test.com/test/index.php?file_id=0&folder_id=9 becomes:
			www.test.com/test
			*/
			$domain = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
			if (strpos($domain, basename($_SERVER['PHP_SELF'])) !== false) {
				//chop off filename
				$pos = strrpos($domain, '/');
				if ($pos !== false) {
					$domain = substr($domain, 0, $pos);
				}
			}
			if (!$this->site = $this->get_site_by_domain($domain, true)) {
				exit();
			}
		}
	}

	function publish() {
		global $GO_CONFIG;

		require_once ($GO_CONFIG->class_path.'filesystem.class.inc');
		$fs = new filesystem(true);

		if (!file_exists($this->publish_path)) {
			return false;
		}

		$fs->delete($this->publish_path);
		mkdir($this->publish_path);

		if ($this->site['publish_style'] == '2') {
			$this->publish_static = true;

			mkdir($this->publish_path.'_site_data');
			mkdir($this->publish_path.'_search');

			$file = '<?php $site_id='.$this->site["id"].';
									require_once("'.$GO_CONFIG->root_path.'Group-Office.php");
									if ($cms_module = $GO_MODULES->get_module("cms"))
									{
										$published = true;
										require_once($GO_CONFIG->root_path.$cms_module["path"]."view.inc");
									}else
									{
										die("Failed to get Content Management Module");
									}
									?>';

			if (!$fp = fopen($this->publish_path.'_search/index.php', 'w+')) {
				return false;
			}
			elseif (!fwrite($fp, $file)) {
				fclose($fp);
				return false;
			} else {
				fclose($fp);
			}

			$this->create_stylesheet($this->publish_path.'_site_data'.$GO_CONFIG->slash.'style.css');
			$this->create_template_files();

			return $this->create_files($this->site['root_folder_id'], $this->publish_path);

		} else {
			$file = '<?php $site_id='.$this->site["id"].';
									require_once("'.$GO_CONFIG->root_path.'Group-Office.php");
									if ($cms_module = $GO_MODULES->get_module("cms"))
									{
										$published = true;
										require_once($GO_CONFIG->root_path.$cms_module["path"]."view.inc");
									}else
									{
										die("Failed to get Content Management Module");
									}
									?>';

			if (!$fp = fopen($this->publish_path.'index.php', 'w+')) {
				return false;
			}
			elseif (!fwrite($fp, $file)) {
				fclose($fp);
				return false;
			} else {
				return fclose($fp);
			}
		}
	}

	function create_stylesheet($path) {
		global $GO_CONFIG;

		$file = '';
		if ($template = $this->get_template($this->site['template_id'])) {
			$file = $template['style'];
		}

		if (!$fp = fopen($path, 'w+')) {
			return false;
		}
		elseif (!fwrite($fp, $file)) {
			fclose($fp);
			return false;
		} else {
			fclose($fp);
		}
		return true;
	}

	function create_template_files() {
		global $GO_CONFIG, $GO_MODULES;

		$cms_module = $GO_MODULES->get_module('cms');

		$this->get_template_files($this->site['template_id']);

		while ($this->next_record()) {
			if (!$fp = fopen($this->publish_path.'_site_data'.$GO_CONFIG->slash.$this->f('name'), 'w+')) {
				return false;
			}
			elseif (!fwrite($fp, $this->f('content'))) {
				fclose($fp);
				return false;
			} else {
				fclose($fp);
			}

			$tpl_file['dynamic'] = $cms_module['url'].'template_file.php?template_file_id='.$this->f('id');
			$tpl_file['static'] = $this->publish_url.'_site_data/'.$this->f('name');
			$this->template_file_replacements[] = $tpl_file;
		}
	}

	function create_files($folder_id, $path) {
		global $GO_CONFIG, $GO_MODULES;

		$cms_module = $GO_MODULES->get_module("cms");

		$cms_site = new cms_site($this->site['id']);

		$cms_site->get_folders($folder_id);

		while ($cms_site->next_record()) {
			$new_path = $path.urlencode($cms_site->f('name')).$GO_CONFIG->slash;

			if (!file_exists($new_path)) {
				mkdir($new_path);
			}

			if (!is_writable($new_path) || !$this->create_files($cms_site->f('id'), $new_path)) {
				return false;
			}
		}

		$index_created = false;
		$cms_site->get_files($folder_id, 'priority', 'ASC');
		while ($cms_site->next_record()) {
			if ($folder_id == $this->site['root_folder_id'] && !$index_created) {
				$name = 'index.html';
				$index_created = true;
			} else {
				$name = $cms_site->f('name');
			}

			$full_path = $path.urlencode($name);
			$file = $this->generate_page($cms_site->f('id'));
			if (!$fp = fopen($full_path, 'w+')) {
				return false;
			}
			elseif (!fwrite($fp, $file)) {
				fclose($fp);
				return false;
			} else {
				fclose($fp);
			}

			$tpl_file['dynamic'] = $cms_module['full_url'].'view.php?site_id='.$this->site['id'].'&amp;file_id='.$cms_site->f('id');
			$tpl_file['static'] = str_replace($this->publish_path, $this->publish_url, $full_path);
			$this->template_file_replacements[] = $tpl_file;
		}
		return true;
	}

	function generate_header($title = '', $keywords = '', $description = '') {
		global $GO_CONFIG, $GO_MODULES, $charset;

		$cms_module = isset ($cms_module) ? $cms_module : $GO_MODULES->get_module('cms');

		$header = '<?xml version="1.0" encoding="'.$charset.'"?>'."\r\n". 
							'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'."\r\n".	
		 					'<html xmlns="http://www.w3.org/1999/xhtml">'."\r\n".
							'<head>'."\r\n".
							'<meta http-equiv="Content-Type" content="text/html; charset='.$charset.'" />'."\r\n".
							'<meta name="robots" content="all,index,follow" />'."\r\n".
							'<meta name="revisit-after" content="7 days" />'."\r\n".
							'<meta name="keywords" content="'.$keywords.'" />'."\r\n".
							'<meta name="description" content="'.$description.'" />'."\r\n".
							'<meta name="Generator" content="Group-Office '.$GO_CONFIG->version.'" />'."\r\n".
							'<title>'.$title.'</title>'."\r\n";

		if ($this->publish_static) {
			$header .= '<link href="'.$this->publish_url.'_site_data/style.css" rel="stylesheet" type="text/css" />'."\r\n";
		} else {
			$header .= '<link href="'.$cms_module['url'].'stylesheet.php?template_id='.$this->site['template_id'].'" rel="stylesheet" type="text/css" />'."\r\n";
			$header .= '<link href="'.$cms_module['url'].'stylesheet.php?print=true&amp;template_id='.$this->site['template_id'].'" rel="stylesheet" type="text/css" media="print" />'."\r\n";
		}
		$header .= '<script type="text/javascript" src="'.$GO_CONFIG->host.'javascript/common.js"></script>'."\r\n".
										'</head>'."\r\n".
										'<body>'."\r\n".
										"\r\n<!-- End of generated header --> \r\n\r\n";
										
		return $header;
	}

	function generate_footer() {
		
		return "\r\n\r\n<!-- Start of generated Footer --> \r\n\r\n".
							'</body>'."\r\n".
							'</html>'."\r\n";
	}

	function generate_frontpage() {
		$frontpage_template_item = $this->get_template_item($this->template['frontpage_template_item_id']);

		//$page = $this->generate_header($this->site['name'], $this->site['keywords'], $this->site['description']);
		$page = $this->generate_header($this->site['name'], '', '');
		$page .= $this->parse_template($frontpage_template_item['content']);
		$page .= $this->generate_footer();
		return $page;
	}

	function find_page($folder_id) {
		$this->get_files($folder_id);
		while ($this->next_record()) {
			if (eregi('htm', $this->f('extension'))) {
				return $this->f('id');
			}
		}
	/*	$this->get_folders($folder_id);
		while ($this->next_record()) {
			return $this->find_page($this->f('id'));
		}*/
		return false;
	}

	function generate_page() {
		global $GO_CONFIG, $GO_MODULES, $GO_LANGUAGE, $cms_empty, $cms_there_are_results_for_multiple, $cms_there_are_results_for_single;


			$cms_module = $GO_MODULES->get_module('cms');
	
			//set the folder id we are in
			if ($this->folder_id == 0) {
				if ($this->template['activate_frontpage'] == '1' && $this->task == '') {
					return $this->generate_frontpage();
				} else {
					$this->folder_id = $this->site['root_folder_id'];
				}
			}
	
			$folder = $this->get_folder($this->folder_id);
	
			/*
			 * if someone enter's a disabled folder redirect it to the root folder'
			if ($folder['disabled'] == '1') {
				$this->folder_id = $this->site['root_folder_id'];
				$folder = $this->get_folder($this->folder_id);
				$this->file_id = 0;
			}*/
	
			if ($this->task == '' && ($folder['multipage'] == '1')) {
				$this->task = 'multipage_display';
			}
	
			require_once ($GO_LANGUAGE->get_language_file('cms'));
	
			if ($this->file_id == 0) {
				$this->file_id = $this->find_page($this->folder_id);
			}
	
			if ($this->file_id > 0) {
				$file = $this->get_file($this->file_id);
				
				 if($file['folder_id'] != $this->folder_id)
					{
		        $this->folder_id = $file['folder_id'];
		        $folder = $this->get_folder($this->folder_id);
					}
				
				if (!eregi('htm', $file['extension'])) {
					return $file['content'];
				}
			} else {
				$file['title'] = '';
				$meta_title = '';
				$file['keywords'] = '';
				$file['description'] = '';
			}
			
		$template_item_id = $this->file_id > 0 && $file['template_item_id'] > 0 ? $file['template_item_id'] : $folder['template_item_id'];
		$main_template_item = $this->get_template_item($template_item_id);

		$max_length = 300;
		$print_title = 'false';
		$title_class = '';
		$class = '';
		$read_more_class = '';
		$read_more_text = '';
		$template = '';
		$item_template = '';
		$hide_hot_items = 'false';

		if ($main_template_item) {
			
			$main_template_content = $this->parse_template($main_template_item['content']);
			
			$content_tag = $this->get_tag('content', $main_template_content);
			$attributes = $this->get_attributes($content_tag);

			//max_length for multipage display
			$max_length = isset ($attributes['max_length']) ? $attributes['max_length'] : $max_length;
			$class = isset ($attributes['class']) ? $attributes['class'] : $class;
			$print_title = isset ($attributes['print_title']) ? $attributes['print_title'] : $print_title;
			$title_class = isset ($attributes['title_class']) ? $attributes['title_class'] : $title_class;
			$read_more_class = isset ($attributes['read_more_class']) ? $attributes['read_more_class'] : $read_more_class;
			$read_more_text = isset ($attributes['read_more_text']) ? $attributes['read_more_text'] : $read_more_text;
			$template = isset ($attributes['template']) ? $attributes['template'] : $template;
			$item_template = isset ($attributes['item_template']) ? $attributes['item_template'] : $item_template;
			$hide_hot_items = isset ($attributes['hide_hot_items ']) ? $attributes['hide_hot_items'] : $hide_hot_items;
		}
		$page = $this->generate_header($file['title'], $file['keywords'], $file['description']);

		switch ($this->task) {

			case 'multipage_display' :
				$content = '';
				if ($this->file_id > 0) {
					if ($print_title == 'true') {
						$content = '<h1 class="'.$title_class.'">'.$file['title'].'</h1>';
					}
					$content .= $file['content'];
				}

				$template = $this->get_template_item_by_name($this->site['template_id'], $template);
				if ($template) {
					$template_content = $this->parse_template($template['content']);
				} else {
					$template_content = false;
				}
				$multipage = $this->build_multipage($this->folder_id, $max_length, $template, $class, true, $title_class, $read_more_class, $read_more_text, $hide_hot_items);
				if ($template_content) {
					$multipage = str_replace($this->get_tag('content', $template_content), $multipage, $template_content);
				}

				$content .= $multipage;

				if (!$this->publish_static) {
					$content = str_replace($cms_module['full_url'].'view.php', $_SERVER['PHP_SELF'], $content);
				}
				if (isset ($content_tag)) {
					$page .= str_replace($content_tag, $content, $main_template_content);
				} else {
					$page .= $content;
				}
				break;

			default :

				if ($this->file_id > 0) {
					$content = '';
					if ($print_title == 'true') {
						$content = '<h1 class="'.$title_class.'">'.$file['title'].'</h1>';
					}
					$content .= $file['content'];

					if (!$this->publish_static) {
						$content = str_replace($cms_module['full_url'].'view.php', $_SERVER['PHP_SELF'], $content);
					}
					if (isset ($main_template_content)) {
						$page .= str_replace($this->get_tag('content', $main_template_content), $content, $main_template_content);
					} else {
						$page .= $content;
					}
				} else {
					//get the language file
					require_once ($GO_LANGUAGE->get_language_file('cms'));
					if (isset ($main_template_content)) {
						$page .= str_replace($this->get_tag('content', $main_template_content), $cms_empty, $main_template_content);
					} else {
						$page .= $cms_empty;
					}
				}
				break;
		}

		$page .= $this->generate_footer();

		if ($this->publish_static) {
			for ($i = 0; $i < count($this->template_file_replacements); $i ++) {
				$page = str_replace($this->template_file_replacements[$i]['dynamic'], $this->template_file_replacements[$i]['static'], $page);
			}
		}

		return $page;
	}

	function build_multipage($folder_id, $max_length, $template_name, $class, $print_title, $title_class, $read_more_class, $read_more_text, $hide_hot_items, $hot_items = false) {
		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);
		if ($template) {
			$template_content = $this->parse_template($template['content']);
		} else {
			$template_content = false;
		}

		$show = $this->file_id > 0 ? false : true;
		$multipage = '';
		if ($folder = $this->get_folder($folder_id)) {
			if ($hot_items) {
				$this->get_hot_items($folder_id);
			} else {
				$this->get_files($folder_id);
			}

			while ($this->next_record()) {
				if ((($show && ($hide_hot_items == 'false' || $this->f('hot_item') != '1')) || $hot_items) && eregi('htm', $this->f('extension'))) {
					$multipage_item = '<div class="'.$class.'">';
					if ($print_title == 'true') {
						//$title = $this->f('title') != '' ? $this->f('title') : strip_extension($this->f('name'));
						$multipage_item .= '<h1 class="'.$title_class.'">'.strip_extension($this->f('name')).'</h1>';
					}
					if ($max_length > 0) {
						$stripped_content = $this->strip_for_multipage($this->f('content'));

						$content = cut_string($stripped_content, $max_length);
						$multipage_item .= $content;

						if (strlen($this->f('content')) != strlen($content)) {
							$multipage_item .= '<br /><div style="text-align:right;"><a class="'.$read_more_class.'" href="'.$this->create_url($this->f('folder_id'), $this->f('id')).'">'.$read_more_text.'</a></div>';
						}
					}
					$multipage_item .= '</div>';

					if ($template_content) {
						$multipage .= str_replace($this->get_tag('content', $template_content), $multipage_item, $template_content);
					} else {
						$multipage .= $multipage_item;
					}
				}
				if ($this->file_id == $this->f('id')) {
					$show = true;
				}
			}
			return $this->build_multipage_recursive($folder_id, $max_length, $template_content, $class, $print_title, $title_class, $read_more_class, $read_more_text, $hide_hot_items, $hot_items, $multipage);
		} else {
			return false;
		}
	}

	function build_multipage_recursive($folder_id, $max_length, $template_content, $class, $print_title, $title_class, $read_more_class, $read_more_text, $hide_hot_items, $hot_items = false, $multipage = '') {
		$cms_site = new cms_site();

		if ($this->get_folders($folder_id)) {
			while ($this->next_record()) {
				if ($this->f('disabled') != '1') {
					if ($hot_items) {
						$cms_site->get_hot_items($this->f('id'));
					} else {
						$cms_site->get_files($this->f('id'));
					}
					while ($cms_site->next_record()) {

						if ((($this->file_id != $cms_site->f('id') && ($hide_hot_items == 'false' || $cms_site->f('hot_item') != '1')) || $hot_items) && eregi('htm', $cms_site->f('extension'))) {
							$multipage_item = '<div class="'.$class.'">';
							if ($print_title == 'true') {
								//$title = $cms_site->f('title') != '' ? $cms_site->f('title') : strip_extension($cms_site->f('name'));
								$multipage_item .= '<h1 class="'.$title_class.'" >'.strip_extension($cms_site->f('name')).'</h1>';
							}
							if ($max_length > 0) {
								$stripped_content = $this->strip_for_multipage($cms_site->f('content'));

								$content = cut_string($stripped_content, $max_length);
								$multipage_item .= $content;

								if (strlen($cms_site->f('content')) != strlen($content)) {
									$multipage_item .= '<br /><div style="text-align:right;"><a class="'.$read_more_class.'" href="'.$this->create_url($cms_site->f('folder_id'), $cms_site->f('id')).'">'.$read_more_text.'</a></div>';
								}

							}
							$multipage_item .= '</div>';
							if ($template_content) {
								$multipage .= str_replace($this->get_tag('content', $template_content), $multipage_item, $template_content);
							} else {
								$multipage .= $multipage_item;
							}
						}
						if (!$hot_items) {
							break;
						}
					}
					$multipage .= $cms_site->build_multipage_recursive($this->f('id'), $max_length, $template_content, $class, $print_title, $title_class, $read_more_class, $read_more_text, $hide_hot_items, $hot_items);
				}
			}
		}
		return $multipage;
	}

	function print_hot_items($attributes) {
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$max_length = isset ($attributes['max_length']) ? $attributes['max_length'] : '0';
		$print_title = isset ($attributes['print_title']) ? $attributes['print_title'] : 'true';
		$title_class = isset ($attributes['title_class']) ? $attributes['title_class'] : '';
		$read_more_class = isset ($attributes['read_more_class']) ? $attributes['read_more_class'] : '';
		$read_more_text = isset ($attributes['read_more_text']) ? $attributes['read_more_text'] : 'Read more';
		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$item_template = isset ($attributes['item_template']) ? $attributes['item_template'] : '';
		$print_root_only = isset ($attributes['print_root_only']) ? $attributes['print_root_only'] : 'false';

		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);
		if ($template) {
			$template_content = $this->parse_template($template['content']);
		} else {
			$template_content = false;
		}

		if ($print_root_only == 'true' && $this->folder_id != $this->site['root_folder_id']) {
			return '';
		} else {
			$multipage = $this->build_multipage($this->site['root_folder_id'], $max_length, $item_template, $class, $print_title, $title_class, $read_more_class, $read_more_text, false, true);
			if ($template_content) {
				$multipage = str_replace($this->get_tag('content', $template_content), $multipage, $template_content);
			}
			return $multipage;
		}
	}
	
	function print_template($attributes)
	{
		if(!empty($attributes['name']))
		{
			if($template = $this->get_template_item_by_name($this->site['template_id'], $attributes['name']))
			{
				return $this->parse_template($template['content']);
			}
		}
		return '';
	}

	function create_url($folder_id, $file_id = 0) {
		$cms_site = new cms_site($this->site['id']);

		if ($this->publish_static) {
			$url = '';
			if ($file_id == 0 && $folder_id > 0) {
				$cms_site->get_files($folder_id, 'priority', 'ASC');
				while ($cms_site->next_record()) {
					if (eregi('htm', $cms_site->f('extension'))) {
						$file_id = $cms_site->f('id');
						break;
					}
				}
			}

			if ($file_id > 0) {
				$file = $cms_site->get_file($file_id);
				$folder_id = $file['folder_id'];
				if ($folder_id != $this->site['root_folder_id']) {
					$url = urlencode(urlencode($file['name']));
				} else {
					$url = 'index.html';
				}
			}

			if ($folder_id > 0 && $folder_id != $this->site['root_folder_id']) {
				while ($folder_id != $this->site['root_folder_id']) {
					$folder = $cms_site->get_folder($folder_id);
					$url = urlencode(urlencode($folder['name'])).'/'.$url;
					$folder_id = $folder['parent_id'];
				}
			}
			return $this->publish_url.$url;
		} else {
			return $_SERVER['PHP_SELF'].'?folder_id='.$folder_id.'&amp;file_id='.$file_id;
		}
	}

	function print_icon() {
		global $extension, $GO_CONFIG;
		return '<img border="0" align="absmiddle" src="'.get_filetype_image($extension).'" />';
	}

	function print_home($attributes) {			
		$text = isset ($attributes['text']) ? $attributes['text'] : '';
		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$active_template_name = isset ($attributes['active_template']) ? $attributes['active_template'] : $template_name;
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$active_class = isset ($attributes['active_class']) ? $attributes['active_class'] : $class;
		$print_at_home = isset ($attributes['print_at_home']) ? $attributes['print_at_home'] : 'true';

		if ($this->folder_id == $this->site['root_folder_id'] ) {
			if($print_at_home != 'true') {
				return '';
			}
			$template = $this->get_template_item_by_name($this->site['template_id'], $active_template_name);
			$class =  $active_class ;
		} else {
			$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);
		}
		$home = '<a class="'.$class.'" href="'.$_SERVER['PHP_SELF'].'?folder_id='.$this->site['root_folder_id'].'">'.$text.'</a>';
		if ($template) {
			$template_content = $this->parse_template($template['content']);
			$home = str_replace($this->get_tag('content', $template_content), $home, $template_content);
		}

		return $home;
	}

	function print_path($attributes) {
		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$item_template_name = isset ($attributes['item_template']) ? $attributes['item_template'] : '';
		$active_item_template_name = isset ($attributes['active_item_template']) ? $attributes['active_item_template'] : $item_template_name;
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$active_class = isset ($attributes['active_class']) ? $attributes['active_class'] : $class;

		$path = '';
		$id = $this->folder_id;

		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);
		$item_template_passive = $this->get_template_item_by_name($this->site['template_id'], $item_template_name);
		$item_template_active = $this->get_template_item_by_name($this->site['template_id'], $active_item_template_name);

		$folder = $this->get_folder($id);

		while ($folder['parent_id'] != 0) {
			$item_template = ($this->folder_id == $id) ? $item_template_active : $item_template_passive;
			$_class = ($this->folder_id == $id) ? $active_class : $class;
			if ($item_template) {
				$item_template_content = $this->parse_template($item_template['content']);
				$path = str_replace($this->get_tag('content', $item_template_content), '<a class="'.$class.'" href="'.$this->create_url($folder['id']).'">'.$folder['name'].'</a>', $item_template_content).$path;
			} else {
				$path = '<a class="'.$_class.'" href="'.$this->create_url($folder['id']).'">'.$folder['name'].'</a>'.$path;
			}

			$id = $folder['parent_id'];
			$folder = $this->get_folder($id);
		}

		if ($template) {
			$template_content = $this->parse_template($template['content']);
			$path = str_replace($this->get_tag('content', $template_content), $path, $template_content);
		}
		return $path;
	}

	function print_active_doc($attributes) {
		global $extension;

		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$class = isset ($attributes['class']) ? $attributes['class'] : '';

		$current_file = '';

		if (isset ($this->file_id) && $file = $this->get_file($this->file_id)) {
			$extension = get_extension($file['name']);
			$title = ($file['title'] == '') ? strip_extension($file['name']) : $file['title'];

			if ($template = $this->get_template_item_by_name($this->site['template_id'], $template_name)) {
				$current_file = $this->parse_template($template['content']);
			}

			$current_file = str_replace($this->get_tag('content', $current_file), '<span class="'.$class.'">'.$title.'</span>', $current_file);
		}
		return $current_file;
	}

	
	function print_folders($attributes) {
		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$item_template_name = isset ($attributes['item_template']) ? $attributes['item_template'] : '';
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$print_rootfolders = isset ($attributes['print_rootfolders']) ? $attributes['print_rootfolders'] : 'true';

		$folders = '';
		$item_template = $this->get_template_item_by_name($this->site['template_id'], $item_template_name);
		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);

		if ($print_rootfolders == 'true' || $this->folder_id != $this->site['root_folder_id']) {
			$count = $this->get_visible_folders($this->folder_id);
			if ($count > 0) {
				while ($this->next_record()) {
					if ($item_template) {
						$item_template_content = $this->parse_template($item_template['content']);
						$folders .= str_replace($this->get_tag('content', $item_template_content), '<a class="'.$class.'" href="'.$this->create_url($this->f('id')).'" title="'.$this->f('name').'">'.$this->f('name').'</a>', $item_template_content);
					} else {
						$folders .= '<a class="'.$class.'" title="'.$this->f('name').'" href="'.$this->create_url($this->f('id')).'">'.$this->f('name').'</a>';
					}
				}
				if ($template) {
					$template_content = $this->parse_template($template['content']);
					$folders = str_replace($this->get_tag('content', $template_content), $folders, $template_content);
				}
			}
		}
		return $folders;
	}

	function print_back($attributes) {
		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$text = isset ($attributes['text']) ? $attributes['text'] : '';
		$print_rootfolders = isset ($attributes['print_rootfolders']) ? $attributes['print_rootfolders'] : 'true';

		$back = '';
		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);

		$folder = $this->get_folder($this->folder_id);

		if ($folder['parent_id'] != 0 && ($print_rootfolders == 'true' || $folder['parent_id'] != $this->site['root_folder_id'])) {
			$back = '<a class="'.$class.'" href="'.$this->create_url($folder['parent_id']).'">'.$text.'</a>';
			if ($template) {
				$template_content = $this->parse_template($template['content']);
				$back = str_replace($this->get_tag('content', $template_content), $back, $template_content);
			}
		}
		return $back;
	}

	function print_rootfolders($attributes) {
		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$item_template_name = isset ($attributes['item_template']) ? $attributes['item_template'] : '';
		$active_item_template_name = isset ($attributes['active_item_template']) ? $attributes['active_item_template'] : $item_template_name;
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$active_class = isset ($attributes['active_class']) ? $attributes['active_class'] : $class;

		$folders = '';
		$active_item_template = $this->get_template_item_by_name($this->site['template_id'], $active_item_template_name);
		$passive_item_template = $this->get_template_item_by_name($this->site['template_id'], $item_template_name);
		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);

		$count = $this->get_visible_folders($this->site['root_folder_id']);
		if ($count > 0) {

			while ($this->next_record()) {
				$item_template = ($this->f('id') == $this->folder_id) ? $active_item_template : $passive_item_template;
				$_class = ($this->f('id') == $this->folder_id) ? $active_class : $class;

				if ($item_template) {
					$item_template_content = $this->parse_template($item_template['content']);
					$folders .= str_replace($this->get_tag('content', $item_template_content), '<a title="'.$this->f('name').'" class="'.$_class.'" href="'.$this->create_url($this->f('id')).'">'.$this->f('name').'</a>', $item_template_content);
				} else {
					$folders .= '<a title="'.$this->f('name').'" class="'.$_class.'" href="'.$this->create_url($this->f('id')).'">'.$this->f('name').'</a>';
				}
			}
			if ($template) {
				$template_content = $this->parse_template($template['content']);
				$folders = str_replace($this->get_tag('content', $template_content), $folders, $template_content);
			}
		}
		return $folders;
	}

	function print_folderlist($attributes) {
		global $GO_CONFIG, $GO_MODULES;

		$path = isset ($attributes['path']) ? $attributes['path'] : '';
		$id = isset ($attributes['id']) ? $attributes['id'] : '';

		$folders = '';
		if ($resolved_path = $this->resolve_url($path, $this->site['root_folder_id'])) {
			$count = $this->get_visible_folders($resolved_path['folder_id']);
			if ($count > 0) {
				$folders .= '<ul id="'.$id.'">';
				while ($this->next_record()) {
					if ($this->f('id') == $this->folder_id) {
						$folders .= '<li><strong><a title="'.$this->f('name').'" href="'.$this->create_url($this->f('id')).'">'.$this->f('name').'</a></strong>';
						$cms = new cms();

						$folder_count = $cms->get_visible_folders($this->f('id'));
						if ($folder_count > 0) {
							$folders .= '<ul>';
							while ($cms->next_record()) {
								$folders .= '<li><a title="'.$this->f('name').'" href="'.$this->create_url($cms->f('id')).'">'.$cms->f('name').'</a></li>';
							}
						}

						$file_count = $cms->get_files($this->folder_id, 'priority', 'ASC');

						if ($file_count > 1) {
							$browser = detect_browser();

							$cms_module = $GO_MODULES->get_module('cms');
							if ($folder_count == 0) {
								$folders .= '<ul>';
							}
							if ($browser['name'] == 'MSIE') {
								$target = '_blank';
							} else {
								$target = '_self';
							}

							while ($cms->next_record()) {
								if ($this->file_id == $cms->f('id')) {
									$folders .= '<li><strong>';
								} else {
									$folders .= '<li>';
								}
								$extension = $cms->f('extension');

								if ($this->publish_static || eregi('htm', $cms->f('extension'))) {
									$folders .= '<a href="'.$this->create_url($this->folder_id, $cms->f('id')).'">'.strip_extension($cms->f('name')).'</a>';
								} else {
									$folders .= '<a target="'.$target.'" href="'.$cms_module['url'].'download.php?site_id='.$this->site['id'].'&amp;file_id='.$cms->f('id').'">'.strip_extension($cms->f('name')).'</a>';
								}

								if ($this->file_id == $cms->f('id')) {
									$folders .= '</strong></li>';
								} else {
									$folders .= '</li>';
								}
							}
							if ($folder_count > 0 || $file_count > 0) {
								$folders .= '</ul>';
							}
							$folders .= '</li>';
						}
					} else {
						$folders .= '<li><a href="'.$this->create_url($this->f('id')).'">'.$this->f('name').'</a></li>';
					}
				}

				$folders .= '</ul>';
			}
			return $folders;
		}
	}

	function print_files($attributes) {
		global $GO_CONFIG, $extension, $GO_MODULES;

		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$item_template_name = isset ($attributes['item_template']) ? $attributes['item_template'] : '';
		$active_item_template_name = isset ($attributes['active_item_template']) ? $attributes['active_item_template'] : $item_template_name;
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$active_class = isset ($attributes['active_class']) ? $attributes['active_class'] : $class;
		$print_single = isset ($attributes['print_single']) ? $attributes['print_single'] : 'true';

		$cms_module = $GO_MODULES->get_module('cms');

		$files = '';
		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);
		$item_template_passive = $this->get_template_item_by_name($this->site['template_id'], $item_template_name);
		$item_template_active = $this->get_template_item_by_name($this->site['template_id'], $active_item_template_name);

		$count = $this->get_files($this->folder_id, 'priority', 'ASC');
		$browser = detect_browser();
		if ($browser['name'] == 'MSIE') {
			$target = '_blank';
		} else {
			$target = '_self';
		}

		if ($count > 1 || ($count == 1 && $print_single == 'true')) {
			while ($this->next_record()) {
				$extension = $this->f('extension');

				$item_template = ($this->file_id == $this->f('id')) ? $item_template_active : $item_template_passive;
				$_class = ($this->file_id == $this->f('id')) ? $active_class : $class;

				$name = strip_extension($this->f('name'));
				$title = $this->f('title') == '' ? $name : $this->f('title');
				if ($this->publish_static || eregi('htm', $this->f('extension'))) {
					$content = '<a title="'.$title.'" class="'.$_class.'" href="'.$this->create_url($this->folder_id, $this->f('id')).'">'.$name.'</a>';
				} else {
					$content = '<a title="'.$title.'" target="'.$target.'" class="'.$_class.'" href="'.$cms_module['url'].'download.php?site_id='.$this->site['id'].'&amp;file_id='.$this->f('id').'">'.$name.'</a>';
				}
				if ($item_template) {
					$item_template_content = $this->parse_template($item_template['content']);
					$files .= str_replace($this->get_tag('content', $item_template_content), $content, $item_template_content);
				} else {
					$files .= $content;
				}
			}

			if ($template) {
				$template_content = $this->parse_template($template['content']);
				$files = str_replace($this->get_tag('content', $template_content), $files, $template_content);
			}
		}
		return $files;
	}

	function print_items($attributes) {
		global $GO_CONFIG, $extension, $GO_MODULES;

		$folder_id = isset ($attributes['folder_id']) ? $attributes['folder_id'] : 0;
		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$item_template_name = isset ($attributes['item_template']) ? $attributes['item_template'] : '';
		$active_item_template_name = isset ($attributes['active_item_template']) ? $attributes['active_item_template'] : $item_template_name;
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$active_class = isset ($attributes['active_class']) ? $attributes['active_class'] : $class;
		$print_root_only = isset ($attributes['print_root_only']) ? $attributes['print_root_only'] : 'false';
		$print_root = isset ($attributes['print_root']) ? $attributes['print_root'] : 'true';
		$menu = isset ($attributes['menu']) ? $attributes['menu'] : '';

		$cms_module = $GO_MODULES->get_module('cms');

		$return = '';
		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);
		$item_template_passive = $this->get_template_item_by_name($this->site['template_id'], $item_template_name);
		$item_template_active = $this->get_template_item_by_name($this->site['template_id'], $active_item_template_name);

		if($folder_id>0)
		{
			$items = $this->get_items($folder_id, true);
		}else
		{
			if ($print_root_only == 'false') {
				if ($print_root == 'false' && $this->folder_id == $this->site['root_folder_id']) {
					return '';
				}
				$items = $this->get_items($this->folder_id, true);
			} else {
				$items = $this->get_items($this->site['root_folder_id'], true);
			}
		}
		$count = count($items);

		while ($item = array_shift($items)) {
			if (isset ($item['extension'])) {
				$extension = $item['extension'];

				$item_template = ($this->file_id == $item['id']) ? $item_template_active : $item_template_passive;
				$_class = ($this->file_id == $item['id']) ? $active_class : $class;

				$name = strip_extension($item['name']);
				$title = $item['title'] == '' ? $name : $item['title'];
				if ($this->publish_static || eregi('htm', $extension)) {
					$content = '<a title="'.$title.'" class="'.$_class.'" href="'.$this->create_url($item['folder_id'], $item['id']).'">'.$name.'</a>';
				} else {
					$content = '<a title="'.$title.'" target="_blank" class="'.$_class.'" href="'.$cms_module['url'].'download.php?site_id='.$this->site['id'].'&amp;file_id='.$item['id'].'">'.$name.'</a>';
				}
				if ($item_template) {
					$item_template_content = $this->parse_template($item_template['content']);
					$return .= str_replace($this->get_tag('content', $item_template_content), $content, $item_template_content);
				} else {
					$return .= $content;
				}
			} else {
				$extension = '';
				$item_template = ($this->folder_id == $item['id']) ? $item_template_active : $item_template_passive;
				$_class = ($this->folder_id == $item['id']) ? $active_class : $class;

				if ($menu != '') {
					$menu_id = 'goMenuID_'.$item['id'];
					$menu_object = 'goMenu_'.$item['id'];
					$link = '<div id="'.$menu_id.'"></div>';
					$link .= $this->generate_menu_object($item, $menu_object);

					$link .= '<script type="text/javascript">cmDraw("'.$menu_id.'", '.$menu_object.' , "hbr", cm'.$menu.', "'.$menu.'");</script>';
				} else {
					$link = '<a class="'.$_class.'" href="'.$this->create_url($item['id']).'" title="'.$item['name'].'">'.$item['name'].'</a>';
				}

				if ($item_template) {
					$item_template_content = $this->parse_template($item_template['content']);
					$return .= str_replace($this->get_tag('content', $item_template_content), $link, $item_template_content);
				} else {
					$return .= $link;
				}
			}
		}

		if ($template) {
			$template_content = $this->parse_template($template['content']);
			$return = str_replace($this->get_tag('content', $template_content), $return, $template_content);
		}

		return $return;
	}
	
	
	function print_treeview($attributes, $folder_id=0) {
		global $GO_CONFIG, $extension, $GO_MODULES;

		$start_folder_id = isset ($attributes['folder_id']) ? $attributes['folder_id'] : $this->site['root_folder_id'];
		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$item_template_name = isset ($attributes['item_template']) ? $attributes['item_template'] : '';
		$active_item_template_name = isset ($attributes['active_item_template']) ? $attributes['active_item_template'] : $item_template_name;
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$item_class = isset ($attributes['item_class']) ? $attributes['item_class'] : '';
		$active_item_class = isset ($attributes['item_active_class']) ? $attributes['item_active_class'] : $item_class;
		$menu = isset ($attributes['menu']) ? $attributes['menu'] : '';

		$cms_module = $GO_MODULES->get_module('cms');
		
		if($folder_id==0)
		{
			$return = '<div class="'.$class.'">';
		}else
		{
			$return = '<div>';
		}
		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);
		$item_template_passive = $this->get_template_item_by_name($this->site['template_id'], $item_template_name);
		$item_template_active = $this->get_template_item_by_name($this->site['template_id'], $active_item_template_name);

		if($folder_id==0)
		{
			$folder_id = $start_folder_id;		
		}
		
		
		
		
	//	echo 'Folder:' .$folder_id.'<br>';
		$items = $this->get_items($folder_id, true);

		$count = count($items);

		while ($item = array_shift($items)) {
			if (isset ($item['extension'])) {
				$extension = $item['extension'];

				$item_template = ($this->file_id == $item['id']) ? $item_template_active : $item_template_passive;
				$_class = ($this->file_id == $item['id']) ? $active_item_class : $item_class;

				$name = strip_extension($item['name']);
				$title = $item['title'] == '' ? $name : $item['title'];
				if ($this->publish_static || eregi('htm', $extension)) {
					$content = '<a title="'.$title.'" class="'.$_class.'" href="'.$this->create_url($item['folder_id'], $item['id']).'">'.$name.'</a>';
				} else {
					$content = '<a title="'.$title.'" target="_blank" class="'.$_class.'" href="'.$cms_module['url'].'download.php?site_id='.$this->site['id'].'&amp;file_id='.$item['id'].'">'.$name.'</a>';
				}
				if ($item_template) {
					$item_template_content = $this->parse_template($item_template['content']);
					$return .= str_replace($this->get_tag('content', $item_template_content), $content, $item_template_content);
				} else {
					$return .= $content;
				}
			} else {
				$extension = '';
				$item_template = ($this->folder_id == $item['id']) ? $item_template_active : $item_template_passive;
				$_class = ($this->folder_id == $item['id']) ? $active_item_class : $item_class;

				$link = '<a class="'.$_class.'" href="'.$this->create_url($item['id']).'" title="'.$item['name'].'">'.$item['name'].'</a>';
				
				if ($item_template) {
					$item_template_content = $this->parse_template($item_template['content']);
					$return .= str_replace($this->get_tag('content', $item_template_content), $link, $item_template_content);
				} else {
					$return .= $link;
				}
				$cms_site = new cms_site();
				if($this->is_in_path($item['id'],$this->folder_id))
				{
					$return .= $this->print_treeview($attributes, $item['id']);
				}
				
			}
		}

		if ($template) {
			$template_content = $this->parse_template($template['content']);
			$return = str_replace($this->get_tag('content', $template_content), $return, $template_content);
		}

		$return .= '</div>';
		return $return;
	}

	function generate_menu_object($folder, $menu_name) {
		return "\n<script type=\"text/javascript\">\n".'var '.$menu_name." = \n[".$this->_generate_menu_object($folder)."\n];</script>";

	}

	function _generate_menu_object($folder, $indent = "\t") {
		$menu = ",\n".$indent;

		if (!isset ($folder['extension'])) {
			$menu .= '["", "'.addslashes($folder['name']).'", "'.$this->create_url($folder['id']).'", "_self", "'.$folder['name'].'"';
			$items = $this->get_items($folder['id']);

			while ($item = array_shift($items)) {
				$menu .= ",".$this->_generate_menu_object($item, $indent."\t");
			}
		} else {
			$menu .= '["", "'.addslashes($folder['name']).'", "'.$this->create_url($folder['folder_id'], $folder['id']).'", "_self", "'.$folder['name'].'"';
		}

		return $menu.']';
	}

	function print_login($attributes) {
		global $GO_CONFIG, $cms_login;

		$template_name = isset ($attributes['template']) ? $attributes['template'] : '';
		$class = isset ($attributes['class']) ? $attributes['class'] : '';
		$text = isset ($attributes['text']) ? $attributes['text'] : $cms_login;

		$template = $this->get_template_item_by_name($this->site['template_id'], $template_name);
		$login = '<a class="'.$class.'" href="javascript:popup(\''.$GO_CONFIG->full_url.'\');">'.$text.'</a>';
		if ($template) {
			$template_content = $this->parse_template($template['content']);
			$login = str_replace($this->get_tag('content', $template_content), $login, $template_content);
		}
		return $login;
	}


	function print_document($attributes) {
		global $GO_CONFIG, $GO_MODULES;

		$path = isset ($attributes['path']) ? $attributes['path'] : '';

		if ($resolved_path = $this->resolve_url($path, $this->site['id'])) {
			if ($resolved_path['file_id'] > 0) {
				$file = $this->get_file($resolved_path['file_id']);
				$content = $this->parse_template($file['content']);
				$content = str_replace($cms_module['full_url'].'view.php', $_SERVER['PHP_SELF'], $content);
				return $content;
			} else {
				return "<p><b>Error: Could not resolve file from '$path'</b></p>";
			}

		} else {
			return "<p><b>Error: Could not resolve url to '$path'</b></p>";
		}
	}
	
	function print_filename($attributes)
	{
		if($file = $this->get_file($this->file_id))
		{
			return strip_extension($file['name']);
		}
		return '';
	}

	function get_tag($tag, $content) {	
		$start_pos = strpos($content, '<'.$tag);
		if ($start_pos !== false) {			
			$end_pos = strpos($content, '</'.$tag.'>', $start_pos);
			if($end_pos === false)
			{
				$end_pos = strpos($content, '/>', $start_pos);
				if($end_pos === false)
				{
					return false;
				}else
				{
					$end_pos+=2;
				}
			}else
			{
				$end_pos+=strlen('</'.$tag.'>');
			}			
			$tag_length = $end_pos-$start_pos;
			return substr($content, $start_pos, $tag_length);
		}
		return false;
	}
	
	function print_script($attributes, $tag)
	{			
		global $GO_CONFIG;
		
		if(isset($attributes['type']) && eregi('php', $attributes['type']))		
		{
			$tag = preg_replace("'<script[^>]*>'si",'', $tag);
			$tag = preg_replace("'</script>'si",'', $tag);
			
			//$tag = 'require_once(\''.$GO_CONFIG->root_path.'Group-Office.php\');'.$tag;
			ob_start();
			eval($tag);
			$output = ob_get_contents();
			ob_end_clean();
			
			return $output;		
		}else
		{
			return $tag;
		}
	}
	
	function get_attributes($tag) {
		$attributes = array ();
		$in_value = false;
		$in_name = false;
		$name = '';
		$value = '';
		$length = strlen($tag);
		for ($i = 0; $i < $length; $i ++) {
			$char = $tag[$i];
			switch ($char) {
				case '"' :
					if ($in_value) {
						$in_value = false;

						$attributes[trim($name)] = trim($value);
						$name = '';
						$value = '';
					} else {
						$in_value = true;
					}

					break;

				case ' ' :
					if (!$in_value) {
						$in_name = true;
					} else {
						$value .= $char;
					}
					break;

				case '=' :
					$in_name = false;
					break;

				default :
					if ($in_name) {
						$name .= $char;
					}

					if ($in_value) {
						$value .= $char;
					}
					break;
			}
		}
		return $attributes;
	}

	function parse_template($content) {
		for ($i = 0; $i < count($this->tags); $i ++) {
			while ($tag = $this->get_tag($this->tags[$i], $content)) {
				$function = 'print_'.$this->tags[$i];

				$attributes = $this->get_attributes($tag);
				$content = str_replace($tag, $this-> $function ($attributes, $tag), $content);
			}
		}
		return $content;
	}
}
?>
