<?php
$form->add_html_element(new input('hidden', 'clicked_letter'));

if(isset($_REQUEST['search_type']))
{
	$ab_settings['search_type'] = $_REQUEST['search_type'];
	if($_REQUEST['search_type'] != 'user')
	{
		$ab_settings['search_addressbook_id'] = $_REQUEST['search_addressbook_id'];
	}
}

$tabstrip = new tabstrip('search_type', $cmdSearch);	
$tabstrip->set_attribute('width','100%');

$tabstrip->add_tab('contact',$contacts_contacts);
$tabstrip->add_tab('company',$ab_companies);
$tabstrip->add_tab('user',$contacts_members);
$tabstrip->set_active_tab($ab_settings['search_type']);

if($tabstrip->submitted)
{
	$datatable->start=0;
}	


if(isset($_POST['move_addressbook_id']) && $_POST['move_addressbook_id']>0)
{
	$move_ab = $ab->get_addressbook($_POST['move_addressbook_id']);

	if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $move_ab['acl_write']) && 
	$GO_SECURITY->has_permission($GO_SECURITY->user_id, $addressbook['acl_write']))
	
	{
		switch($tabstrip->value)
		{
			case 'contact':
				foreach($datatable->selected as $contact_id)
				{
					$ab->move_contact_to_addressbook($contact_id, $_POST['move_addressbook_id']);
				}
			break;
			
			case 'company':
				foreach($datatable->selected as $company_id)
				{
					$ab->move_company_to_addressbook($company_id, $_POST['move_addressbook_id']);
				}
			break;
			
		}
	}else
	{
		$feedback = $strAccessDenied;
	}
}

if($datatable->task == 'delete')
{
	switch($tabstrip->value)
	{
		case 'contact':
			foreach($datatable->selected as $contact_id)
			{
				$contact = $ab->get_contact($contact_id);

				if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $contact['acl_write']))
				{
					$ab->delete_contact($contact_id);
				}else
				{
					$feedback = $strAccessDenied;
					break;
				}
			}
		break;
		
		case 'company':
			foreach($datatable->selected as $company_id)
			{
				$company = $ab->get_company($company_id);

				if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $company['acl_write']))
				{
					$ab->delete_company($company_id);
				}else
				{
					$feedback = $strAccessDenied;
					break;
				}
			}
		break;		
	}
}


if (isset($feedback))
{
  $p = new html_element('p', $feedback);
  $p->set_attribute('class','Error');
  $tabstrip->add_html_element($p);
}

$h2 = new html_element('h2');
for($i=0;$i<count($alphabet);$i++)
{
	$hyperlink = new hyperlink("javascript:letter_click('".$alphabet[$i]."')",$alphabet[$i]);
	$hyperlink->set_attribute('style', 'margin-right:10px;');
	$h2->add_html_element($hyperlink);
}

$tabstrip->add_html_element($h2);

$table = new table();
$row = new table_row();

$search_fields = new select('search_field');

switch ($ab_settings['search_type'])
{
	case 'company':
		
		$search_fields->add_value('', $strSearchAll);
		$search_fields->add_value('ab_companies.name', $strName);
		$search_fields->add_value('ab_companies.email', $strEmail);
		$search_fields->add_value('ab_companies.address',$strAddress);
		$search_fields->add_value('ab_companies.city', $strCity);
		$search_fields->add_value('ab_companies.zip',$strZip);
		$search_fields->add_value('ab_companies.state',$strState);
		$search_fields->add_value('ab_companies.country', $strCountry);

		$search_field = $ab_settings['search_companies_field'] ;
		if(isset($_REQUEST['search_field']))
		{
			if($search_fields->is_in_select($_REQUEST['search_field']))
			{
				$search_field = $_REQUEST['search_field'];	
				if($task != 'show_letter')
				{
					$ab_settings['search_companies_field'] = $_REQUEST['search_field'];
				}
			}
		}		  
		$search_fields->value=$ab_settings['search_companies_field'];
	break;

	case 'user':
		$search_fields->value = $ab_settings['search_users_field'];
		$search_fields->add_value('', $strSearchAll);			
		$search_fields->add_value('users.first_name', $strFirstName);
		$search_fields->add_value('users.last_name', $strLastName);
		$search_fields->add_value('users.email', $strEmail);
		$search_fields->add_value('users.department',$strDepartment);
		$search_fields->add_value('users.function',$strFunction);
		$search_fields->add_value('users.address',$strAddress);
		$search_fields->add_value('users.city', $strCity);
		$search_fields->add_value('users.zip',$strZip);
		$search_fields->add_value('users.state',$strState);
		$search_fields->add_value('users.country', $strCountry);
		$search_fields->add_value('users.company', $strCompany);
		
		$search_field = $ab_settings['search_users_field'] ;
		if(isset($_REQUEST['search_field']))
		{
			if($search_fields->is_in_select($_REQUEST['search_field']))
			{				
				$search_field = $_REQUEST['search_field'];
				$ab_settings['search_users_field'] = $_REQUEST['search_field'];					
			}
		}		  
		$search_fields->value=$ab_settings['search_users_field'];
	break;
	
	default:
		$search_fields->add_value('', $strSearchAll);
		$search_fields->add_value('ab_contacts.first_name', $strFirstName);
		$search_fields->add_value('ab_contacts.last_name', $strLastName);
		$search_fields->add_value('ab_contacts.email', $strEmail);
		$search_fields->add_value('ab_contacts.department',$strDepartment);
		$search_fields->add_value('ab_contacts.function',$strFunction);
		$search_fields->add_value('ab_contacts.address',$strAddress);
		$search_fields->add_value('ab_contacts.city', $strCity);
		$search_fields->add_value('ab_contacts.zip',$strZip);
		$search_fields->add_value('ab_contacts.state',$strState);
		$search_fields->add_value('ab_contacts.country', $strCountry);
		$search_fields->add_value('ab_contacts.comment', $ab_comment);
		/*if ($custom_fields_plugin)
		{
			require_once($custom_fields_plugin['class_path'].'custom_fields.class.inc');
			$cf = new custom_fields('ab_custom_contact_fields');

			if($cf->get_fields())
			{
				while($cf->next_record())
				{
					$search_fields->add_value('ab_custom_contact_fields.`'.$cf->f('field').'`', $cf->f('field'));
				}
			}
		}*/
		
		$search_field = $ab_settings['search_contacts_field'] ;
		if(isset($_REQUEST['search_field']))
		{
			if($search_fields->is_in_select($_REQUEST['search_field']))
			{
				$search_field = $_REQUEST['search_field'];
				$ab_settings['search_contacts_field'] = $_REQUEST['search_field'];
			}
		}		  
		$search_fields->value=$ab_settings['search_contacts_field'];
	break;
}

$ab->update_settings($ab_settings);

$form->add_html_element(new input('hidden', 'search_addressbook_id', $ab_settings['search_addressbook_id'], false));

if ($ab_settings['search_type'] != 'user')
{
	$row->add_cell(new table_cell($ab_search_in.':'));

	if($ab_settings['search_addressbook_id'] == 0)
	{
		$link_text = $ab_all_your_addressbooks;
	}else
	{
		$addressbook = $ab->get_addressbook($ab_settings['search_addressbook_id']);
		$link_text = $addressbook['name'];
	}
	$link = new hyperlink("javascript:popup('select_addressbook.php?callback=select_search_addressbook&add_null=true', '300','400');",$link_text);
	$link->set_attribute('style','margin:3px;');
	$link->set_attribute('class','normal');
	
	$row->add_cell(new table_cell($link->get_html()));
	$row->add_cell(new table_cell($ab_search_on.':'));
	$row->add_cell(new table_cell($search_fields->get_html()));
}else
{

	$row->add_cell(new table_cell($ab_search_on_users.':'));
	$row->add_cell(new table_cell($search_fields->get_html()));
}
$row->add_cell(new table_cell($ab_search_for_keyword.':'));

$query = $_SESSION['GO_SESSION']['addressbook']['query'] = isset($_SESSION['GO_SESSION']['addressbook']['query']) ? $_SESSION['GO_SESSION']['addressbook']['query'] : '';
if(isset($_POST['query']))
{	 
	$query = $_SESSION['GO_SESSION']['addressbook']['query'] = smart_addslashes($_POST['query']);
}


$input = new input('text', 'query', stripslashes($query), false);
$input->set_attribute('style', 'width:300px;');
$row->add_cell(new table_cell($input->get_html().$ab_wildcard));

$table->add_row($row);

$tabstrip->add_html_element($table);
$tabstrip->add_html_element(new button($cmdSearch, 'javascript:_search();'));


$form->add_html_element($tabstrip);

if ($task != 'show_letter')
{
	$query = '%'.smart_addslashes($query).'%';
}else
{
	switch ($ab_settings['search_type'])
	{
		case 'company':
			$search_field='ab_companies.name';
		break;
		
		case 'contact':
			$search_field='ab_contacts.'.$_SESSION['GO_SESSION']['sort_name'];
		break;
		
		case 'user':
			$search_field='users.'.$_SESSION['GO_SESSION']['sort_name'];
		break;
	}
	$query = smart_addslashes($_POST['clicked_letter']).'%';
}
$results = '';

switch($ab_settings['search_type'])
{
	case 'contact':

		$count = $ab->search_contacts(
			$GO_SECURITY->user_id, 
			$query, 
			$search_field, 
			$ab_settings['search_addressbook_id'], 
			0, 
			$datatable->start, 
			$datatable->offset);
			
		$datatable->set_pagination($count);

		while ($ab->next_record())
		{

			$mail_name = format_name($ab->f('last_name'), $ab->f('first_name'), $ab->f('middle_name'), 'first_name');
			$full_email = ($ab->f("email") != "") ? '"'.$mail_name.'" <'.$ab->f('email').'>' : '';
			$name = format_name($ab->f('last_name'), $ab->f('first_name'), $ab->f('middle_name'));
			
			$row = new table_row($ab->f('id'));
			$row->set_attribute('ondblclick', "document.location='contact.php?contact_id=".$ab->f("id")."&return_to=".urlencode($GO_MODULES->url.'index.php')."'");
			$cell = new table_cell(htmlspecialchars($name));
			if ($ab->f('color') != '')
			{
				$cell->set_attribute('style','color: '.$ab->f('color'));
			}
			$row->add_cell($cell);
			$row->add_cell(new table_cell(show_company($ab->f('company_id'))));
			$row->add_cell(new table_cell(mail_to(empty_to_stripe(addslashes($full_email)), empty_to_stripe($ab->f('email')),'normal',true, $ab->f('id'))));
			$row->add_cell(new table_cell(empty_to_stripe(htmlspecialchars($ab->f('home_phone')))));
			$row->add_cell(new table_cell(empty_to_stripe(htmlspecialchars($ab->f('work_phone')))));
			$datatable->add_row($row);
		}
	
		$result_str =  ($count == 1) ? $count.' '.$contacts_result : $count.' '.$contacts_results;
		$form->add_html_element(new html_element('h2', $result_str));			

		if ($count > 0)
		{
			$datatable->add_column(new table_heading($strName));
			$datatable->add_column(new table_heading($strCompany));
			$datatable->add_column(new table_heading($strEmail));
			$datatable->add_column(new table_heading($strPhone));
			$datatable->add_column(new table_heading($strWorkphone));
		}
	break;

	case 'company':

		$count = $ab->search_companies(
			$GO_SECURITY->user_id, 
			$query, 
			$search_field, 
			$ab_settings['search_addressbook_id'], 
			$datatable->start, 
			$datatable->offset);
			
		$datatable->set_pagination($count);
		
		while ($ab->next_record())
		{
				$full_email = $ab->f('email') == '' ? '' : '"'.$ab->f('name').'" <'.$ab->f('email').'>';
				
				$row = new table_row($ab->f('id'));
				$row->set_attribute('ondblclick', "document.location='company.php?company_id=".$ab->f("id")."&return_to=".urlencode($GO_MODULES->url.'index.php')."'");
				$cell = new table_cell(htmlspecialchars($ab->f('name')));
				if ($ab->f('color') != '')
				{
					$cell->set_attribute('style','color: '.$ab->f('color'));
				}
				$row->add_cell($cell);
				$row->add_cell(new table_cell($ab->f('city')));
				$row->add_cell(new table_cell(mail_to(empty_to_stripe(addslashes($full_email)), empty_to_stripe($ab->f('email')),'normal',true, $ab->f('id'))));
				$row->add_cell(new table_cell(empty_to_stripe(htmlspecialchars($ab->f('phone')))));
				
				$hyperlink = new hyperlink($ab->f('homepage'), $ab->f('homepage'));
				$hyperlink->set_attribute('class', 'normal');
				$hyperlink->set_attribute('target', '_blank');
				
				$row->add_cell(new table_cell($hyperlink->get_html()));
				$datatable->add_row($row);
		}


		$result_str =  ($count == 1) ? $count.' '.$contacts_result : $count.' '.$contacts_results;
		$form->add_html_element(new html_element('h2', $result_str));

		

		if ($count > 0)
		{
			$datatable->add_column(new table_heading($strName));
			$datatable->add_column(new table_heading($strCity));
			$datatable->add_column(new table_heading($strEmail));
			$datatable->add_column(new table_heading($strPhone));
			$datatable->add_column(new table_heading($strHomepage));

		}
	break;

	case 'user':
		$count = $GO_USERS->search(
			$query, 
			$search_field, 
			$GO_SECURITY->user_id, 
			$datatable->start, 
			$datatable->offset);
	
		$datatable->set_pagination($count);
		
		while ($GO_USERS->next_record())
		{
			if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $GO_USERS->f('acl_id')))
			{
				$middle_name = $GO_USERS->f('middle_name') == '' ? '' : $GO_USERS->f('middle_name').' ';
				$name = $GO_USERS->f('first_name').' '.$middle_name.$GO_USERS->f('last_name');	
				
				$full_email = $GO_USERS->f('email') == '' ? '' : '"'.$name.'" <'.$GO_USERS->f('email').'>';
				
				$name = format_name($GO_USERS->f('last_name'), $GO_USERS->f('first_name'), $GO_USERS->f('middle_name'));
				
				$row = new table_row($GO_USERS->f('id'));
				$row->set_attribute('ondblclick', "document.location='".$GO_CONFIG->control_url."user.php?id=".$GO_USERS->f('id')."&return_to=".urlencode($GO_MODULES->url)."'");
				$cell = new table_cell(htmlspecialchars($name));
				$row->add_cell($cell);
				$row->add_cell(new table_cell(empty_to_stripe(htmlspecialchars($ab->f('company')))));
				$row->add_cell(new table_cell(mail_to(empty_to_stripe(addslashes($full_email)), empty_to_stripe($GO_USERS->f('email')),'normal',true, $ab->f('id'))));
				$row->add_cell(new table_cell(empty_to_stripe(htmlspecialchars($GO_USERS->f('home_phone')))));
				$row->add_cell(new table_cell(empty_to_stripe(htmlspecialchars($GO_USERS->f('work_phone')))));
				$datatable->add_row($row);
			}
		}
		
		$result_str =  ($count == 1) ? $count.' '.$contacts_result : $count.' '.$contacts_results;
		$h2 = new html_element('h2', $result_str);
		$form->add_html_element($h2);

		if ($count > 0)
		{
			$datatable->add_column(new table_heading($strName));
			$datatable->add_column(new table_heading($strCompany));
			$datatable->add_column(new table_heading($strEmail));
			$datatable->add_column(new table_heading($strPhone));
			$datatable->add_column(new table_heading($strWorkphone));
			
			
		}

	break;
}

$form->add_html_element($datatable);
?>
<script type="text/javascript">
function _search()
{
	<?php echo $datatable->set_page_one(); ?>
	document.forms[0].task.value='search';
	document.forms[0].submit();
}

function letter_click(letter)
{
	<?php 	echo $datatable->set_page_one(); 	?>

	document.forms[0].task.value='show_letter';
	document.forms[0].clicked_letter.value=letter;
	document.forms[0].submit();
}
</script>
