<?php
/**
 * Copyright Intermesh 2005
 *  Author: Merijn Schering <mschering@intermesh.nl>
 *  Version: 1.1 Release date: 27 June 2005
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 */

require_once("../Group-Office.php");

$GO_SECURITY->authenticate();
//if the user is authorising but it's logged in under another user log him out first.
if(isset($_REQUEST['requested_user_id']) && $_REQUEST['requested_user_id'] != $GO_SECURITY->user_id)
{
  SetCookie("GO_UN","",time()-3600,"/","",0);
  SetCookie("GO_PW","",time()-3600,"/","",0);
  unset($_SESSION);
  unset($_COOKIES);
  $GO_SECURITY->logout();
  $GO_SECURITY->authenticate();
}

$return_to = $GO_CONFIG->host.'configuration/';

require_once($GO_LANGUAGE->get_base_language_file('account'));
require_once($GO_LANGUAGE->get_base_language_file('preferences'));

$page_title = $acTitle;

$tabstrip = new tabstrip('account_tab', $menu_configuration, '150',  'account_form', 'vertical');
$tabstrip->add_tab('profile.inc', $acProfile);
$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';

if(isset($_REQUEST['feedback']))
{
	$feedback = $_REQUEST['feedback'];
}

switch($task)
{
	case 'add_user':
		$GO_HEADER['body_arguments'] = 'onkeypress="executeOnEnter(event, \'_save(\\\'authorize)\\\')\');" onload="document.forms[0].auth_email_address.focus();"';
	break;
	
	case 'save_look':
	
		$old_user = $GO_USERS->get_user($GO_SECURITY->user_id);
		$old_theme = $old_user['theme'];		
		
		$user['id'] = $GO_SECURITY->user_id;
		$user['max_rows_list'] = smart_addslashes($_POST['max_rows_list']);
		$user['start_module'] = smart_addslashes($_POST['start_module']);
		$user['sort_name'] =	smart_addslashes($_POST['sort_name']);
		$user['theme'] = smart_addslashes($_POST['theme']);
		$user['use_checkbox_select'] = isset($_POST['use_checkbox_select']) ? '1' : '0';
		
		
		$GO_USERS->update_profile($user);	

		if($user['theme'] != $old_theme)
		{
	    echo '<script type="text/javascript">';
	    echo 'parent.location="'.$GO_CONFIG->host.'index.php?return_to='.urlencode($_SERVER['PHP_SELF']).'";';
	    echo '</script>';
	    exit();
	  }
  break;
	
	case 'save_notations':
	
		$old_user = $GO_USERS->get_user($GO_SECURITY->user_id);
		$old_language = $old_user['language'];
	
		$user['language'] = smart_addslashes($_POST['language']);
		
		$user['id'] = $GO_SECURITY->user_id;
		$user['DST'] =isset($_POST['DST']) ? '1' : '0';
		$user['date_format'] =	smart_addslashes($_POST['date_format']);
		$user['date_seperator'] =	smart_addslashes($_POST['date_seperator']);
		$user['time_format'] =	smart_addslashes($_POST['time_format']);
		$user['thousands_seperator'] =	smart_addslashes($_POST['thousands_seperator']);
		$user['decimal_seperator'] =	smart_addslashes($_POST['decimal_seperator']);
		$user['currency'] =	smart_addslashes($_POST['currency']);
		$user['timezone'] =	smart_addslashes($_POST['timezone']);
		$user['first_weekday'] =	smart_addslashes($_POST['first_weekday']);
		
				
		$GO_USERS->update_profile($user);	
		
		if($user['language'] != $old_language)
		{
	    echo '<script type="text/javascript">';
	    echo 'parent.location="'.$GO_CONFIG->host.'index.php?return_to='.urlencode($_SERVER['PHP_SELF']).'";';
	    echo '</script>';
	    exit();
	  }
	break;

  case 'accept':
    if (isset($_REQUEST['requested_user_id']) && isset($_REQUEST['authcode']))
    {
      if ($user = $GO_USERS->get_user($_REQUEST['requesting_user_id']))
      {
				$middle_name = $user['middle_name'] == '' ? '' : $user['middle_name'].' ';
				$user_name = $middle_name.$user['last_name'];

				if($GO_USERS->authorize($_REQUEST['requesting_user_id'], $_REQUEST['authcode'], $GO_SECURITY->user_id))
				{
					$feedback = $ac_auth_success.'<br /><br />';

					$mail_body = $ac_salutation." ".$sir_madam[$user['sex']]." ".$user_name.",\r\n\r\n";
					$mail_body .= $_SESSION['GO_SESSION']['name']." ".$ac_auth_accept_mail_body;

					sendmail($user['email'], $GO_CONFIG->webmaster_email,
								$GO_CONFIG->title, $ac_auth_accept_mail_title,
								$mail_body,'3 (Normal)', 'text/plain');
				}

      }else
      {
				$feedback = '<p class="Error">'.$ac_auth_error.'</p>';
      }
      $task = 'privacy';
      $tabstrip->set_active_tab('privacy.inc');
    }
    break;

  case 'decline':
    if (isset($_REQUEST['requested_user_id']) && isset($_REQUEST['authcode']))
    {
      if ($user = $GO_USERS->get_user($_REQUEST['requesting_user_id']))
      {
				$middle_name = $user['middle_name'] == '' ? '' : $user['middle_name'].' ';
				$user_name = $middle_name.$user['last_name'];

				$feedback = $ac_auth_decline.'<br /><br />';
				$mail_body = $ac_salutation." ".$sir_madam[$user['sex']]." ".$user_name.",\r\n\r\n";
				$mail_body .= $_SESSION['GO_SESSION']['name']." ".$ac_auth_decline_mail_body;
				sendmail($user['email'], $GO_CONFIG->webmaster_email, $GO_CONFIG->title,
								$ac_auth_decline_mail_title, $mail_body,'3 (Normal)', 'text/plain');

      }else
      {
				$feedback = '<p class="Error">'.$ac_auth_error.'</p>';
      }
      $task = 'privacy';
      $tabstrip->set_active_tab('privacy.inc');
    }
    break;

  case 'save_profile':
		$user['id'] = $GO_SECURITY->user_id;
		$user['first_name'] = isset($_POST['first_name']) ?  smart_addslashes(trim($_POST['first_name'])) : '';
		$user['middle_name'] = isset($_POST['middle_name']) ?  smart_addslashes(trim($_POST['middle_name'])) : '';
		$user['last_name'] = isset($_POST['last_name']) ?  smart_addslashes(trim($_POST['last_name'])) : '';
		$user['initials'] = isset($_POST['initials']) ? smart_addslashes($_POST["initials"]) : '';
		$user['title'] = isset($_POST['title']) ? smart_addslashes($_POST["title"]) : '';
		$user['birthday'] = !empty($_POST['birthday']) ? date_to_db_date(smart_stripslashes($_POST["birthday"])) : '';
		$user['email'] = isset($_POST['email']) ? smart_addslashes($_POST["email"]) : '';
		$user['home_phone'] = isset($_POST['home_phone']) ? smart_addslashes($_POST["home_phone"]) : '';
		$user['work_phone'] = isset($_POST['work_phone']) ? smart_addslashes($_POST["work_phone"]) : '';
		$user['fax'] = isset($_POST['fax']) ? smart_addslashes($_POST["fax"]) : '';
		$user['cellular'] = isset($_POST['cellular']) ? smart_addslashes($_POST["cellular"]) : '';
		$user['country_id'] = isset($_POST['country_id']) ? smart_addslashes($_POST["country_id"]) : '0';
		$user['state'] = isset($_POST['state']) ? smart_addslashes($_POST["state"]) : '';
		$user['city'] = isset($_POST['city']) ? smart_addslashes($_POST["city"]) : '';
		$user['zip'] = isset($_POST['zip']) ? smart_addslashes($_POST["zip"]) : '';
		$user['address'] = isset($_POST['address']) ? smart_addslashes($_POST["address"]) : '';
		$user['company'] = isset($_POST['company']) ? smart_addslashes($_POST["company"]) : '';
		$user['department'] =  isset($_POST['department']) ? smart_addslashes($_POST["department"]) : '';
		$user['function'] =  isset($_POST['function']) ? smart_addslashes($_POST["function"]) : '';
		$user['work_country_id'] = isset($_POST['work_country_id']) ?  smart_addslashes($_POST["work_country_id"]) : '0';
		$user['work_state'] = isset($_POST['work_state']) ? smart_addslashes($_POST["work_state"]) : '';
		$user['work_city'] = isset($_POST['work_city']) ? smart_addslashes($_POST["work_city"]) : '';
		$user['work_zip'] = isset($_POST['work_zip']) ? smart_addslashes($_POST["work_zip"]) : '';
		$user['work_address'] = isset($_POST['work_address']) ? smart_addslashes($_POST["work_address"]) : '';
		$user['work_fax'] = isset($_POST['work_fax']) ? smart_addslashes($_POST["work_fax"]) : '';
		$user['homepage'] = isset($_POST['homepage']) ? smart_addslashes($_POST["homepage"]) : '';
		$user['sex'] = isset($_POST['sex']) ? smart_addslashes($_POST["sex"]) : 'M';
		


		if(
		empty($user['first_name']) || 
		empty($user['last_name'])	
		)
		{
			$feedback = $error_missing_field."</p>";
		}elseif(!validate_email($user['email']))
		{
			$feedback = $error_email;
		}elseif (!$GO_USERS->update_profile($user))
		{		
			$feedback = $strSaveError;
    }else
    {
    	if (isset($_POST['load_frames']))
    	{    
    		if(isset($GO_MODULES->modules['email']) && $GO_MODULES->modules['email']['read_permission'])
    		{
    			require_once($GO_MODULES->modules['email']['class_path'].'email.class.inc');
	    		$email = new email();
	    		
	    		$email->get_accounts($GO_SECURITY->user_id);
	    		if($email->next_record())
	    		{
	    			$account['id'] = $email->f('id');
	    			$account['email'] = $user['email'];
	    			$account['name'] = format_name($user['last_name'], $user['first_name'], $user['middle_name'], 'first_name');

	    			$email->_update_account($account);
	    		}
    		}
				header('Location: '.$GO_CONFIG->host);
				exit();
			}
    }

    break;

  case 'change_password':
    require_once($GO_CONFIG->class_path."/validate.class.inc");
    $val = new validate;
    $val->error_required = $error_required;
    $val->error_min_length = $error_min_length;
    $val->error_max_length = $error_max_length;
    $val->error_expression = $error_email;
    $val->error_match = $error_match_auth;
		
		$newpass1 = smart_stripslashes($_POST['newpass1']);
		$newpass2 = smart_stripslashes($_POST['newpass2']);

		if($newpass1 == '' || $newpass2 == '')
		{
			$feedback = $error_missing_field;
		}elseif ($newpass1 != $newpass2)
    {
    	$feedback = $error_match_pass;
    }else
    {
      if (!$GO_USERS->check_password(smart_stripslashes($_POST['currentpassword'])))
      {
				$feedback = $security_wrong_password;
      }else
      {
				if ($_POST['newpass1'] != "")
				{
					if ($GO_USERS->update_password($GO_SECURITY->user_id,
									smart_stripslashes($_POST['newpass1'])))
					{
						$feedback = $security_password_update;
					}else
					{
						$feedback = $strSaveError;
					}
				}
      }
    }
    break;
}

$user = $GO_USERS->get_user($GO_SECURITY->user_id);

$overlib = new overlib();
$GO_HEADER['head'] = $overlib->get_header();

$birthday = db_date_to_date($user['birthday']);
$birthday_picker = new date_picker('birthday', $_SESSION['GO_SESSION']['date_format'], $birthday);
$GO_HEADER['head'] .= $birthday_picker->get_header();


if ($_SESSION['GO_SESSION']['first_name'] != '' && $_SESSION['GO_SESSION']['last_name'] != '' && $_SESSION['GO_SESSION']['email'] != '')
{

  if ($GO_CONFIG->allow_password_change)
  {
    $tabstrip->add_tab('security.inc', $acSecurity);
  }

  $tabstrip->add_tab('privacy.inc', $acPrivacy);  
  $tabstrip->add_tab('look.inc', $pref_look);
  $tabstrip->add_tab('notations.inc', $pref_notations);
  
  
  $cal_module = $GO_MODULES->get_module('calendar');		
	if($cal_module &&
		($GO_SECURITY->has_permission($GO_SECURITY->user_id, $cal_module['acl_read']) ||
		$GO_SECURITY->has_permission($GO_SECURITY->user_id, $cal_module['acl_write'])))
	{
		require_once($cal_module['class_path'].'calendar.class.inc');
		$cal = new calendar();
	}else
	{
		$cal_module = false;
	}
	$ab_module = $GO_MODULES->get_module('addressbook');		
	if($ab_module &&
		($GO_SECURITY->has_permission($GO_SECURITY->user_id, $ab_module['acl_read']) ||
		$GO_SECURITY->has_permission($GO_SECURITY->user_id, $ab_module['acl_write'])))
	{
		require_once($ab_module['class_path'].'addressbook.class.inc');
		$ab = new addressbook();
	}else
	{
		$ab_module = false;
	}

  $settings_include = $GO_CONFIG->root_path.'sync/sync.settings.inc';
  if(($cal_module || $ab_module) && file_exists($settings_include))
  {
  	$tabstrip->add_tab($settings_include, $strSynchronization);
  }
  

	foreach($GO_MODULES->modules as $module)
	{
		if($module['read_permission'])
		{
			$settings_include = $module['path'].$module['id'].'.settings.inc';
			if(file_exists($settings_include))
			{
				$module_name = isset($lang_modules[$module['id']]) ? $lang_modules[$module['id']] : $module['id'];
				$tabstrip->add_tab($settings_include, $module_name);
			}
		}
	}	
}

switch($tabstrip->get_active_tab_id())
{
	case 'security.inc':
		$GO_HEADER['body_arguments'] = 'onkeypress="executeOnEnter(event, \'_save(\\\'change_password\\\')\');" '.
			'onload="document.forms[0].currentpassword.focus();"';
	break;
	
	case 'profile.inc':
		$GO_HEADER['body_arguments'] = 'onkeypress="executeOnEnter(event, \'_save(\\\'save_profile\\\')\');"'.
			' onload="document.forms[0].first_name.focus();"';
	break;

	case 'look.inc':
		$GO_HEADER['body_arguments'] = 'onkeypress="executeOnEnter(event, \'_save(\\\'save_look\\\')\');"';
	break;
	
	case 'notations.inc':
		$GO_HEADER['body_arguments'] = 'onkeypress="executeOnEnter(event, \'_save(\\\'save_notations\\\')\');"';
	break;
}

require_once($GO_THEME->theme_path."header.inc");

$form = new form('account_form');
$form->add_html_element(new input('hidden', 'task','',false));
$form->add_html_element(new input('hidden', 'close', 'false'));

if (isset($feedback))
{
  $p = new html_element('p', $feedback);
  $p->set_attribute('class','Error');
  $tabstrip->add_html_element($p);
}

require_once($tabstrip->get_active_tab_id());

$form->add_html_element($tabstrip);

echo $form->get_html();
?>
<script type="text/javascript">
function _save(task)
{
	document.forms[0].task.value = task;
	document.forms[0].submit();
}
</script>
<?php
require_once($GO_THEME->theme_path."footer.inc");
?>
