<?php
/**
 * @copyright Intermesh 2005
 * @author Merijn Schering <mschering@intermesh.nl>
 * @version $Revision: 1.5 $ $Date: 2005/07/11 14:50:38 $
 *
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

 * @package Framework
 * @subpackage Controls
 */

/**
 * Create a hyperlink
 * 
 * @package Framework
 * @subpackage Controls
 * 
 * @access public
 */

class hyperlink extends html_element
{
	var $innerHTML = '';		
	
	function hyperlink($href, $innerHTML, $title='')
	{
		$this->innerHTML=$innerHTML;
		
		if(!empty($href))
		{
			$this->set_attribute('href', $href);
		}
		
		if(!empty($title))
		{
			$this->set_attribute('title', $title);
		}
	}	
	
	function get_html()
	{	
		$html = '<a';
		foreach($this->attributes as $name=>$value)
		{
			$html .= ' '.$name.'="'.$value.'"';
		}
		$html .= '>'.$this->innerHTML.'</a>';
		
		return $html;
	}
}
?>
