<?php
/**
 * @copyright Intermesh 2003
 * @author Merijn Schering <mschering@intermesh.nl>
 * @version $Revision: 1.9 $ $Date: 2006/06/01 11:29:18 $

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

 * @package Framework
 * @subpackage Controls
 */

/**
 * Prints a color selector with custom colors
 *
 * @package Framework
 * @subpackage Controls
 * 
 * @access public
 */
class color_selector extends html_element
{
  
  var $form_name = 'forms[0]';

	/**
	* Prints the color selector
	*
	* @param String $name The name of the control
	* @param String $selected_color The selected color code
	* @param String $form_name The form name where the color selector is in
	* @access  public
	* @retrun void
	*/	
  function color_selector($id, $name, $value, $form_name ='0')
  {
    global $GO_THEME;
    
    $this->value= $value;
    $this->name= $name;
    $this->form_name= $form_name;    
    
    $this->set_attribute('id', $id);    
  }
  
  function get_header()
	{
		global $GO_CONFIG;
		return '<script type="text/javascript" src="'.$GO_CONFIG->host.'javascript/color_selector.js"></script>';
	}
  
  function get_html()
  {    
    $input = new input('hidden', $this->name, $this->value, false);    
    
    $return = $input->get_html();
    
    $table = new table();
    $table->set_attribute('style', 'border:1px solid black;display:none;position:absolute;background-color:#fff');
    //$table->set_attribute('onblur', 'javascript:close_colors(\''.$this->attributes['id'] .'\');');
    $table->set_attribute('id', 'all_color_table_'.$this->attributes['id']);
    $row = new table_row();
    
    $colors = array('00','33','66','99','cc','ff');   
    
    $max_cols=18;
    
    $cols=0;
    $row = new table_row();  	
    
    for($a=0;$a<count($colors);$a+=1)
    {
    	for($b=0;$b<count($colors);$b+=1)
    	{    		
    		for($c=0;$c<count($colors);$c+=1)
    		{
    			$cols++;
    			$color = ''.$colors[$a].$colors[$c].$colors[$b];
	    		$cell = new table_cell();
	    		
	    		$link = new hyperlink('javascript:select_color(\''.$this->attributes['id'] .'\', \''.$this->form_name.'\', \''.$this->name.'\', \''.$color.'\');', '&nbsp;');
    			$link->set_attribute('style', 'display:block;border:1px solid;#ccccc;height:16px;width:16px;background-color:#'.$color);
    			$link->set_attribute('id', 'color_'.$this->attributes['id'].'_'.$color);
    			
    			$cell->add_html_element($link);
    			$row->add_cell($cell);	    		
    			
    			if($cols==$max_cols)
    			{
    				$table->add_row($row);
    				$row = new table_row(); 
    				$cols=0;
    			}
	    	}
	    }	    
    }
    
    $return .= $table->get_html();
    
    $table = new table();
    $table->set_attribute('style', 'border:1px solid black;display:none;position:absolute;background-color:#fff');
   // $table->set_attribute('onblur', 'javascript:close_colors(\''.$this->attributes['id'] .'\');');
    $table->set_attribute('id', 'color_table_'.$this->attributes['id']);
    $row = new table_row();
    
    $colors=array();
		$colors[] = '000000';
		$colors[] = '009900';
		$colors[] = '00ff00';
		$colors[] = '0000ff';
		$colors[] = '00ffff';
		$colors[] = '660033';
		$colors[] = '660099';
		$colors[] = '6666ff';
		$colors[] = '66ff99';
		$colors[] = 'cc0099';
		$colors[] = 'cc99ff';
		$colors[] = '996600';
		$colors[] = '999900';
		$colors[] = 'ff0000';
		$colors[] = 'ff6600';
		$colors[] = 'ffff00';
		$colors[] = 'ff9966';
		$colors[] = 'ff9900';
		$colors[] = 'ffff99';
		$colors[] = 'ffffff';
		
		
		$max_cols=5;
    
    $cols=0;
    $row = new table_row();  	
    
    for($a=0;$a<count($colors);$a+=1)
    {    	
			$cols++;
    	$cell = new table_cell();

  		$link = new hyperlink('javascript:select_color(\''.$this->attributes['id'] .'\', \''.$this->form_name.'\', \''.$this->name.'\', \''.$colors[$a].'\');', '&nbsp;');
			$link->set_attribute('style', 'display:block;border:1px solid;#ccccc;height:16px;width:16px;background-color:'.$colors[$a]);
			//$link->set_attribute('id', 'color_'.$this->attributes['id'].'_'.$colors[$a]);
			
			$cell->add_html_element($link);
			$row->add_cell($cell);	    		
			
			if($cols==$max_cols)
			{
				$table->add_row($row);
				$row = new table_row(); 
				$cols=0;
			}	    	
	  }
	  
	  $row = new table_row();
	  $cell = new table_cell();
	  $cell->set_attribute('colspan', $max_cols);
	  $cell->set_attribute('style','text-align:center');
	  
	  $button = new button($GLOBALS['strMoreColors'], 'javascript:open_all_colors(\''.$this->attributes['id'] .'\');');
	  $button->set_attribute('style','margin:0px');
	  $cell->add_html_element($button);
	  $row->add_cell($cell);
	  $table->add_row($row);
	  
	  $return .= $table->get_html();
    
    $link = new hyperlink('javascript:open_colors(\''.$this->attributes['id'] .'\');', '&nbsp;');
    $link->set_attribute('style', 'display:block;border:1px solid;black;width:16px;height:16px;background-color:'.$this->value);
   	$link->set_attribute('id', 'color_link_'.$this->attributes['id']);
    
    $return .= $link->get_html();
    
    
	   	   
	   return $return;
  }
}
?>
