<?php
/**
 * @copyright Intermesh 2005
 * @author Merijn Schering <mschering@intermesh.nl>
 * @version $Revision: 1.17 $ $Date: 2006/01/23 12:09:14 $

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

 * @package Framework
 * @subpackage Controls
 */

/**
 * Create a checkbox.
 * 
 * This class is used to draw checkboxes on the website.
 * 
 * @package Framework
 * @subpackage Controls
 * 
 * @access public
 */
class checkbox extends html_element
{
  var $text;
  /**
   * Draw a new checkbox.
   * 
   * If you supply a name for this checkbox, it will be directly printed
   * on the page, else the constructor does nothing.
   * 
   * @access public
   * 
   * @param string $name
   * @param string $value
   * @param string $text
   * @param bool $checked defines if this checkbox is checked or not.
   * @param bool $disabled can be used to disable this checkbox.
   *
   * @return void
   */
  function checkbox($id='', $name='', $value='', $text='', $checked=false, $disabled=false)
  {
    $this->tagname = 'input';
		$this->set_linebreak("\n");

    $this->set_attribute('type', 'checkbox');
    //$this->set_attribute('class', 'textbox');
		$this->set_attribute('name', $name);
		if(empty($id))
		{
			$id = uniqid(time());
		}
    $this->set_attribute('id', $id);
		$this->set_attribute('value', $value);
    if($disabled)
    {
      $this->set_attribute('disabled', 'disabled');
    }
    if($checked)
    {
      $this->set_attribute('checked', 'checked');
    }

    $this->text=$text;

  }

  function get_click_handler()
  {
    return "javascript:check_checkbox('".$this->attributes['id']."');";
  }

  /**
   * Create a checkbox.
   *
   * This function returns a string that can be used to print a button on the
   * website.
   * 
   * @access public
   * 
   * @param string $name
   * @param string $value
   * @param string $text
   * @param bool $checked defines if this checkbox is checked or not.
   * @param bool $disabled can be used to disable this checkbox.
   * @param string $attributes
   * 
   * @return string
   */
  function get_html()
  {
    if ( $this->text != '' ) {
    	$table= new table();
    	$table->set_attribute('class','normalTable');
    	$table->set_attribute('cellpadding','0');
    	//$table->set_attribute('cellspacing','0');
    	$table->set_attribute('style','display:inline');
    	
    	$textcell = new table_cell($this->text);
    	
      if ( isset($this->attributes['disabled']) ) {
        $textcell->set_attribute('style','color:#7d7d7d;cursor:default;');        
      } else {
        $textcell->set_attribute('onclick', $this->get_click_handler());
        $textcell->set_attribute('style','cursor:default;');   
      }
      
      $row = new table_row();
      $cb_cell = new table_cell(parent::get_html());
      $cb_cell->set_attribute('valign','top');
      $row->add_cell($cb_cell);
      $row->add_cell($textcell);
      
      $table->add_row($row);

      return $table->get_html();
    }else
    {
      return parent::get_html();
    }
  }
}
?>
