/*
 * Decompiled with CFR 0.152.
 */
package jupload.filepanel;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import jupload.filepanel.FilePanelJTable;
import jupload.filepanel.SortArrowIcon;

public class SortHeaderRenderer
extends DefaultTableCellRenderer {
    public Icon NONSORTED = new SortArrowIcon(0);
    public Icon ASCENDING = new SortArrowIcon(2);
    public Icon DECENDING = new SortArrowIcon(1);

    public SortHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JTableHeader header;
        int index = -1;
        boolean ascending = true;
        if (table instanceof FilePanelJTable) {
            FilePanelJTable sortTable = (FilePanelJTable)table;
            index = sortTable.getSortedColumnIndex();
            ascending = sortTable.isSortedColumnAscending();
        }
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        Icon icon = ascending ? this.ASCENDING : this.DECENDING;
        this.setIcon(col == index ? icon : this.NONSORTED);
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }
}

