/*
 * Decompiled with CFR 0.152.
 */
package jupload.filepanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.dnd.DropTarget;
import java.io.File;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import jupload.DnDListener;
import jupload.FilePanel;
import jupload.JUploadPanel;
import jupload.filepanel.FilePanelDataModel;
import jupload.filepanel.FilePanelJTable;

public class FilePanelTableImp
extends Panel
implements FilePanel {
    public static final String TITLE = "JUpload FilePanelTableImp";
    public static final String DESCRIPTION = "FilePanel Table Implementation.";
    public static final String AUTHOR = "William JinHua Kwong";
    public static final double VERSION = 1.0;
    public static final String LAST_MODIFIED = "07 February 2004";
    private JTable jtable;
    private FilePanelDataModel model;

    public FilePanelTableImp(JUploadPanel jup) {
        this.setLayout(new BorderLayout());
        this.jtable = new FilePanelJTable();
        this.model = new FilePanelDataModel();
        this.jtable.setModel(this.model);
        TableColumnModel colModel = this.jtable.getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            colModel.getColumn(i).setPreferredWidth(this.model.getColumnSize(i));
        }
        JScrollPane scrollPane = new JScrollPane(this.jtable);
        this.add((Component)scrollPane, "Center");
        DropTarget dropTarget = new DropTarget(scrollPane, new DnDListener(jup));
    }

    public void addFiles(File[] f) {
        if (null != f) {
            for (int i = 0; i < f.length; ++i) {
                this.addDirectoryFiles(f[i]);
            }
        }
    }

    private void addDirectoryFiles(File f) {
        if (!f.isDirectory()) {
            this.addFileOnly(f);
        } else {
            File[] dirFiles = f.listFiles();
            for (int i = 0; i < dirFiles.length; ++i) {
                if (dirFiles[i].isDirectory()) {
                    this.addDirectoryFiles(dirFiles[i]);
                    continue;
                }
                this.addFileOnly(dirFiles[i]);
            }
        }
    }

    private void addFileOnly(File f) {
        if (!this.model.contains(f)) {
            this.model.addFile(f);
        }
    }

    public File[] getFiles() {
        File[] files = new File[this.getFilesLength()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = this.model.getFileAt(i);
        }
        return files;
    }

    public int getFilesLength() {
        return this.jtable.getRowCount();
    }

    public void removeSelected() {
        int[] rows = this.jtable.getSelectedRows();
        for (int i = rows.length - 1; 0 <= i; --i) {
            this.model.removeRow(rows[i]);
        }
    }

    public void removeAll() {
        for (int i = this.getFilesLength() - 1; 0 <= i; --i) {
            this.model.removeRow(i);
        }
    }
}

