/*
 * Decompiled with CFR 0.152.
 */
package jupload.filepanel;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import jupload.filepanel.DateRenderer;
import jupload.filepanel.FilePanelDataModel;
import jupload.filepanel.SortHeaderRenderer;

public class FilePanelJTable
extends JTable
implements MouseListener {
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;

    public FilePanelJTable() {
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(Date.class, new DateRenderer());
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new SortHeaderRenderer());
        header.addMouseListener(this);
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        TableColumnModel colModel = this.getColumnModel();
        int index = colModel.getColumnIndexAtX(event.getX());
        int modelIndex = colModel.getColumn(index).getModelIndex();
        FilePanelDataModel model = (FilePanelDataModel)this.getModel();
        if (model.isSortable(modelIndex)) {
            if (this.sortedColumnIndex == index) {
                this.sortedColumnAscending = !this.sortedColumnAscending;
            }
            this.sortedColumnIndex = index;
            model.sortColumn(modelIndex, this.sortedColumnAscending);
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }
}

