/*
 * Decompiled with CFR 0.152.
 */
package jupload.filepanel;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import jupload.filepanel.ColumnComparator;

public class FilePanelDataModel
extends DefaultTableModel {
    protected String[] columnNames = new String[]{"Name", "Size", "Directory", "Modified", "Readable?"};
    protected int[] columnSize = new int[]{150, 75, 199, 130, 75};
    protected Class[] columnClasses = new Class[]{String.class, Long.class, String.class, Date.class, Boolean.class};

    public void addFile(File file) {
        Object[] rowData = new Object[]{file.getName(), new Long(file.length()), file.getParent(), new Date(file.lastModified()), file.canRead() ? Boolean.TRUE : Boolean.FALSE};
        this.addRow(rowData);
    }

    public boolean contains(File file) {
        boolean contain = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!file.getName().equalsIgnoreCase((String)this.getValueAt(i, 0)) || !file.getParent().equalsIgnoreCase((String)this.getValueAt(i, 2))) continue;
            contain = true;
            break;
        }
        return contain;
    }

    public File getFileAt(int row) {
        return new File((String)this.getValueAt(row, 2), (String)this.getValueAt(row, 0));
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public int getColumnSize(int col) {
        return this.columnSize[col];
    }

    public Class getColumnClass(int col) {
        return this.columnClasses[col];
    }

    public boolean isSortable(int col) {
        return Boolean.class != this.getColumnClass(col);
    }

    public void sortColumn(int col, boolean ascending) {
        Collections.sort(this.getDataVector(), new ColumnComparator(col, ascending));
    }
}

