/*
 * Decompiled with CFR 0.152.
 */
package jupload;

import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import jupload.AfterUploadSucc;
import jupload.AfterUploadSuccImp;
import jupload.FilePanel;
import jupload.FileUploadThreadV2;
import jupload.StatusArea;
import jupload.filepanel.FilePanelTableImp;

public class JUploadPanel
extends JPanel
implements ActionListener {
    public static final String TITLE = "JUpload JUploadPanel";
    public static final String DESCRIPTION = "Main Panel for JUpload Application/Applet.";
    public static final String AUTHOR = "William JinHua Kwong";
    public static final double VERSION = 1.3;
    public static final String LAST_MODIFIED = "14 February 2004";
    public static final String DEFAULT_POST_URL = "http://localhost:8084/";
    private String postURL = null;
    private JPanel topPanel;
    private JButton browse;
    private JButton remove;
    private JButton removeAll;
    private JFileChooser fileChooser = null;
    private FilePanel fp = null;
    private JPanel progressPanel;
    private JButton upload;
    private JButton stop;
    private JProgressBar progress = null;
    private JTextArea status = null;
    private AfterUploadSucc aus = null;
    private Timer timer;
    private static final int DEFAULT_TIMEOUT = 100;
    FileUploadThreadV2 fut;

    public JUploadPanel(String postURL, JButton browse, JButton remove, JButton removeAll, FilePanel fp, JButton upload, JProgressBar progress, JButton stop, JTextArea status, JFileChooser fc) {
        this.setLayout(new BoxLayout(this, 1));
        this.postURL = null == postURL ? DEFAULT_POST_URL : postURL;
        this.setupTopPanel(browse, remove, removeAll);
        this.fp = null == fp ? new FilePanelTableImp(this) : fp;
        this.add((Container)((Object)this.fp));
        this.setupProgressPanel(upload, progress, stop);
        if (null == fc) {
            try {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                this.fileChooser.setFileSelectionMode(2);
                this.fileChooser.setMultiSelectionEnabled(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "ERROR  : " + e.getMessage());
            }
        } else {
            this.fileChooser = fc;
        }
    }

    private void setupTopPanel(JButton jbBrowse, JButton jbRemove, JButton jbRemoveAll) {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridLayout(1, 3));
        if (null == jbBrowse) {
            this.browse = new JButton("Browse...");
            this.browse.setIcon(new ImageIcon(this.getClass().getResource("/images/file-manager.png")));
        } else {
            this.browse = jbBrowse;
        }
        this.browse.addActionListener(this);
        this.topPanel.add(this.browse);
        if (null == jbRemove) {
            this.remove = new JButton("Remove Selected");
            this.remove.setIcon(new ImageIcon(this.getClass().getResource("/images/delete.png")));
        } else {
            this.remove = jbRemove;
        }
        this.remove.setEnabled(false);
        this.remove.addActionListener(this);
        this.topPanel.add(this.remove);
        if (null == jbRemoveAll) {
            this.removeAll = new JButton("Remove All");
            this.removeAll.setIcon(new ImageIcon(this.getClass().getResource("/images/error.png")));
        } else {
            this.removeAll = jbRemoveAll;
        }
        this.removeAll.setEnabled(false);
        this.removeAll.addActionListener(this);
        this.topPanel.add(this.removeAll);
        this.add(this.topPanel);
    }

    private void setupProgressPanel(JButton jbUpload, JProgressBar jpbProgress, JButton jbStop) {
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 0));
        if (null == jbUpload) {
            this.upload = new JButton("Upload");
            this.upload.setIcon(new ImageIcon(this.getClass().getResource("/images/up.png")));
        } else {
            this.upload = jbUpload;
        }
        this.upload.setEnabled(false);
        this.upload.addActionListener(this);
        this.progressPanel.add(this.upload);
        if (null == jpbProgress) {
            this.progress = new JProgressBar(0);
            this.progress.setStringPainted(true);
        } else {
            this.progress = jpbProgress;
        }
        this.progressPanel.add(this.progress);
        if (null == jbStop) {
            this.stop = new JButton("Stop");
            this.stop.setIcon(new ImageIcon(this.getClass().getResource("/images/stop.png")));
        } else {
            this.stop = jbStop;
        }
        this.stop.setEnabled(false);
        this.stop.addActionListener(this);
        this.progressPanel.add(this.stop);
        this.add(this.progressPanel);
    }

    private void setupStatus(JTextArea ta) {
        this.status = null == ta ? new StatusArea(5, 20) : ta;
        JScrollPane pane = new JScrollPane();
        pane.setVerticalScrollBarPolicy(22);
        pane.setHorizontalScrollBarPolicy(31);
        pane.getViewport().add(this.status);
        this.add(pane);
    }

    public void addDoAfterUploadSucc(AfterUploadSucc aus) {
        this.aus = null == aus ? new AfterUploadSuccImp() : aus;
        this.aus.setStatus(this.status);
    }

    protected void addFiles(File[] f) {
        this.fp.addFiles(f);
        if (0 < this.fp.getFilesLength()) {
            this.remove.setEnabled(true);
            this.removeAll.setEnabled(true);
            this.upload.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == this.browse.getActionCommand()) {
            if (null != this.fileChooser) {
                try {
                    if (0 == this.fileChooser.showOpenDialog(new Frame())) {
                        this.addFiles(this.fileChooser.getSelectedFiles());
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "ERROR  : " + ex.getMessage());
                }
            }
        } else if (e.getActionCommand() == this.remove.getActionCommand()) {
            this.fp.removeSelected();
            if (0 >= this.fp.getFilesLength()) {
                this.remove.setEnabled(false);
                this.removeAll.setEnabled(false);
                this.upload.setEnabled(false);
            }
        } else if (e.getActionCommand() == this.removeAll.getActionCommand()) {
            this.fp.removeAll();
            this.remove.setEnabled(false);
            this.removeAll.setEnabled(false);
            this.upload.setEnabled(false);
        } else if (e.getActionCommand() == this.upload.getActionCommand()) {
            this.fut = new FileUploadThreadV2(this.fp.getFiles(), this.postURL);
            this.fut.setProgressPanel(this.progress);
            this.fut.start();
            this.browse.setEnabled(false);
            this.remove.setEnabled(false);
            this.removeAll.setEnabled(false);
            this.upload.setEnabled(false);
            this.stop.setEnabled(true);
            this.timer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (!JUploadPanel.this.fut.isAlive()) {
                        JUploadPanel.this.timer.stop();
                        boolean isSuccess = false;
                        if (null != JUploadPanel.this.fut.getException()) {
                            JOptionPane.showMessageDialog(null, "ERROR  : " + JUploadPanel.this.fut.getException().toString());
                        } else {
                            JOptionPane.showMessageDialog(null, JUploadPanel.this.fp.getFilesLength() + " file(s) uploaded successfully");
                            JUploadPanel.this.fp.removeAll();
                            isSuccess = true;
                        }
                        StringBuffer svrRet = JUploadPanel.this.fut.getServerOutput();
                        JUploadPanel.this.fut.close();
                        JUploadPanel.this.fut = null;
                        JUploadPanel.this.progress.setString(null);
                        JUploadPanel.this.progress.setValue(0);
                        if (null != JUploadPanel.this.aus && isSuccess) {
                            JUploadPanel.this.aus.executeThis(svrRet);
                        }
                        JUploadPanel.this.stop.setEnabled(false);
                        if (!isSuccess) {
                            JUploadPanel.this.remove.setEnabled(true);
                            JUploadPanel.this.removeAll.setEnabled(true);
                            JUploadPanel.this.upload.setEnabled(true);
                        }
                        JUploadPanel.this.browse.setEnabled(true);
                    }
                }
            });
            this.timer.start();
        } else if (e.getActionCommand() == this.stop.getActionCommand()) {
            this.stop.setEnabled(false);
            if (null != this.timer) {
                this.timer.stop();
            }
            this.timer = null;
            if (null != this.fut) {
                if (this.fut.isAlive()) {
                    this.fut.stopUpload();
                    try {
                        this.fut.join(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.fut.close();
            }
            this.fut = null;
            this.remove.setEnabled(true);
            this.removeAll.setEnabled(true);
            this.upload.setEnabled(true);
            this.browse.setEnabled(true);
        }
    }
}

