/*
 * Decompiled with CFR 0.152.
 */
package jupload;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JProgressBar;

public class FileUploadThread
extends Thread {
    public static final double VERSION = 1.0;
    public static final String AUTHOR = "William Kwong Jinhua";
    public static final String AUTHOR_EMAIL = "wjhkwong@yahoo.com";
    public static final String DESCRIPTION = "Java Thread to upload files into a web server.";
    public static final String LAST_MODIFIED = "01 July 2002";
    private File[] aTotalFiles;
    private String uploadURL;
    private JProgressBar progress;
    private long totalFilesLength;
    private long uploadedLength;
    private StringBuffer sb = new StringBuffer();
    private Exception e = null;
    private boolean stop = false;

    private void addServerOutPut(String s) {
        if (0 < this.sb.length() || !s.equals("")) {
            this.sb.append(s);
        }
    }

    public StringBuffer getServerOutput() {
        return this.sb;
    }

    public Exception getException() {
        return this.e;
    }

    public void setProgressPanel(JProgressBar pgrBar) {
        this.progress = pgrBar;
    }

    public void stopUpload() {
        this.stop = true;
    }

    public FileUploadThread(File[] files, String uploadURL) {
        this.aTotalFiles = files;
        this.uploadURL = uploadURL;
        this.totalFilesLength = 0L;
        for (int i = 0; i < this.aTotalFiles.length; ++i) {
            this.totalFilesLength += this.aTotalFiles[i].length();
        }
    }

    public void close() {
        this.aTotalFiles = null;
        this.e = null;
        this.sb = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block17: {
            String str;
            URL url = null;
            URLConnection urlConn = null;
            FilterOutputStream dOut = null;
            BufferedReader bInp = null;
            url = new URL(this.uploadURL);
            urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            String boundary = "-----------------------------" + this.getRandomString();
            urlConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary.substring(2, boundary.length()));
            String CRLF = "\r\n";
            dOut = new DataOutputStream(urlConn.getOutputStream());
            this.uploadedLength = 0L;
            this.progress.setMaximum((int)this.totalFilesLength);
            for (int i = 0; i < this.aTotalFiles.length && !this.stop; ++i) {
                File f = this.aTotalFiles[i];
                StringBuffer sb = new StringBuffer();
                sb.append(boundary);
                sb.append(CRLF);
                sb.append("Content-Disposition: form-data; name=\"File");
                sb.append(i);
                sb.append("\"; filename=\"");
                sb.append(f.toString());
                sb.append("\"");
                sb.append(CRLF);
                sb.append("Content-Type: application/octet-stream");
                sb.append(CRLF);
                sb.append(CRLF);
                ((DataOutputStream)dOut).writeBytes(sb.toString());
                this.uploadFileStream(f, (DataOutputStream)dOut);
                ((DataOutputStream)dOut).writeBytes(CRLF);
            }
            ((DataOutputStream)dOut).writeBytes(boundary);
            ((DataOutputStream)dOut).writeBytes("--");
            ((DataOutputStream)dOut).writeBytes(CRLF);
            ((DataOutputStream)dOut).flush();
            if (!this.stop) {
                this.progress.setString("File(s) uploaded. Wait for server response!");
            }
            bInp = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            while (null != (str = bInp.readLine())) {
                this.addServerOutPut(str);
            }
            Object var11_12 = null;
            try {
                bInp.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            bInp = null;
            try {
                dOut.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            dOut = null;
            urlConn = null;
            url = null;
            {
                break block17;
                catch (Exception e) {
                    this.e = e;
                    Object var11_13 = null;
                    try {
                        bInp.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    bInp = null;
                    try {
                        dOut.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    dOut = null;
                    urlConn = null;
                    url = null;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    bInp.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                bInp = null;
                try {
                    dOut.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                dOut = null;
                urlConn = null;
                url = null;
                throw throwable;
            }
        }
    }

    private String getRandomString() {
        String alphaNum = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuffer sbRan = new StringBuffer(11);
        for (int i = 0; i < 11; ++i) {
            int num = (int)(Math.random() * (double)(alphaNum.length() - 1));
            sbRan.append(alphaNum.substring(num, num + 1));
        }
        return sbRan.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFileStream(File f, DataOutputStream dOut) throws FileNotFoundException, IOException {
        byte[] byteBuff = null;
        FileInputStream fis = null;
        try {
            int numBytes = 0;
            byteBuff = new byte[1024];
            fis = new FileInputStream(f);
            while (-1 != (numBytes = fis.read(byteBuff)) && !this.stop) {
                dOut.write(byteBuff, 0, numBytes);
                this.uploadedLength += (long)numBytes;
                if (null == this.progress) continue;
                this.progress.setValue((int)this.uploadedLength);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {}
            byteBuff = null;
        }
    }
}

