/*
 * Decompiled with CFR 0.152.
 */
package jupload;

import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jupload.DnDListener;
import jupload.FilePanel;
import jupload.JUploadPanel;

public class FilePanelImp
extends Panel
implements FilePanel {
    public static final String TITLE = "JUpload DnDListener";
    public static final String DESCRIPTION = "FilePanel Implementation.";
    public static final String AUTHOR = "William JinHua Kwong";
    public static final double VERSION = 1.1;
    public static final String LAST_MODIFIED = "22 January 2004";
    private DefaultListModel listModel;
    private JList jlist;
    private DropTarget dropTarget;
    private DropTargetListener dtListener;

    public FilePanelImp(JUploadPanel jup) {
        this.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.jlist = new JList(this.listModel);
        JScrollPane listScroll = new JScrollPane(this.jlist);
        this.dropTarget = new DropTarget(this.jlist, new DnDListener(jup));
        this.add(listScroll);
    }

    public void addFiles(File[] f) {
        if (null != f) {
            for (int i = 0; i < f.length; ++i) {
                this.addDirectoryFiles(this.listModel, f[i]);
            }
        }
    }

    protected void addDirectoryFiles(DefaultListModel dlm, File f) {
        if (!f.isDirectory()) {
            this.addFileOnly(dlm, f);
        } else {
            File[] dirFiles = f.listFiles();
            for (int i = 0; i < dirFiles.length; ++i) {
                if (dirFiles[i].isDirectory()) {
                    this.addDirectoryFiles(dlm, dirFiles[i]);
                    continue;
                }
                this.addFileOnly(dlm, dirFiles[i]);
            }
        }
    }

    protected void addFileOnly(DefaultListModel dlm, File f) {
        if (!dlm.contains(f)) {
            dlm.add(dlm.getSize(), f);
        }
    }

    public File[] getFiles() {
        Object[] arrayFiles = new File[this.listModel.size()];
        this.listModel.copyInto(arrayFiles);
        return arrayFiles;
    }

    public int getFilesLength() {
        return this.listModel.size();
    }

    public void removeSelected() {
        int i = 0;
        while (i < this.listModel.size()) {
            if (this.jlist.isSelectedIndex(i)) {
                this.listModel.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void removeAll() {
        this.listModel.clear();
    }
}

