// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/v1/workflows.proto

#include "google/cloud/workflows/workflows_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace workflows {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

WorkflowsConnectionIdempotencyPolicy::~WorkflowsConnectionIdempotencyPolicy() =
    default;

namespace {
class DefaultWorkflowsConnectionIdempotencyPolicy
    : public WorkflowsConnectionIdempotencyPolicy {
 public:
  ~DefaultWorkflowsConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<WorkflowsConnectionIdempotencyPolicy> clone() const override {
    return absl::make_unique<DefaultWorkflowsConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListWorkflows(
      google::cloud::workflows::v1::ListWorkflowsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetWorkflow(
      google::cloud::workflows::v1::GetWorkflowRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateWorkflow(
      google::cloud::workflows::v1::CreateWorkflowRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteWorkflow(
      google::cloud::workflows::v1::DeleteWorkflowRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateWorkflow(
      google::cloud::workflows::v1::UpdateWorkflowRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<WorkflowsConnectionIdempotencyPolicy>
MakeDefaultWorkflowsConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultWorkflowsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows
}  // namespace cloud
}  // namespace google
