// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/v1/workflows.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_WORKFLOWS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_WORKFLOWS_CONNECTION_H

#include "google/cloud/workflows/internal/workflows_retry_traits.h"
#include "google/cloud/workflows/internal/workflows_stub.h"
#include "google/cloud/workflows/workflows_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace workflows {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using WorkflowsRetryPolicy = ::google::cloud::internal::TraitBasedRetryPolicy<
    workflows_internal::WorkflowsRetryTraits>;

using WorkflowsLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        workflows_internal::WorkflowsRetryTraits>;

using WorkflowsLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        workflows_internal::WorkflowsRetryTraits>;

class WorkflowsConnection {
 public:
  virtual ~WorkflowsConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::workflows::v1::Workflow> ListWorkflows(
      google::cloud::workflows::v1::ListWorkflowsRequest request);

  virtual StatusOr<google::cloud::workflows::v1::Workflow> GetWorkflow(
      google::cloud::workflows::v1::GetWorkflowRequest const& request);

  virtual future<StatusOr<google::cloud::workflows::v1::Workflow>>
  CreateWorkflow(
      google::cloud::workflows::v1::CreateWorkflowRequest const& request);

  virtual future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
  DeleteWorkflow(
      google::cloud::workflows::v1::DeleteWorkflowRequest const& request);

  virtual future<StatusOr<google::cloud::workflows::v1::Workflow>>
  UpdateWorkflow(
      google::cloud::workflows::v1::UpdateWorkflowRequest const& request);
};

std::shared_ptr<WorkflowsConnection> MakeWorkflowsConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace workflows_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<workflows::WorkflowsConnection> MakeWorkflowsConnection(
    std::shared_ptr<WorkflowsStub> stub, Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_WORKFLOWS_CONNECTION_H
