// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/v1/workflows.proto

#include "google/cloud/workflows/workflows_connection.h"
#include "google/cloud/workflows/internal/workflows_connection_impl.h"
#include "google/cloud/workflows/internal/workflows_option_defaults.h"
#include "google/cloud/workflows/internal/workflows_stub_factory.h"
#include "google/cloud/workflows/workflows_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace workflows {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WorkflowsConnection::~WorkflowsConnection() = default;

StreamRange<google::cloud::workflows::v1::Workflow>
WorkflowsConnection::ListWorkflows(
    google::cloud::workflows::v1::ListWorkflowsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::workflows::v1::Workflow>>(
      std::move(request),
      [](google::cloud::workflows::v1::ListWorkflowsRequest const&) {
        return StatusOr<google::cloud::workflows::v1::ListWorkflowsResponse>{};
      },
      [](google::cloud::workflows::v1::ListWorkflowsResponse const&) {
        return std::vector<google::cloud::workflows::v1::Workflow>();
      });
}

StatusOr<google::cloud::workflows::v1::Workflow>
WorkflowsConnection::GetWorkflow(
    google::cloud::workflows::v1::GetWorkflowRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsConnection::CreateWorkflow(
    google::cloud::workflows::v1::CreateWorkflowRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workflows::v1::Workflow>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
WorkflowsConnection::DeleteWorkflow(
    google::cloud::workflows::v1::DeleteWorkflowRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workflows::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::workflows::v1::Workflow>>
WorkflowsConnection::UpdateWorkflow(
    google::cloud::workflows::v1::UpdateWorkflowRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::workflows::v1::Workflow>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<WorkflowsConnection> MakeWorkflowsConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 WorkflowsPolicyOptionList>(options, __func__);
  options = workflows_internal::WorkflowsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      workflows_internal::CreateDefaultWorkflowsStub(background->cq(), options);
  return std::make_shared<workflows_internal::WorkflowsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace workflows_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<workflows::WorkflowsConnection> MakeWorkflowsConnection(
    std::shared_ptr<WorkflowsStub> stub, Options options) {
  options = WorkflowsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<workflows_internal::WorkflowsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_internal
}  // namespace cloud
}  // namespace google
