// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/v1/workflows.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_WORKFLOWS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_WORKFLOWS_CLIENT_H

#include "google/cloud/workflows/workflows_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace workflows {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Workflows is used to deploy and execute workflow programs.
/// Workflows makes sure the program executes reliably, despite hardware and
/// networking interruptions.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class WorkflowsClient {
 public:
  explicit WorkflowsClient(std::shared_ptr<WorkflowsConnection> connection,
                           Options options = {});
  ~WorkflowsClient();

  //@{
  // @name Copy and move support
  WorkflowsClient(WorkflowsClient const&) = default;
  WorkflowsClient& operator=(WorkflowsClient const&) = default;
  WorkflowsClient(WorkflowsClient&&) = default;
  WorkflowsClient& operator=(WorkflowsClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(WorkflowsClient const& a, WorkflowsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(WorkflowsClient const& a, WorkflowsClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists Workflows in a given project and location.
  /// The default order is not specified.
  ///
  /// @param parent  Required. Project and location from which the workflows
  /// should be listed.
  ///  Format: projects/{project}/locations/{location}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::Workflow,google/cloud/workflows/v1/workflows.proto#L104}
  ///
  /// [google.cloud.workflows.v1.ListWorkflowsRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L186}
  /// [google.cloud.workflows.v1.Workflow]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L104}
  ///
  StreamRange<google::cloud::workflows::v1::Workflow> ListWorkflows(
      std::string const& parent, Options options = {});

  ///
  /// Lists Workflows in a given project and location.
  /// The default order is not specified.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::workflows::v1::ListWorkflowsRequest,google/cloud/workflows/v1/workflows.proto#L186}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::Workflow,google/cloud/workflows/v1/workflows.proto#L104}
  ///
  /// [google.cloud.workflows.v1.ListWorkflowsRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L186}
  /// [google.cloud.workflows.v1.Workflow]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L104}
  ///
  StreamRange<google::cloud::workflows::v1::Workflow> ListWorkflows(
      google::cloud::workflows::v1::ListWorkflowsRequest request,
      Options options = {});

  ///
  /// Gets details of a single Workflow.
  ///
  /// @param name  Required. Name of the workflow which information should be
  /// retrieved.
  ///  Format: projects/{project}/locations/{location}/workflows/{workflow}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::Workflow,google/cloud/workflows/v1/workflows.proto#L104}
  ///
  /// [google.cloud.workflows.v1.GetWorkflowRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L236}
  /// [google.cloud.workflows.v1.Workflow]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L104}
  ///
  StatusOr<google::cloud::workflows::v1::Workflow> GetWorkflow(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single Workflow.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::workflows::v1::GetWorkflowRequest,google/cloud/workflows/v1/workflows.proto#L236}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::Workflow,google/cloud/workflows/v1/workflows.proto#L104}
  ///
  /// [google.cloud.workflows.v1.GetWorkflowRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L236}
  /// [google.cloud.workflows.v1.Workflow]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L104}
  ///
  StatusOr<google::cloud::workflows::v1::Workflow> GetWorkflow(
      google::cloud::workflows::v1::GetWorkflowRequest const& request,
      Options options = {});

  ///
  /// Creates a new workflow. If a workflow with the specified name already
  /// exists in the specified project and location, the long running operation
  /// will return [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
  ///
  /// @param parent  Required. Project and location in which the workflow should
  /// be created.
  ///  Format:  projects/{project}/locations/{location}
  /// @param workflow  Required. Workflow to be created.
  /// @param workflow_id  Required. The ID of the workflow to be created. It has
  /// to fulfill the
  ///  following requirements:
  ///  * Must contain only letters, numbers, underscores and hyphens.
  ///  * Must start with a letter.
  ///  * Must be between 1-64 characters.
  ///  * Must end with a number or a letter.
  ///  * Must be unique within the customer project and location.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::Workflow,google/cloud/workflows/v1/workflows.proto#L104}
  ///
  /// [google.cloud.workflows.v1.CreateWorkflowRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L250}
  /// [google.cloud.workflows.v1.Workflow]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L104}
  ///
  future<StatusOr<google::cloud::workflows::v1::Workflow>> CreateWorkflow(
      std::string const& parent,
      google::cloud::workflows::v1::Workflow const& workflow,
      std::string const& workflow_id, Options options = {});

  ///
  /// Creates a new workflow. If a workflow with the specified name already
  /// exists in the specified project and location, the long running operation
  /// will return [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::workflows::v1::CreateWorkflowRequest,google/cloud/workflows/v1/workflows.proto#L250}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::Workflow,google/cloud/workflows/v1/workflows.proto#L104}
  ///
  /// [google.cloud.workflows.v1.CreateWorkflowRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L250}
  /// [google.cloud.workflows.v1.Workflow]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L104}
  ///
  future<StatusOr<google::cloud::workflows::v1::Workflow>> CreateWorkflow(
      google::cloud::workflows::v1::CreateWorkflowRequest const& request,
      Options options = {});

  ///
  /// Deletes a workflow with the specified name.
  /// This method also cancels and deletes all running executions of the
  /// workflow.
  ///
  /// @param name  Required. Name of the workflow to be deleted.
  ///  Format: projects/{project}/locations/{location}/workflows/{workflow}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::OperationMetadata,google/cloud/workflows/v1/workflows.proto#L301}
  ///
  /// [google.cloud.workflows.v1.DeleteWorkflowRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L277}
  /// [google.cloud.workflows.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L301}
  ///
  future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
  DeleteWorkflow(std::string const& name, Options options = {});

  ///
  /// Deletes a workflow with the specified name.
  /// This method also cancels and deletes all running executions of the
  /// workflow.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::workflows::v1::DeleteWorkflowRequest,google/cloud/workflows/v1/workflows.proto#L277}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::OperationMetadata,google/cloud/workflows/v1/workflows.proto#L301}
  ///
  /// [google.cloud.workflows.v1.DeleteWorkflowRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L277}
  /// [google.cloud.workflows.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L301}
  ///
  future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
  DeleteWorkflow(
      google::cloud::workflows::v1::DeleteWorkflowRequest const& request,
      Options options = {});

  ///
  /// Updates an existing workflow.
  /// Running this method has no impact on already running executions of the
  /// workflow. A new revision of the workflow may be created as a result of a
  /// successful update operation. In that case, such revision will be used
  /// in new workflow executions.
  ///
  /// @param workflow  Required. Workflow to be updated.
  /// @param update_mask  List of fields to be updated. If not present, the
  /// entire workflow
  ///  will be updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::Workflow,google/cloud/workflows/v1/workflows.proto#L104}
  ///
  /// [google.cloud.workflows.v1.UpdateWorkflowRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L291}
  /// [google.cloud.workflows.v1.Workflow]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L104}
  ///
  future<StatusOr<google::cloud::workflows::v1::Workflow>> UpdateWorkflow(
      google::cloud::workflows::v1::Workflow const& workflow,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates an existing workflow.
  /// Running this method has no impact on already running executions of the
  /// workflow. A new revision of the workflow may be created as a result of a
  /// successful update operation. In that case, such revision will be used
  /// in new workflow executions.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::workflows::v1::UpdateWorkflowRequest,google/cloud/workflows/v1/workflows.proto#L291}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::workflows::v1::Workflow,google/cloud/workflows/v1/workflows.proto#L104}
  ///
  /// [google.cloud.workflows.v1.UpdateWorkflowRequest]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L291}
  /// [google.cloud.workflows.v1.Workflow]:
  /// @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L104}
  ///
  future<StatusOr<google::cloud::workflows::v1::Workflow>> UpdateWorkflow(
      google::cloud::workflows::v1::UpdateWorkflowRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<WorkflowsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_WORKFLOWS_CLIENT_H
