// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/v1/workflows.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_INTERNAL_WORKFLOWS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_INTERNAL_WORKFLOWS_CONNECTION_IMPL_H

#include "google/cloud/workflows/internal/workflows_retry_traits.h"
#include "google/cloud/workflows/internal/workflows_stub.h"
#include "google/cloud/workflows/workflows_connection.h"
#include "google/cloud/workflows/workflows_connection_idempotency_policy.h"
#include "google/cloud/workflows/workflows_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace workflows_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class WorkflowsConnectionImpl : public workflows::WorkflowsConnection {
 public:
  ~WorkflowsConnectionImpl() override = default;

  WorkflowsConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<workflows_internal::WorkflowsStub> stub, Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::workflows::v1::Workflow> ListWorkflows(
      google::cloud::workflows::v1::ListWorkflowsRequest request) override;

  StatusOr<google::cloud::workflows::v1::Workflow> GetWorkflow(
      google::cloud::workflows::v1::GetWorkflowRequest const& request) override;

  future<StatusOr<google::cloud::workflows::v1::Workflow>> CreateWorkflow(
      google::cloud::workflows::v1::CreateWorkflowRequest const& request)
      override;

  future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
  DeleteWorkflow(google::cloud::workflows::v1::DeleteWorkflowRequest const&
                     request) override;

  future<StatusOr<google::cloud::workflows::v1::Workflow>> UpdateWorkflow(
      google::cloud::workflows::v1::UpdateWorkflowRequest const& request)
      override;

 private:
  std::unique_ptr<workflows::WorkflowsRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<workflows::WorkflowsRetryPolicyOption>()) {
      return options.get<workflows::WorkflowsRetryPolicyOption>()->clone();
    }
    return options_.get<workflows::WorkflowsRetryPolicyOption>()->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<workflows::WorkflowsBackoffPolicyOption>()) {
      return options.get<workflows::WorkflowsBackoffPolicyOption>()->clone();
    }
    return options_.get<workflows::WorkflowsBackoffPolicyOption>()->clone();
  }

  std::unique_ptr<workflows::WorkflowsConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<workflows::WorkflowsConnectionIdempotencyPolicyOption>()) {
      return options
          .get<workflows::WorkflowsConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<workflows::WorkflowsConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<PollingPolicy> polling_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<workflows::WorkflowsPollingPolicyOption>()) {
      return options.get<workflows::WorkflowsPollingPolicyOption>()->clone();
    }
    return options_.get<workflows::WorkflowsPollingPolicyOption>()->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<workflows_internal::WorkflowsStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_INTERNAL_WORKFLOWS_CONNECTION_IMPL_H
