// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/executions/v1/executions.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_INTERNAL_EXECUTIONS_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_INTERNAL_EXECUTIONS_STUB_H

#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/workflows/executions/v1/executions.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace workflows_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ExecutionsStub {
 public:
  virtual ~ExecutionsStub() = 0;

  virtual StatusOr<
      google::cloud::workflows::executions::v1::ListExecutionsResponse>
  ListExecutions(
      grpc::ClientContext& context,
      google::cloud::workflows::executions::v1::ListExecutionsRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::workflows::executions::v1::Execution>
  CreateExecution(
      grpc::ClientContext& context,
      google::cloud::workflows::executions::v1::CreateExecutionRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::workflows::executions::v1::Execution>
  GetExecution(
      grpc::ClientContext& context,
      google::cloud::workflows::executions::v1::GetExecutionRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::workflows::executions::v1::Execution>
  CancelExecution(
      grpc::ClientContext& context,
      google::cloud::workflows::executions::v1::CancelExecutionRequest const&
          request) = 0;
};

class DefaultExecutionsStub : public ExecutionsStub {
 public:
  explicit DefaultExecutionsStub(
      std::unique_ptr<
          google::cloud::workflows::executions::v1::Executions::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::workflows::executions::v1::ListExecutionsResponse>
  ListExecutions(
      grpc::ClientContext& client_context,
      google::cloud::workflows::executions::v1::ListExecutionsRequest const&
          request) override;

  StatusOr<google::cloud::workflows::executions::v1::Execution> CreateExecution(
      grpc::ClientContext& client_context,
      google::cloud::workflows::executions::v1::CreateExecutionRequest const&
          request) override;

  StatusOr<google::cloud::workflows::executions::v1::Execution> GetExecution(
      grpc::ClientContext& client_context,
      google::cloud::workflows::executions::v1::GetExecutionRequest const&
          request) override;

  StatusOr<google::cloud::workflows::executions::v1::Execution> CancelExecution(
      grpc::ClientContext& client_context,
      google::cloud::workflows::executions::v1::CancelExecutionRequest const&
          request) override;

 private:
  std::unique_ptr<
      google::cloud::workflows::executions::v1::Executions::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_INTERNAL_EXECUTIONS_STUB_H
