// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/executions/v1/executions.proto

#include "google/cloud/workflows/internal/executions_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/workflows/executions/v1/executions.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace workflows_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ExecutionsMetadata::ExecutionsMetadata(std::shared_ptr<ExecutionsStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::workflows::executions::v1::ListExecutionsResponse>
ExecutionsMetadata::ListExecutions(
    grpc::ClientContext& context,
    google::cloud::workflows::executions::v1::ListExecutionsRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListExecutions(context, request);
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsMetadata::CreateExecution(
    grpc::ClientContext& context,
    google::cloud::workflows::executions::v1::CreateExecutionRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateExecution(context, request);
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsMetadata::GetExecution(
    grpc::ClientContext& context,
    google::cloud::workflows::executions::v1::GetExecutionRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetExecution(context, request);
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsMetadata::CancelExecution(
    grpc::ClientContext& context,
    google::cloud::workflows::executions::v1::CancelExecutionRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->CancelExecution(context, request);
}

void ExecutionsMetadata::SetMetadata(grpc::ClientContext& context,
                                     std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void ExecutionsMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_internal
}  // namespace cloud
}  // namespace google
