// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/executions/v1/executions.proto

#include "google/cloud/workflows/executions_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace workflows {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ExecutionsConnectionIdempotencyPolicy::
    ~ExecutionsConnectionIdempotencyPolicy() = default;

namespace {
class DefaultExecutionsConnectionIdempotencyPolicy
    : public ExecutionsConnectionIdempotencyPolicy {
 public:
  ~DefaultExecutionsConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ExecutionsConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultExecutionsConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListExecutions(
      google::cloud::workflows::executions::v1::ListExecutionsRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateExecution(
      google::cloud::workflows::executions::v1::CreateExecutionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetExecution(
      google::cloud::workflows::executions::v1::GetExecutionRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CancelExecution(
      google::cloud::workflows::executions::v1::CancelExecutionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ExecutionsConnectionIdempotencyPolicy>
MakeDefaultExecutionsConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultExecutionsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows
}  // namespace cloud
}  // namespace google
