// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/executions/v1/executions.proto

#include "google/cloud/workflows/executions_connection.h"
#include "google/cloud/workflows/executions_options.h"
#include "google/cloud/workflows/internal/executions_connection_impl.h"
#include "google/cloud/workflows/internal/executions_option_defaults.h"
#include "google/cloud/workflows/internal/executions_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace workflows {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ExecutionsConnection::~ExecutionsConnection() = default;

StreamRange<google::cloud::workflows::executions::v1::Execution>
ExecutionsConnection::ListExecutions(
    google::cloud::workflows::executions::v1::ListExecutionsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::workflows::executions::v1::Execution>>(
      std::move(request),
      [](google::cloud::workflows::executions::v1::
             ListExecutionsRequest const&) {
        return StatusOr<
            google::cloud::workflows::executions::v1::ListExecutionsResponse>{};
      },
      [](google::cloud::workflows::executions::v1::
             ListExecutionsResponse const&) {
        return std::vector<
            google::cloud::workflows::executions::v1::Execution>();
      });
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsConnection::CreateExecution(
    google::cloud::workflows::executions::v1::CreateExecutionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsConnection::GetExecution(
    google::cloud::workflows::executions::v1::GetExecutionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsConnection::CancelExecution(
    google::cloud::workflows::executions::v1::CancelExecutionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ExecutionsConnection> MakeExecutionsConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 ExecutionsPolicyOptionList>(options, __func__);
  options = workflows_internal::ExecutionsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = workflows_internal::CreateDefaultExecutionsStub(background->cq(),
                                                              options);
  return std::make_shared<workflows_internal::ExecutionsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace workflows_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<workflows::ExecutionsConnection> MakeExecutionsConnection(
    std::shared_ptr<ExecutionsStub> stub, Options options) {
  options = ExecutionsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<workflows_internal::ExecutionsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_internal
}  // namespace cloud
}  // namespace google
