// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/websecurityscanner/v1/web_security_scanner.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_WEB_SECURITY_SCANNER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_WEB_SECURITY_SCANNER_CLIENT_H

#include "google/cloud/websecurityscanner/web_security_scanner_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace websecurityscanner {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Web Security Scanner Service identifies security vulnerabilities in web
/// applications hosted on Google Cloud. It crawls your application, and
/// attempts to exercise as many user inputs and event handlers as possible.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class WebSecurityScannerClient {
 public:
  explicit WebSecurityScannerClient(
      std::shared_ptr<WebSecurityScannerConnection> connection,
      Options options = {});
  ~WebSecurityScannerClient();

  //@{
  // @name Copy and move support
  WebSecurityScannerClient(WebSecurityScannerClient const&) = default;
  WebSecurityScannerClient& operator=(WebSecurityScannerClient const&) =
      default;
  WebSecurityScannerClient(WebSecurityScannerClient&&) = default;
  WebSecurityScannerClient& operator=(WebSecurityScannerClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(WebSecurityScannerClient const& a,
                         WebSecurityScannerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(WebSecurityScannerClient const& a,
                         WebSecurityScannerClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates a new ScanConfig.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::CreateScanConfigRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L142}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ScanConfig,google/cloud/websecurityscanner/v1/scan_config.proto#L31}
  ///
  /// [google.cloud.websecurityscanner.v1.CreateScanConfigRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L142}
  /// [google.cloud.websecurityscanner.v1.ScanConfig]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/scan_config.proto#L31}
  ///
  StatusOr<google::cloud::websecurityscanner::v1::ScanConfig> CreateScanConfig(
      google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&
          request,
      Options options = {});

  ///
  /// Deletes an existing ScanConfig and its child resources.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::DeleteScanConfigRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L152}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.websecurityscanner.v1.DeleteScanConfigRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L152}
  ///
  Status DeleteScanConfig(
      google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&
          request,
      Options options = {});

  ///
  /// Gets a ScanConfig.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::GetScanConfigRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L159}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ScanConfig,google/cloud/websecurityscanner/v1/scan_config.proto#L31}
  ///
  /// [google.cloud.websecurityscanner.v1.GetScanConfigRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L159}
  /// [google.cloud.websecurityscanner.v1.ScanConfig]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/scan_config.proto#L31}
  ///
  StatusOr<google::cloud::websecurityscanner::v1::ScanConfig> GetScanConfig(
      google::cloud::websecurityscanner::v1::GetScanConfigRequest const&
          request,
      Options options = {});

  ///
  /// Lists ScanConfigs under a given project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ListScanConfigsRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L166}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ScanConfig,google/cloud/websecurityscanner/v1/scan_config.proto#L31}
  ///
  /// [google.cloud.websecurityscanner.v1.ListScanConfigsRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L166}
  /// [google.cloud.websecurityscanner.v1.ScanConfig]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/scan_config.proto#L31}
  ///
  StreamRange<google::cloud::websecurityscanner::v1::ScanConfig>
  ListScanConfigs(
      google::cloud::websecurityscanner::v1::ListScanConfigsRequest request,
      Options options = {});

  ///
  /// Updates a ScanConfig. This method support partial update of a ScanConfig.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::UpdateScanConfigRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L183}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ScanConfig,google/cloud/websecurityscanner/v1/scan_config.proto#L31}
  ///
  /// [google.cloud.websecurityscanner.v1.UpdateScanConfigRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L183}
  /// [google.cloud.websecurityscanner.v1.ScanConfig]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/scan_config.proto#L31}
  ///
  StatusOr<google::cloud::websecurityscanner::v1::ScanConfig> UpdateScanConfig(
      google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&
          request,
      Options options = {});

  ///
  /// Start a ScanRun according to the given ScanConfig.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::StartScanRunRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L206}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ScanRun,google/cloud/websecurityscanner/v1/scan_run.proto#L33}
  ///
  /// [google.cloud.websecurityscanner.v1.StartScanRunRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L206}
  /// [google.cloud.websecurityscanner.v1.ScanRun]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/scan_run.proto#L33}
  ///
  StatusOr<google::cloud::websecurityscanner::v1::ScanRun> StartScanRun(
      google::cloud::websecurityscanner::v1::StartScanRunRequest const& request,
      Options options = {});

  ///
  /// Gets a ScanRun.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::GetScanRunRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L213}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ScanRun,google/cloud/websecurityscanner/v1/scan_run.proto#L33}
  ///
  /// [google.cloud.websecurityscanner.v1.GetScanRunRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L213}
  /// [google.cloud.websecurityscanner.v1.ScanRun]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/scan_run.proto#L33}
  ///
  StatusOr<google::cloud::websecurityscanner::v1::ScanRun> GetScanRun(
      google::cloud::websecurityscanner::v1::GetScanRunRequest const& request,
      Options options = {});

  ///
  /// Lists ScanRuns under a given ScanConfig, in descending order of ScanRun
  /// stop time.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ListScanRunsRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L221}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ScanRun,google/cloud/websecurityscanner/v1/scan_run.proto#L33}
  ///
  /// [google.cloud.websecurityscanner.v1.ListScanRunsRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L221}
  /// [google.cloud.websecurityscanner.v1.ScanRun]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/scan_run.proto#L33}
  ///
  StreamRange<google::cloud::websecurityscanner::v1::ScanRun> ListScanRuns(
      google::cloud::websecurityscanner::v1::ListScanRunsRequest request,
      Options options = {});

  ///
  /// Stops a ScanRun. The stopped ScanRun is returned.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::StopScanRunRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L248}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ScanRun,google/cloud/websecurityscanner/v1/scan_run.proto#L33}
  ///
  /// [google.cloud.websecurityscanner.v1.StopScanRunRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L248}
  /// [google.cloud.websecurityscanner.v1.ScanRun]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/scan_run.proto#L33}
  ///
  StatusOr<google::cloud::websecurityscanner::v1::ScanRun> StopScanRun(
      google::cloud::websecurityscanner::v1::StopScanRunRequest const& request,
      Options options = {});

  ///
  /// List CrawledUrls under a given ScanRun.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L256}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::CrawledUrl,google/cloud/websecurityscanner/v1/crawled_url.proto#L30}
  ///
  /// [google.cloud.websecurityscanner.v1.ListCrawledUrlsRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L256}
  /// [google.cloud.websecurityscanner.v1.CrawledUrl]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/crawled_url.proto#L30}
  ///
  StreamRange<google::cloud::websecurityscanner::v1::CrawledUrl>
  ListCrawledUrls(
      google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest request,
      Options options = {});

  ///
  /// Gets a Finding.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::GetFindingRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L284}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::Finding,google/cloud/websecurityscanner/v1/finding.proto#L33}
  ///
  /// [google.cloud.websecurityscanner.v1.GetFindingRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L284}
  /// [google.cloud.websecurityscanner.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/finding.proto#L33}
  ///
  StatusOr<google::cloud::websecurityscanner::v1::Finding> GetFinding(
      google::cloud::websecurityscanner::v1::GetFindingRequest const& request,
      Options options = {});

  ///
  /// List Findings under a given ScanRun.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ListFindingsRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L292}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::Finding,google/cloud/websecurityscanner/v1/finding.proto#L33}
  ///
  /// [google.cloud.websecurityscanner.v1.ListFindingsRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L292}
  /// [google.cloud.websecurityscanner.v1.Finding]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/finding.proto#L33}
  ///
  StreamRange<google::cloud::websecurityscanner::v1::Finding> ListFindings(
      google::cloud::websecurityscanner::v1::ListFindingsRequest request,
      Options options = {});

  ///
  /// List all FindingTypeStats under a given ScanRun.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ListFindingTypeStatsRequest,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L326}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::websecurityscanner::v1::ListFindingTypeStatsResponse,google/cloud/websecurityscanner/v1/web_security_scanner.proto#L334}
  ///
  /// [google.cloud.websecurityscanner.v1.ListFindingTypeStatsRequest]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L326}
  /// [google.cloud.websecurityscanner.v1.ListFindingTypeStatsResponse]:
  /// @googleapis_reference_link{google/cloud/websecurityscanner/v1/web_security_scanner.proto#L334}
  ///
  StatusOr<google::cloud::websecurityscanner::v1::ListFindingTypeStatsResponse>
  ListFindingTypeStats(
      google::cloud::websecurityscanner::v1::ListFindingTypeStatsRequest const&
          request,
      Options options = {});

 private:
  std::shared_ptr<WebSecurityScannerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace websecurityscanner
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_WEB_SECURITY_SCANNER_CLIENT_H
