// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#include "google/cloud/webrisk/web_risk_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace webrisk {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

WebRiskServiceConnectionIdempotencyPolicy::
    ~WebRiskServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultWebRiskServiceConnectionIdempotencyPolicy
    : public WebRiskServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultWebRiskServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<WebRiskServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultWebRiskServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ComputeThreatListDiff(
      google::cloud::webrisk::v1::ComputeThreatListDiffRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency SearchUris(
      google::cloud::webrisk::v1::SearchUrisRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency SearchHashes(
      google::cloud::webrisk::v1::SearchHashesRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateSubmission(
      google::cloud::webrisk::v1::CreateSubmissionRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<WebRiskServiceConnectionIdempotencyPolicy>
MakeDefaultWebRiskServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultWebRiskServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk
}  // namespace cloud
}  // namespace google
