// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_WEB_RISK_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_WEB_RISK_CONNECTION_H

#include "google/cloud/webrisk/internal/web_risk_retry_traits.h"
#include "google/cloud/webrisk/internal/web_risk_stub.h"
#include "google/cloud/webrisk/web_risk_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace webrisk {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using WebRiskServiceRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        webrisk_internal::WebRiskServiceRetryTraits>;

using WebRiskServiceLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        webrisk_internal::WebRiskServiceRetryTraits>;

using WebRiskServiceLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        webrisk_internal::WebRiskServiceRetryTraits>;

class WebRiskServiceConnection {
 public:
  virtual ~WebRiskServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
  ComputeThreatListDiff(
      google::cloud::webrisk::v1::ComputeThreatListDiffRequest const& request);

  virtual StatusOr<google::cloud::webrisk::v1::SearchUrisResponse> SearchUris(
      google::cloud::webrisk::v1::SearchUrisRequest const& request);

  virtual StatusOr<google::cloud::webrisk::v1::SearchHashesResponse>
  SearchHashes(google::cloud::webrisk::v1::SearchHashesRequest const& request);

  virtual StatusOr<google::cloud::webrisk::v1::Submission> CreateSubmission(
      google::cloud::webrisk::v1::CreateSubmissionRequest const& request);
};

std::shared_ptr<WebRiskServiceConnection> MakeWebRiskServiceConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace webrisk_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<webrisk::WebRiskServiceConnection> MakeWebRiskServiceConnection(
    std::shared_ptr<WebRiskServiceStub> stub, Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_WEB_RISK_CONNECTION_H
