// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_WEB_RISK_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_WEB_RISK_CLIENT_H

#include "google/cloud/webrisk/web_risk_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace webrisk {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Web Risk API defines an interface to detect malicious URLs on your
/// website and in client applications.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class WebRiskServiceClient {
 public:
  explicit WebRiskServiceClient(
      std::shared_ptr<WebRiskServiceConnection> connection,
      Options options = {});
  ~WebRiskServiceClient();

  //@{
  // @name Copy and move support
  WebRiskServiceClient(WebRiskServiceClient const&) = default;
  WebRiskServiceClient& operator=(WebRiskServiceClient const&) = default;
  WebRiskServiceClient(WebRiskServiceClient&&) = default;
  WebRiskServiceClient& operator=(WebRiskServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(WebRiskServiceClient const& a,
                         WebRiskServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(WebRiskServiceClient const& a,
                         WebRiskServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Gets the most recent threat list diffs. These diffs should be applied to
  /// a local database of hashes to keep it up-to-date. If the local database is
  /// empty or excessively out-of-date, a complete snapshot of the database will
  /// be returned. This Method only updates a single ThreatList at a time. To
  /// update multiple ThreatList databases, this method needs to be called once
  /// for each list.
  ///
  /// @param threat_type  Required. The threat list to update. Only a single
  /// ThreatType should be specified.
  /// @param version_token  The current version token of the client for the
  /// requested list (the
  ///  client version that was received from the last successful diff).
  ///  If the client does not have a version token (this is the first time
  ///  calling ComputeThreatListDiff), this may be left empty and a full
  ///  database snapshot will be returned.
  /// @param constraints  Required. The constraints associated with this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::webrisk::v1::ComputeThreatListDiffResponse,google/cloud/webrisk/v1/webrisk.proto#L124}
  ///
  /// [google.cloud.webrisk.v1.ComputeThreatListDiffRequest]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L93}
  /// [google.cloud.webrisk.v1.ComputeThreatListDiffResponse]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L124}
  ///
  StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
  ComputeThreatListDiff(
      google::cloud::webrisk::v1::ThreatType threat_type,
      std::string const& version_token,
      google::cloud::webrisk::v1::ComputeThreatListDiffRequest::
          Constraints const& constraints,
      Options options = {});

  ///
  /// Gets the most recent threat list diffs. These diffs should be applied to
  /// a local database of hashes to keep it up-to-date. If the local database is
  /// empty or excessively out-of-date, a complete snapshot of the database will
  /// be returned. This Method only updates a single ThreatList at a time. To
  /// update multiple ThreatList databases, this method needs to be called once
  /// for each list.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::webrisk::v1::ComputeThreatListDiffRequest,google/cloud/webrisk/v1/webrisk.proto#L93}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::webrisk::v1::ComputeThreatListDiffResponse,google/cloud/webrisk/v1/webrisk.proto#L124}
  ///
  /// [google.cloud.webrisk.v1.ComputeThreatListDiffRequest]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L93}
  /// [google.cloud.webrisk.v1.ComputeThreatListDiffResponse]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L124}
  ///
  StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
  ComputeThreatListDiff(
      google::cloud::webrisk::v1::ComputeThreatListDiffRequest const& request,
      Options options = {});

  ///
  /// This method is used to check whether a URI is on a given threatList.
  /// Multiple threatLists may be searched in a single query.
  /// The response will list all requested threatLists the URI was found to
  /// match. If the URI is not found on any of the requested ThreatList an
  /// empty response will be returned.
  ///
  /// @param uri  Required. The URI to be checked for matches.
  /// @param threat_types  Required. The ThreatLists to search in. Multiple
  /// ThreatLists may be specified.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::webrisk::v1::SearchUrisResponse,google/cloud/webrisk/v1/webrisk.proto#L184}
  ///
  /// [google.cloud.webrisk.v1.SearchUrisRequest]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L176}
  /// [google.cloud.webrisk.v1.SearchUrisResponse]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L184}
  ///
  StatusOr<google::cloud::webrisk::v1::SearchUrisResponse> SearchUris(
      std::string const& uri,
      std::vector<google::cloud::webrisk::v1::ThreatType> const& threat_types,
      Options options = {});

  ///
  /// This method is used to check whether a URI is on a given threatList.
  /// Multiple threatLists may be searched in a single query.
  /// The response will list all requested threatLists the URI was found to
  /// match. If the URI is not found on any of the requested ThreatList an
  /// empty response will be returned.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::webrisk::v1::SearchUrisRequest,google/cloud/webrisk/v1/webrisk.proto#L176}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::webrisk::v1::SearchUrisResponse,google/cloud/webrisk/v1/webrisk.proto#L184}
  ///
  /// [google.cloud.webrisk.v1.SearchUrisRequest]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L176}
  /// [google.cloud.webrisk.v1.SearchUrisResponse]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L184}
  ///
  StatusOr<google::cloud::webrisk::v1::SearchUrisResponse> SearchUris(
      google::cloud::webrisk::v1::SearchUrisRequest const& request,
      Options options = {});

  ///
  /// Gets the full hashes that match the requested hash prefix.
  /// This is used after a hash prefix is looked up in a threatList
  /// and there is a match. The client side threatList only holds partial hashes
  /// so the client must query this method to determine if there is a full
  /// hash match of a threat.
  ///
  /// @param hash_prefix  A hash prefix, consisting of the most significant 4-32
  /// bytes of a SHA256
  ///  hash. For JSON requests, this field is base64-encoded.
  /// @param threat_types  Required. The ThreatLists to search in. Multiple
  /// ThreatLists may be specified.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::webrisk::v1::SearchHashesResponse,google/cloud/webrisk/v1/webrisk.proto#L209}
  ///
  /// [google.cloud.webrisk.v1.SearchHashesRequest]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L200}
  /// [google.cloud.webrisk.v1.SearchHashesResponse]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L209}
  ///
  StatusOr<google::cloud::webrisk::v1::SearchHashesResponse> SearchHashes(
      std::string const& hash_prefix,
      std::vector<google::cloud::webrisk::v1::ThreatType> const& threat_types,
      Options options = {});

  ///
  /// Gets the full hashes that match the requested hash prefix.
  /// This is used after a hash prefix is looked up in a threatList
  /// and there is a match. The client side threatList only holds partial hashes
  /// so the client must query this method to determine if there is a full
  /// hash match of a threat.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::webrisk::v1::SearchHashesRequest,google/cloud/webrisk/v1/webrisk.proto#L200}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::webrisk::v1::SearchHashesResponse,google/cloud/webrisk/v1/webrisk.proto#L209}
  ///
  /// [google.cloud.webrisk.v1.SearchHashesRequest]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L200}
  /// [google.cloud.webrisk.v1.SearchHashesResponse]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L209}
  ///
  StatusOr<google::cloud::webrisk::v1::SearchHashesResponse> SearchHashes(
      google::cloud::webrisk::v1::SearchHashesRequest const& request,
      Options options = {});

  ///
  /// Creates a Submission of a URI suspected of containing phishing content to
  /// be reviewed. If the result verifies the existence of malicious phishing
  /// content, the site will be added to the [Google's Social Engineering
  /// lists](https://support.google.com/webmasters/answer/6350487/) in order to
  /// protect users that could get exposed to this threat in the future. Only
  /// projects with CREATE_SUBMISSION_USERS visibility can use this method.
  ///
  /// @param parent  Required. The name of the project that is making the
  /// submission. This string is in
  ///  the format "projects/{project_number}".
  /// @param submission  Required. The submission that contains the content of
  /// the phishing report.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::webrisk::v1::Submission,google/cloud/webrisk/v1/webrisk.proto#L335}
  ///
  /// [google.cloud.webrisk.v1.CreateSubmissionRequest]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L341}
  /// [google.cloud.webrisk.v1.Submission]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L335}
  ///
  StatusOr<google::cloud::webrisk::v1::Submission> CreateSubmission(
      std::string const& parent,
      google::cloud::webrisk::v1::Submission const& submission,
      Options options = {});

  ///
  /// Creates a Submission of a URI suspected of containing phishing content to
  /// be reviewed. If the result verifies the existence of malicious phishing
  /// content, the site will be added to the [Google's Social Engineering
  /// lists](https://support.google.com/webmasters/answer/6350487/) in order to
  /// protect users that could get exposed to this threat in the future. Only
  /// projects with CREATE_SUBMISSION_USERS visibility can use this method.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::webrisk::v1::CreateSubmissionRequest,google/cloud/webrisk/v1/webrisk.proto#L341}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::webrisk::v1::Submission,google/cloud/webrisk/v1/webrisk.proto#L335}
  ///
  /// [google.cloud.webrisk.v1.CreateSubmissionRequest]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L341}
  /// [google.cloud.webrisk.v1.Submission]:
  /// @googleapis_reference_link{google/cloud/webrisk/v1/webrisk.proto#L335}
  ///
  StatusOr<google::cloud::webrisk::v1::Submission> CreateSubmission(
      google::cloud::webrisk::v1::CreateSubmissionRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<WebRiskServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_WEB_RISK_CLIENT_H
