// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_INTERNAL_WEB_RISK_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_INTERNAL_WEB_RISK_STUB_H

#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/webrisk/v1/webrisk.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace webrisk_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class WebRiskServiceStub {
 public:
  virtual ~WebRiskServiceStub() = 0;

  virtual StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
  ComputeThreatListDiff(
      grpc::ClientContext& context,
      google::cloud::webrisk::v1::ComputeThreatListDiffRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::webrisk::v1::SearchUrisResponse> SearchUris(
      grpc::ClientContext& context,
      google::cloud::webrisk::v1::SearchUrisRequest const& request) = 0;

  virtual StatusOr<google::cloud::webrisk::v1::SearchHashesResponse>
  SearchHashes(
      grpc::ClientContext& context,
      google::cloud::webrisk::v1::SearchHashesRequest const& request) = 0;

  virtual StatusOr<google::cloud::webrisk::v1::Submission> CreateSubmission(
      grpc::ClientContext& context,
      google::cloud::webrisk::v1::CreateSubmissionRequest const& request) = 0;
};

class DefaultWebRiskServiceStub : public WebRiskServiceStub {
 public:
  explicit DefaultWebRiskServiceStub(
      std::unique_ptr<google::cloud::webrisk::v1::WebRiskService::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
  ComputeThreatListDiff(
      grpc::ClientContext& client_context,
      google::cloud::webrisk::v1::ComputeThreatListDiffRequest const& request)
      override;

  StatusOr<google::cloud::webrisk::v1::SearchUrisResponse> SearchUris(
      grpc::ClientContext& client_context,
      google::cloud::webrisk::v1::SearchUrisRequest const& request) override;

  StatusOr<google::cloud::webrisk::v1::SearchHashesResponse> SearchHashes(
      grpc::ClientContext& client_context,
      google::cloud::webrisk::v1::SearchHashesRequest const& request) override;

  StatusOr<google::cloud::webrisk::v1::Submission> CreateSubmission(
      grpc::ClientContext& client_context,
      google::cloud::webrisk::v1::CreateSubmissionRequest const& request)
      override;

 private:
  std::unique_ptr<google::cloud::webrisk::v1::WebRiskService::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_INTERNAL_WEB_RISK_STUB_H
