// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#include "google/cloud/webrisk/internal/web_risk_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/webrisk/v1/webrisk.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace webrisk_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WebRiskServiceMetadata::WebRiskServiceMetadata(
    std::shared_ptr<WebRiskServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
WebRiskServiceMetadata::ComputeThreatListDiff(
    grpc::ClientContext& context,
    google::cloud::webrisk::v1::ComputeThreatListDiffRequest const& request) {
  SetMetadata(context, {});
  return child_->ComputeThreatListDiff(context, request);
}

StatusOr<google::cloud::webrisk::v1::SearchUrisResponse>
WebRiskServiceMetadata::SearchUris(
    grpc::ClientContext& context,
    google::cloud::webrisk::v1::SearchUrisRequest const& request) {
  SetMetadata(context, {});
  return child_->SearchUris(context, request);
}

StatusOr<google::cloud::webrisk::v1::SearchHashesResponse>
WebRiskServiceMetadata::SearchHashes(
    grpc::ClientContext& context,
    google::cloud::webrisk::v1::SearchHashesRequest const& request) {
  SetMetadata(context, {});
  return child_->SearchHashes(context, request);
}

StatusOr<google::cloud::webrisk::v1::Submission>
WebRiskServiceMetadata::CreateSubmission(
    grpc::ClientContext& context,
    google::cloud::webrisk::v1::CreateSubmissionRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateSubmission(context, request);
}

void WebRiskServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                         std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void WebRiskServiceMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk_internal
}  // namespace cloud
}  // namespace google
