// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_INTERNAL_WEB_RISK_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_INTERNAL_WEB_RISK_CONNECTION_IMPL_H

#include "google/cloud/webrisk/internal/web_risk_retry_traits.h"
#include "google/cloud/webrisk/internal/web_risk_stub.h"
#include "google/cloud/webrisk/web_risk_connection.h"
#include "google/cloud/webrisk/web_risk_connection_idempotency_policy.h"
#include "google/cloud/webrisk/web_risk_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace webrisk_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class WebRiskServiceConnectionImpl : public webrisk::WebRiskServiceConnection {
 public:
  ~WebRiskServiceConnectionImpl() override = default;

  WebRiskServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<webrisk_internal::WebRiskServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
  ComputeThreatListDiff(
      google::cloud::webrisk::v1::ComputeThreatListDiffRequest const& request)
      override;

  StatusOr<google::cloud::webrisk::v1::SearchUrisResponse> SearchUris(
      google::cloud::webrisk::v1::SearchUrisRequest const& request) override;

  StatusOr<google::cloud::webrisk::v1::SearchHashesResponse> SearchHashes(
      google::cloud::webrisk::v1::SearchHashesRequest const& request) override;

  StatusOr<google::cloud::webrisk::v1::Submission> CreateSubmission(
      google::cloud::webrisk::v1::CreateSubmissionRequest const& request)
      override;

 private:
  std::unique_ptr<webrisk::WebRiskServiceRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<webrisk::WebRiskServiceRetryPolicyOption>()) {
      return options.get<webrisk::WebRiskServiceRetryPolicyOption>()->clone();
    }
    return options_.get<webrisk::WebRiskServiceRetryPolicyOption>()->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<webrisk::WebRiskServiceBackoffPolicyOption>()) {
      return options.get<webrisk::WebRiskServiceBackoffPolicyOption>()->clone();
    }
    return options_.get<webrisk::WebRiskServiceBackoffPolicyOption>()->clone();
  }

  std::unique_ptr<webrisk::WebRiskServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<webrisk::WebRiskServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<webrisk::WebRiskServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<webrisk::WebRiskServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<webrisk_internal::WebRiskServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBRISK_INTERNAL_WEB_RISK_CONNECTION_IMPL_H
