// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#include "google/cloud/webrisk/internal/web_risk_connection_impl.h"
#include "google/cloud/webrisk/internal/web_risk_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace webrisk_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WebRiskServiceConnectionImpl::WebRiskServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<webrisk_internal::WebRiskServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), webrisk_internal::WebRiskServiceDefaultOptions(
                                  WebRiskServiceConnection::options()))) {}

StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
WebRiskServiceConnectionImpl::ComputeThreatListDiff(
    google::cloud::webrisk::v1::ComputeThreatListDiffRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ComputeThreatListDiff(request),
      [this](grpc::ClientContext& context,
             google::cloud::webrisk::v1::ComputeThreatListDiffRequest const&
                 request) {
        return stub_->ComputeThreatListDiff(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::webrisk::v1::SearchUrisResponse>
WebRiskServiceConnectionImpl::SearchUris(
    google::cloud::webrisk::v1::SearchUrisRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SearchUris(request),
      [this](grpc::ClientContext& context,
             google::cloud::webrisk::v1::SearchUrisRequest const& request) {
        return stub_->SearchUris(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::webrisk::v1::SearchHashesResponse>
WebRiskServiceConnectionImpl::SearchHashes(
    google::cloud::webrisk::v1::SearchHashesRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SearchHashes(request),
      [this](grpc::ClientContext& context,
             google::cloud::webrisk::v1::SearchHashesRequest const& request) {
        return stub_->SearchHashes(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::webrisk::v1::Submission>
WebRiskServiceConnectionImpl::CreateSubmission(
    google::cloud::webrisk::v1::CreateSubmissionRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateSubmission(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::webrisk::v1::CreateSubmissionRequest const& request) {
        return stub_->CreateSubmission(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk_internal
}  // namespace cloud
}  // namespace google
