// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vpcaccess/v1/vpc_access.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VPCACCESS_VPC_ACCESS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VPCACCESS_VPC_ACCESS_CLIENT_H

#include "google/cloud/vpcaccess/vpc_access_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace vpcaccess {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Serverless VPC Access API allows users to create and manage connectors for
/// App Engine, Cloud Functions and Cloud Run to have internal connections to
/// Virtual Private Cloud networks.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class VpcAccessServiceClient {
 public:
  explicit VpcAccessServiceClient(
      std::shared_ptr<VpcAccessServiceConnection> connection,
      Options options = {});
  ~VpcAccessServiceClient();

  //@{
  // @name Copy and move support
  VpcAccessServiceClient(VpcAccessServiceClient const&) = default;
  VpcAccessServiceClient& operator=(VpcAccessServiceClient const&) = default;
  VpcAccessServiceClient(VpcAccessServiceClient&&) = default;
  VpcAccessServiceClient& operator=(VpcAccessServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(VpcAccessServiceClient const& a,
                         VpcAccessServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(VpcAccessServiceClient const& a,
                         VpcAccessServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates a Serverless VPC Access connector, returns an operation.
  ///
  /// @param parent  Required. The project and location in which the
  /// configuration should be created,
  ///  specified in the format `projects/*/locations/*`.
  /// @param connector_id  Required. The ID to use for this connector.
  /// @param connector  Required. Resource to create.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vpcaccess::v1::Connector,google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  /// [google.cloud.vpcaccess.v1.CreateConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L154}
  /// [google.cloud.vpcaccess.v1.Connector]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  future<StatusOr<google::cloud::vpcaccess::v1::Connector>> CreateConnector(
      std::string const& parent, std::string const& connector_id,
      google::cloud::vpcaccess::v1::Connector const& connector,
      Options options = {});

  ///
  /// Creates a Serverless VPC Access connector, returns an operation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vpcaccess::v1::CreateConnectorRequest,google/cloud/vpcaccess/v1/vpc_access.proto#L154}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vpcaccess::v1::Connector,google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  /// [google.cloud.vpcaccess.v1.CreateConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L154}
  /// [google.cloud.vpcaccess.v1.Connector]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  future<StatusOr<google::cloud::vpcaccess::v1::Connector>> CreateConnector(
      google::cloud::vpcaccess::v1::CreateConnectorRequest const& request,
      Options options = {});

  ///
  /// Gets a Serverless VPC Access connector. Returns NOT_FOUND if the resource
  /// does not exist.
  ///
  /// @param name  Required. Name of a Serverless VPC Access connector to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vpcaccess::v1::Connector,google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  /// [google.cloud.vpcaccess.v1.GetConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L172}
  /// [google.cloud.vpcaccess.v1.Connector]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  StatusOr<google::cloud::vpcaccess::v1::Connector> GetConnector(
      std::string const& name, Options options = {});

  ///
  /// Gets a Serverless VPC Access connector. Returns NOT_FOUND if the resource
  /// does not exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vpcaccess::v1::GetConnectorRequest,google/cloud/vpcaccess/v1/vpc_access.proto#L172}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vpcaccess::v1::Connector,google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  /// [google.cloud.vpcaccess.v1.GetConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L172}
  /// [google.cloud.vpcaccess.v1.Connector]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  StatusOr<google::cloud::vpcaccess::v1::Connector> GetConnector(
      google::cloud::vpcaccess::v1::GetConnectorRequest const& request,
      Options options = {});

  ///
  /// Lists Serverless VPC Access connectors.
  ///
  /// @param parent  Required. The project and location from which the routes
  /// should be listed.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vpcaccess::v1::Connector,google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  /// [google.cloud.vpcaccess.v1.ListConnectorsRequest]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L183}
  /// [google.cloud.vpcaccess.v1.Connector]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  StreamRange<google::cloud::vpcaccess::v1::Connector> ListConnectors(
      std::string const& parent, Options options = {});

  ///
  /// Lists Serverless VPC Access connectors.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vpcaccess::v1::ListConnectorsRequest,google/cloud/vpcaccess/v1/vpc_access.proto#L183}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vpcaccess::v1::Connector,google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  /// [google.cloud.vpcaccess.v1.ListConnectorsRequest]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L183}
  /// [google.cloud.vpcaccess.v1.Connector]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L86}
  ///
  StreamRange<google::cloud::vpcaccess::v1::Connector> ListConnectors(
      google::cloud::vpcaccess::v1::ListConnectorsRequest request,
      Options options = {});

  ///
  /// Deletes a Serverless VPC Access connector. Returns NOT_FOUND if the
  /// resource does not exist.
  ///
  /// @param name  Required. Name of a Serverless VPC Access connector to
  /// delete.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vpcaccess::v1::OperationMetadata,google/cloud/vpcaccess/v1/vpc_access.proto#L220}
  ///
  /// [google.cloud.vpcaccess.v1.DeleteConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L209}
  /// [google.cloud.vpcaccess.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L220}
  ///
  future<StatusOr<google::cloud::vpcaccess::v1::OperationMetadata>>
  DeleteConnector(std::string const& name, Options options = {});

  ///
  /// Deletes a Serverless VPC Access connector. Returns NOT_FOUND if the
  /// resource does not exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vpcaccess::v1::DeleteConnectorRequest,google/cloud/vpcaccess/v1/vpc_access.proto#L209}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vpcaccess::v1::OperationMetadata,google/cloud/vpcaccess/v1/vpc_access.proto#L220}
  ///
  /// [google.cloud.vpcaccess.v1.DeleteConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L209}
  /// [google.cloud.vpcaccess.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vpcaccess/v1/vpc_access.proto#L220}
  ///
  future<StatusOr<google::cloud::vpcaccess::v1::OperationMetadata>>
  DeleteConnector(
      google::cloud::vpcaccess::v1::DeleteConnectorRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<VpcAccessServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vpcaccess
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VPCACCESS_VPC_ACCESS_CLIENT_H
