// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vpcaccess/v1/vpc_access.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VPCACCESS_INTERNAL_VPC_ACCESS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VPCACCESS_INTERNAL_VPC_ACCESS_CONNECTION_IMPL_H

#include "google/cloud/vpcaccess/internal/vpc_access_retry_traits.h"
#include "google/cloud/vpcaccess/internal/vpc_access_stub.h"
#include "google/cloud/vpcaccess/vpc_access_connection.h"
#include "google/cloud/vpcaccess/vpc_access_connection_idempotency_policy.h"
#include "google/cloud/vpcaccess/vpc_access_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace vpcaccess_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class VpcAccessServiceConnectionImpl
    : public vpcaccess::VpcAccessServiceConnection {
 public:
  ~VpcAccessServiceConnectionImpl() override = default;

  VpcAccessServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<vpcaccess_internal::VpcAccessServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::vpcaccess::v1::Connector>> CreateConnector(
      google::cloud::vpcaccess::v1::CreateConnectorRequest const& request)
      override;

  StatusOr<google::cloud::vpcaccess::v1::Connector> GetConnector(
      google::cloud::vpcaccess::v1::GetConnectorRequest const& request)
      override;

  StreamRange<google::cloud::vpcaccess::v1::Connector> ListConnectors(
      google::cloud::vpcaccess::v1::ListConnectorsRequest request) override;

  future<StatusOr<google::cloud::vpcaccess::v1::OperationMetadata>>
  DeleteConnector(google::cloud::vpcaccess::v1::DeleteConnectorRequest const&
                      request) override;

 private:
  std::unique_ptr<vpcaccess::VpcAccessServiceRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<vpcaccess::VpcAccessServiceRetryPolicyOption>()) {
      return options.get<vpcaccess::VpcAccessServiceRetryPolicyOption>()
          ->clone();
    }
    return options_.get<vpcaccess::VpcAccessServiceRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<vpcaccess::VpcAccessServiceBackoffPolicyOption>()) {
      return options.get<vpcaccess::VpcAccessServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<vpcaccess::VpcAccessServiceBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<vpcaccess::VpcAccessServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            vpcaccess::VpcAccessServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<vpcaccess::VpcAccessServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<vpcaccess::VpcAccessServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<PollingPolicy> polling_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<vpcaccess::VpcAccessServicePollingPolicyOption>()) {
      return options.get<vpcaccess::VpcAccessServicePollingPolicyOption>()
          ->clone();
    }
    return options_.get<vpcaccess::VpcAccessServicePollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<vpcaccess_internal::VpcAccessServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vpcaccess_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VPCACCESS_INTERNAL_VPC_ACCESS_CONNECTION_IMPL_H
