// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vpcaccess/v1/vpc_access.proto

#include "google/cloud/vpcaccess/internal/vpc_access_connection_impl.h"
#include "google/cloud/vpcaccess/internal/vpc_access_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace vpcaccess_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VpcAccessServiceConnectionImpl::VpcAccessServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<vpcaccess_internal::VpcAccessServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          vpcaccess_internal::VpcAccessServiceDefaultOptions(
              VpcAccessServiceConnection::options()))) {}

future<StatusOr<google::cloud::vpcaccess::v1::Connector>>
VpcAccessServiceConnectionImpl::CreateConnector(
    google::cloud::vpcaccess::v1::CreateConnectorRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vpcaccess::v1::Connector>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::vpcaccess::v1::CreateConnectorRequest const& request) {
        return stub->AsyncCreateConnector(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vpcaccess::v1::Connector>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateConnector(request), polling_policy(),
      __func__);
}

StatusOr<google::cloud::vpcaccess::v1::Connector>
VpcAccessServiceConnectionImpl::GetConnector(
    google::cloud::vpcaccess::v1::GetConnectorRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetConnector(request),
      [this](grpc::ClientContext& context,
             google::cloud::vpcaccess::v1::GetConnectorRequest const& request) {
        return stub_->GetConnector(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::vpcaccess::v1::Connector>
VpcAccessServiceConnectionImpl::ListConnectors(
    google::cloud::vpcaccess::v1::ListConnectorsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<vpcaccess::VpcAccessServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListConnectors(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vpcaccess::v1::Connector>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::vpcaccess::v1::ListConnectorsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vpcaccess::v1::ListConnectorsRequest const&
                       request) {
              return stub->ListConnectors(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vpcaccess::v1::ListConnectorsResponse r) {
        std::vector<google::cloud::vpcaccess::v1::Connector> result(
            r.connectors().size());
        auto& messages = *r.mutable_connectors();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::vpcaccess::v1::OperationMetadata>>
VpcAccessServiceConnectionImpl::DeleteConnector(
    google::cloud::vpcaccess::v1::DeleteConnectorRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vpcaccess::v1::OperationMetadata>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::vpcaccess::v1::DeleteConnectorRequest const& request) {
        return stub->AsyncDeleteConnector(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::vpcaccess::v1::OperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteConnector(request), polling_policy(),
      __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vpcaccess_internal
}  // namespace cloud
}  // namespace google
