// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmmigration/v1/vmmigration.proto

#include "google/cloud/vmmigration/vm_migration_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace vmmigration {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

VmMigrationConnectionIdempotencyPolicy::
    ~VmMigrationConnectionIdempotencyPolicy() = default;

namespace {
class DefaultVmMigrationConnectionIdempotencyPolicy
    : public VmMigrationConnectionIdempotencyPolicy {
 public:
  ~DefaultVmMigrationConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<VmMigrationConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultVmMigrationConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListSources(
      google::cloud::vmmigration::v1::ListSourcesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetSource(
      google::cloud::vmmigration::v1::GetSourceRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateSource(
      google::cloud::vmmigration::v1::CreateSourceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateSource(
      google::cloud::vmmigration::v1::UpdateSourceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteSource(
      google::cloud::vmmigration::v1::DeleteSourceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency FetchInventory(
      google::cloud::vmmigration::v1::FetchInventoryRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListUtilizationReports(
      google::cloud::vmmigration::v1::ListUtilizationReportsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetUtilizationReport(
      google::cloud::vmmigration::v1::GetUtilizationReportRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateUtilizationReport(
      google::cloud::vmmigration::v1::CreateUtilizationReportRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteUtilizationReport(
      google::cloud::vmmigration::v1::DeleteUtilizationReportRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListDatacenterConnectors(
      google::cloud::vmmigration::v1::ListDatacenterConnectorsRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetDatacenterConnector(
      google::cloud::vmmigration::v1::GetDatacenterConnectorRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateDatacenterConnector(
      google::cloud::vmmigration::v1::CreateDatacenterConnectorRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteDatacenterConnector(
      google::cloud::vmmigration::v1::DeleteDatacenterConnectorRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateMigratingVm(
      google::cloud::vmmigration::v1::CreateMigratingVmRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListMigratingVms(
      google::cloud::vmmigration::v1::ListMigratingVmsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetMigratingVm(
      google::cloud::vmmigration::v1::GetMigratingVmRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateMigratingVm(
      google::cloud::vmmigration::v1::UpdateMigratingVmRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteMigratingVm(
      google::cloud::vmmigration::v1::DeleteMigratingVmRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency StartMigration(
      google::cloud::vmmigration::v1::StartMigrationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ResumeMigration(
      google::cloud::vmmigration::v1::ResumeMigrationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency PauseMigration(
      google::cloud::vmmigration::v1::PauseMigrationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency FinalizeMigration(
      google::cloud::vmmigration::v1::FinalizeMigrationRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateCloneJob(
      google::cloud::vmmigration::v1::CreateCloneJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CancelCloneJob(
      google::cloud::vmmigration::v1::CancelCloneJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListCloneJobs(
      google::cloud::vmmigration::v1::ListCloneJobsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetCloneJob(
      google::cloud::vmmigration::v1::GetCloneJobRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateCutoverJob(
      google::cloud::vmmigration::v1::CreateCutoverJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CancelCutoverJob(
      google::cloud::vmmigration::v1::CancelCutoverJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListCutoverJobs(
      google::cloud::vmmigration::v1::ListCutoverJobsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetCutoverJob(
      google::cloud::vmmigration::v1::GetCutoverJobRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListGroups(
      google::cloud::vmmigration::v1::ListGroupsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetGroup(
      google::cloud::vmmigration::v1::GetGroupRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateGroup(
      google::cloud::vmmigration::v1::CreateGroupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateGroup(
      google::cloud::vmmigration::v1::UpdateGroupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteGroup(
      google::cloud::vmmigration::v1::DeleteGroupRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency AddGroupMigration(
      google::cloud::vmmigration::v1::AddGroupMigrationRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RemoveGroupMigration(
      google::cloud::vmmigration::v1::RemoveGroupMigrationRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListTargetProjects(
      google::cloud::vmmigration::v1::ListTargetProjectsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetTargetProject(
      google::cloud::vmmigration::v1::GetTargetProjectRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateTargetProject(
      google::cloud::vmmigration::v1::CreateTargetProjectRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateTargetProject(
      google::cloud::vmmigration::v1::UpdateTargetProjectRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteTargetProject(
      google::cloud::vmmigration::v1::DeleteTargetProjectRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<VmMigrationConnectionIdempotencyPolicy>
MakeDefaultVmMigrationConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultVmMigrationConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmmigration
}  // namespace cloud
}  // namespace google
