// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmmigration/v1/vmmigration.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMMIGRATION_VM_MIGRATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMMIGRATION_VM_MIGRATION_CLIENT_H

#include "google/cloud/vmmigration/vm_migration_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace vmmigration {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// VM Migration Service
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class VmMigrationClient {
 public:
  explicit VmMigrationClient(std::shared_ptr<VmMigrationConnection> connection,
                             Options options = {});
  ~VmMigrationClient();

  //@{
  // @name Copy and move support
  VmMigrationClient(VmMigrationClient const&) = default;
  VmMigrationClient& operator=(VmMigrationClient const&) = default;
  VmMigrationClient(VmMigrationClient&&) = default;
  VmMigrationClient& operator=(VmMigrationClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(VmMigrationClient const& a,
                         VmMigrationClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(VmMigrationClient const& a,
                         VmMigrationClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists Sources in a given project and location.
  ///
  /// @param parent  Required. The parent, which owns this collection of
  /// sources.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Source,google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  /// [google.cloud.vmmigration.v1.ListSourcesRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1074}
  /// [google.cloud.vmmigration.v1.Source]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  StreamRange<google::cloud::vmmigration::v1::Source> ListSources(
      std::string const& parent, Options options = {});

  ///
  /// Lists Sources in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ListSourcesRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1074}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Source,google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  /// [google.cloud.vmmigration.v1.ListSourcesRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1074}
  /// [google.cloud.vmmigration.v1.Source]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  StreamRange<google::cloud::vmmigration::v1::Source> ListSources(
      google::cloud::vmmigration::v1::ListSourcesRequest request,
      Options options = {});

  ///
  /// Gets details of a single Source.
  ///
  /// @param name  Required. The Source name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Source,google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  /// [google.cloud.vmmigration.v1.GetSourceRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1117}
  /// [google.cloud.vmmigration.v1.Source]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  StatusOr<google::cloud::vmmigration::v1::Source> GetSource(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single Source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::GetSourceRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1117}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Source,google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  /// [google.cloud.vmmigration.v1.GetSourceRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1117}
  /// [google.cloud.vmmigration.v1.Source]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  StatusOr<google::cloud::vmmigration::v1::Source> GetSource(
      google::cloud::vmmigration::v1::GetSourceRequest const& request,
      Options options = {});

  ///
  /// Creates a new Source in a given project and location.
  ///
  /// @param parent  Required. The Source's parent.
  /// @param source  Required. The create request body.
  /// @param source_id  Required. The source identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Source,google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  /// [google.cloud.vmmigration.v1.CreateSourceRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1128}
  /// [google.cloud.vmmigration.v1.Source]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::Source>> CreateSource(
      std::string const& parent,
      google::cloud::vmmigration::v1::Source const& source,
      std::string const& source_id, Options options = {});

  ///
  /// Creates a new Source in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CreateSourceRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1128}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Source,google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  /// [google.cloud.vmmigration.v1.CreateSourceRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1128}
  /// [google.cloud.vmmigration.v1.Source]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::Source>> CreateSource(
      google::cloud::vmmigration::v1::CreateSourceRequest const& request,
      Options options = {});

  ///
  /// Updates the parameters of a single Source.
  ///
  /// @param source  Required. The update request body.
  /// @param update_mask  Field mask is used to specify the fields to be
  /// overwritten in the
  ///  Source resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If
  ///  the user does not provide a mask then all fields will be overwritten.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Source,google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  /// [google.cloud.vmmigration.v1.UpdateSourceRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1160}
  /// [google.cloud.vmmigration.v1.Source]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::Source>> UpdateSource(
      google::cloud::vmmigration::v1::Source const& source,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the parameters of a single Source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::UpdateSourceRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1160}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Source,google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  /// [google.cloud.vmmigration.v1.UpdateSourceRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1160}
  /// [google.cloud.vmmigration.v1.Source]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L962}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::Source>> UpdateSource(
      google::cloud::vmmigration::v1::UpdateSourceRequest const& request,
      Options options = {});

  ///
  /// Deletes a single Source.
  ///
  /// @param name  Required. The Source name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteSourceRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1188}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteSource(std::string const& name, Options options = {});

  ///
  /// Deletes a single Source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::DeleteSourceRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1188}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteSourceRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1188}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteSource(
      google::cloud::vmmigration::v1::DeleteSourceRequest const& request,
      Options options = {});

  ///
  /// List remote source's inventory of VMs.
  /// The remote source is the onprem vCenter (remote in the sense it's not in
  /// Compute Engine). The inventory describes the list of existing VMs in that
  /// source. Note that this operation lists the VMs on the remote source, as
  /// opposed to listing the MigratingVms resources in the vmmigration service.
  ///
  /// @param source  Required. The name of the Source.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::FetchInventoryResponse,google/cloud/vmmigration/v1/vmmigration.proto#L1306}
  ///
  /// [google.cloud.vmmigration.v1.FetchInventoryRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1215}
  /// [google.cloud.vmmigration.v1.FetchInventoryResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1306}
  ///
  StatusOr<google::cloud::vmmigration::v1::FetchInventoryResponse>
  FetchInventory(std::string const& source, Options options = {});

  ///
  /// List remote source's inventory of VMs.
  /// The remote source is the onprem vCenter (remote in the sense it's not in
  /// Compute Engine). The inventory describes the list of existing VMs in that
  /// source. Note that this operation lists the VMs on the remote source, as
  /// opposed to listing the MigratingVms resources in the vmmigration service.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::FetchInventoryRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1215}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::FetchInventoryResponse,google/cloud/vmmigration/v1/vmmigration.proto#L1306}
  ///
  /// [google.cloud.vmmigration.v1.FetchInventoryRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1215}
  /// [google.cloud.vmmigration.v1.FetchInventoryResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1306}
  ///
  StatusOr<google::cloud::vmmigration::v1::FetchInventoryResponse>
  FetchInventory(
      google::cloud::vmmigration::v1::FetchInventoryRequest const& request,
      Options options = {});

  ///
  /// Lists Utilization Reports of the given Source.
  ///
  /// @param parent  Required. The Utilization Reports parent.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::UtilizationReport,google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  /// [google.cloud.vmmigration.v1.ListUtilizationReportsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1437}
  /// [google.cloud.vmmigration.v1.UtilizationReport]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  StreamRange<google::cloud::vmmigration::v1::UtilizationReport>
  ListUtilizationReports(std::string const& parent, Options options = {});

  ///
  /// Lists Utilization Reports of the given Source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ListUtilizationReportsRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1437}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::UtilizationReport,google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  /// [google.cloud.vmmigration.v1.ListUtilizationReportsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1437}
  /// [google.cloud.vmmigration.v1.UtilizationReport]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  StreamRange<google::cloud::vmmigration::v1::UtilizationReport>
  ListUtilizationReports(
      google::cloud::vmmigration::v1::ListUtilizationReportsRequest request,
      Options options = {});

  ///
  /// Gets a single Utilization Report.
  ///
  /// @param name  Required. The Utilization Report name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::UtilizationReport,google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  /// [google.cloud.vmmigration.v1.GetUtilizationReportRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1484}
  /// [google.cloud.vmmigration.v1.UtilizationReport]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  StatusOr<google::cloud::vmmigration::v1::UtilizationReport>
  GetUtilizationReport(std::string const& name, Options options = {});

  ///
  /// Gets a single Utilization Report.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::GetUtilizationReportRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1484}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::UtilizationReport,google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  /// [google.cloud.vmmigration.v1.GetUtilizationReportRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1484}
  /// [google.cloud.vmmigration.v1.UtilizationReport]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  StatusOr<google::cloud::vmmigration::v1::UtilizationReport>
  GetUtilizationReport(
      google::cloud::vmmigration::v1::GetUtilizationReportRequest const&
          request,
      Options options = {});

  ///
  /// Creates a new UtilizationReport.
  ///
  /// @param parent  Required. The Utilization Report's parent.
  /// @param utilization_report  Required. The report to create.
  /// @param utilization_report_id  Required. The ID to use for the report,
  /// which will become the final component of
  ///  the reports's resource name.
  ///  This value maximum length is 63 characters, and valid characters
  ///  are /[a-z][0-9]-/. It must start with an english letter and must not
  ///  end with a hyphen.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::UtilizationReport,google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  /// [google.cloud.vmmigration.v1.CreateUtilizationReportRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1499}
  /// [google.cloud.vmmigration.v1.UtilizationReport]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::UtilizationReport>>
  CreateUtilizationReport(
      std::string const& parent,
      google::cloud::vmmigration::v1::UtilizationReport const&
          utilization_report,
      std::string const& utilization_report_id, Options options = {});

  ///
  /// Creates a new UtilizationReport.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CreateUtilizationReportRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1499}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::UtilizationReport,google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  /// [google.cloud.vmmigration.v1.CreateUtilizationReportRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1499}
  /// [google.cloud.vmmigration.v1.UtilizationReport]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1319}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::UtilizationReport>>
  CreateUtilizationReport(
      google::cloud::vmmigration::v1::CreateUtilizationReportRequest const&
          request,
      Options options = {});

  ///
  /// Deletes a single Utilization Report.
  ///
  /// @param name  Required. The Utilization Report name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteUtilizationReportRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1536}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteUtilizationReport(std::string const& name, Options options = {});

  ///
  /// Deletes a single Utilization Report.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::DeleteUtilizationReportRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1536}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteUtilizationReportRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1536}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteUtilizationReport(
      google::cloud::vmmigration::v1::DeleteUtilizationReportRequest const&
          request,
      Options options = {});

  ///
  /// Lists DatacenterConnectors in a given Source.
  ///
  /// @param parent  Required. The parent, which owns this collection of
  /// connectors.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::DatacenterConnector,google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  /// [google.cloud.vmmigration.v1.ListDatacenterConnectorsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1647}
  /// [google.cloud.vmmigration.v1.DatacenterConnector]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  StreamRange<google::cloud::vmmigration::v1::DatacenterConnector>
  ListDatacenterConnectors(std::string const& parent, Options options = {});

  ///
  /// Lists DatacenterConnectors in a given Source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ListDatacenterConnectorsRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1647}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::DatacenterConnector,google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  /// [google.cloud.vmmigration.v1.ListDatacenterConnectorsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1647}
  /// [google.cloud.vmmigration.v1.DatacenterConnector]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  StreamRange<google::cloud::vmmigration::v1::DatacenterConnector>
  ListDatacenterConnectors(
      google::cloud::vmmigration::v1::ListDatacenterConnectorsRequest request,
      Options options = {});

  ///
  /// Gets details of a single DatacenterConnector.
  ///
  /// @param name  Required. The name of the DatacenterConnector.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::DatacenterConnector,google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  /// [google.cloud.vmmigration.v1.GetDatacenterConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1575}
  /// [google.cloud.vmmigration.v1.DatacenterConnector]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  StatusOr<google::cloud::vmmigration::v1::DatacenterConnector>
  GetDatacenterConnector(std::string const& name, Options options = {});

  ///
  /// Gets details of a single DatacenterConnector.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::GetDatacenterConnectorRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1575}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::DatacenterConnector,google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  /// [google.cloud.vmmigration.v1.GetDatacenterConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1575}
  /// [google.cloud.vmmigration.v1.DatacenterConnector]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  StatusOr<google::cloud::vmmigration::v1::DatacenterConnector>
  GetDatacenterConnector(
      google::cloud::vmmigration::v1::GetDatacenterConnectorRequest const&
          request,
      Options options = {});

  ///
  /// Creates a new DatacenterConnector in a given Source.
  ///
  /// @param parent  Required. The DatacenterConnector's parent.
  ///  Required. The Source in where the new DatacenterConnector will be
  ///  created. For example:
  ///  `projects/my-project/locations/us-central1/sources/my-source`
  /// @param datacenter_connector  Required. The create request body.
  /// @param datacenter_connector_id  Required. The datacenterConnector
  /// identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::DatacenterConnector,google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  /// [google.cloud.vmmigration.v1.CreateDatacenterConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1586}
  /// [google.cloud.vmmigration.v1.DatacenterConnector]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::DatacenterConnector>>
  CreateDatacenterConnector(
      std::string const& parent,
      google::cloud::vmmigration::v1::DatacenterConnector const&
          datacenter_connector,
      std::string const& datacenter_connector_id, Options options = {});

  ///
  /// Creates a new DatacenterConnector in a given Source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CreateDatacenterConnectorRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1586}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::DatacenterConnector,google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  /// [google.cloud.vmmigration.v1.CreateDatacenterConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1586}
  /// [google.cloud.vmmigration.v1.DatacenterConnector]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1009}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::DatacenterConnector>>
  CreateDatacenterConnector(
      google::cloud::vmmigration::v1::CreateDatacenterConnectorRequest const&
          request,
      Options options = {});

  ///
  /// Deletes a single DatacenterConnector.
  ///
  /// @param name  Required. The DatacenterConnector name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteDatacenterConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1621}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteDatacenterConnector(std::string const& name, Options options = {});

  ///
  /// Deletes a single DatacenterConnector.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::DeleteDatacenterConnectorRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1621}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteDatacenterConnectorRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1621}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteDatacenterConnector(
      google::cloud::vmmigration::v1::DeleteDatacenterConnectorRequest const&
          request,
      Options options = {});

  ///
  /// Creates a new MigratingVm in a given Source.
  ///
  /// @param parent  Required. The MigratingVm's parent.
  /// @param migrating_vm  Required. The create request body.
  /// @param migrating_vm_id  Required. The migratingVm identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::MigratingVm,google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  /// [google.cloud.vmmigration.v1.CreateMigratingVmRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1918}
  /// [google.cloud.vmmigration.v1.MigratingVm]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::MigratingVm>>
  CreateMigratingVm(
      std::string const& parent,
      google::cloud::vmmigration::v1::MigratingVm const& migrating_vm,
      std::string const& migrating_vm_id, Options options = {});

  ///
  /// Creates a new MigratingVm in a given Source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CreateMigratingVmRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1918}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::MigratingVm,google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  /// [google.cloud.vmmigration.v1.CreateMigratingVmRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1918}
  /// [google.cloud.vmmigration.v1.MigratingVm]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::MigratingVm>>
  CreateMigratingVm(
      google::cloud::vmmigration::v1::CreateMigratingVmRequest const& request,
      Options options = {});

  ///
  /// Lists MigratingVms in a given Source.
  ///
  /// @param parent  Required. The parent, which owns this collection of
  /// MigratingVms.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::MigratingVm,google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  /// [google.cloud.vmmigration.v1.ListMigratingVmsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1950}
  /// [google.cloud.vmmigration.v1.MigratingVm]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  StreamRange<google::cloud::vmmigration::v1::MigratingVm> ListMigratingVms(
      std::string const& parent, Options options = {});

  ///
  /// Lists MigratingVms in a given Source.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ListMigratingVmsRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1950}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::MigratingVm,google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  /// [google.cloud.vmmigration.v1.ListMigratingVmsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1950}
  /// [google.cloud.vmmigration.v1.MigratingVm]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  StreamRange<google::cloud::vmmigration::v1::MigratingVm> ListMigratingVms(
      google::cloud::vmmigration::v1::ListMigratingVmsRequest request,
      Options options = {});

  ///
  /// Gets details of a single MigratingVm.
  ///
  /// @param name  Required. The name of the MigratingVm.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::MigratingVm,google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  /// [google.cloud.vmmigration.v1.GetMigratingVmRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1993}
  /// [google.cloud.vmmigration.v1.MigratingVm]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  StatusOr<google::cloud::vmmigration::v1::MigratingVm> GetMigratingVm(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single MigratingVm.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::GetMigratingVmRequest,google/cloud/vmmigration/v1/vmmigration.proto#L1993}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::MigratingVm,google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  /// [google.cloud.vmmigration.v1.GetMigratingVmRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L1993}
  /// [google.cloud.vmmigration.v1.MigratingVm]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  StatusOr<google::cloud::vmmigration::v1::MigratingVm> GetMigratingVm(
      google::cloud::vmmigration::v1::GetMigratingVmRequest const& request,
      Options options = {});

  ///
  /// Updates the parameters of a single MigratingVm.
  ///
  /// @param migrating_vm  Required. The update request body.
  /// @param update_mask  Field mask is used to specify the fields to be
  /// overwritten in the
  ///  MigratingVm resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If
  ///  the user does not provide a mask then all fields will be overwritten.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::MigratingVm,google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  /// [google.cloud.vmmigration.v1.UpdateMigratingVmRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2004}
  /// [google.cloud.vmmigration.v1.MigratingVm]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::MigratingVm>>
  UpdateMigratingVm(
      google::cloud::vmmigration::v1::MigratingVm const& migrating_vm,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the parameters of a single MigratingVm.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::UpdateMigratingVmRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2004}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::MigratingVm,google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  /// [google.cloud.vmmigration.v1.UpdateMigratingVmRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2004}
  /// [google.cloud.vmmigration.v1.MigratingVm]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L612}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::MigratingVm>>
  UpdateMigratingVm(
      google::cloud::vmmigration::v1::UpdateMigratingVmRequest const& request,
      Options options = {});

  ///
  /// Deletes a single MigratingVm.
  ///
  /// @param name  Required. The name of the MigratingVm.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteMigratingVmRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2032}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteMigratingVm(std::string const& name, Options options = {});

  ///
  /// Deletes a single MigratingVm.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::DeleteMigratingVmRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2032}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteMigratingVmRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2032}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteMigratingVm(
      google::cloud::vmmigration::v1::DeleteMigratingVmRequest const& request,
      Options options = {});

  ///
  /// Starts migration for a VM. Starts the process of uploading
  /// data and creating snapshots, in replication cycles scheduled by the
  /// policy.
  ///
  /// @param migrating_vm  Required. The name of the MigratingVm.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::StartMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2054}
  ///
  /// [google.cloud.vmmigration.v1.StartMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2043}
  /// [google.cloud.vmmigration.v1.StartMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2054}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::StartMigrationResponse>>
  StartMigration(std::string const& migrating_vm, Options options = {});

  ///
  /// Starts migration for a VM. Starts the process of uploading
  /// data and creating snapshots, in replication cycles scheduled by the
  /// policy.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::StartMigrationRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2043}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::StartMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2054}
  ///
  /// [google.cloud.vmmigration.v1.StartMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2043}
  /// [google.cloud.vmmigration.v1.StartMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2054}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::StartMigrationResponse>>
  StartMigration(
      google::cloud::vmmigration::v1::StartMigrationRequest const& request,
      Options options = {});

  ///
  /// Resumes a migration for a VM. When called on a paused migration, will
  /// start the process of uploading data and creating snapshots; when called on
  /// a completed cut-over migration, will update the migration to active state
  /// and start the process of uploading data and creating snapshots.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ResumeMigrationRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2075}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::ResumeMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2086}
  ///
  /// [google.cloud.vmmigration.v1.ResumeMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2075}
  /// [google.cloud.vmmigration.v1.ResumeMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2086}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::ResumeMigrationResponse>>
  ResumeMigration(
      google::cloud::vmmigration::v1::ResumeMigrationRequest const& request,
      Options options = {});

  ///
  /// Pauses a migration for a VM. If cycle tasks are running they will be
  /// cancelled, preserving source task data. Further replication cycles will
  /// not be triggered while the VM is paused.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::PauseMigrationRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2059}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::PauseMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2070}
  ///
  /// [google.cloud.vmmigration.v1.PauseMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2059}
  /// [google.cloud.vmmigration.v1.PauseMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2070}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::PauseMigrationResponse>>
  PauseMigration(
      google::cloud::vmmigration::v1::PauseMigrationRequest const& request,
      Options options = {});

  ///
  /// Marks a migration as completed, deleting migration resources that are no
  /// longer being used. Only applicable after cutover is done.
  ///
  /// @param migrating_vm  Required. The name of the MigratingVm.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::FinalizeMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2102}
  ///
  /// [google.cloud.vmmigration.v1.FinalizeMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2091}
  /// [google.cloud.vmmigration.v1.FinalizeMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2102}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::FinalizeMigrationResponse>>
  FinalizeMigration(std::string const& migrating_vm, Options options = {});

  ///
  /// Marks a migration as completed, deleting migration resources that are no
  /// longer being used. Only applicable after cutover is done.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::FinalizeMigrationRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2091}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::FinalizeMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2102}
  ///
  /// [google.cloud.vmmigration.v1.FinalizeMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2091}
  /// [google.cloud.vmmigration.v1.FinalizeMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2102}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::FinalizeMigrationResponse>>
  FinalizeMigration(
      google::cloud::vmmigration::v1::FinalizeMigrationRequest const& request,
      Options options = {});

  ///
  /// Initiates a Clone of a specific migrating VM.
  ///
  /// @param parent  Required. The Clone's parent.
  /// @param clone_job  Required. The clone request body.
  /// @param clone_job_id  Required. The clone job identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CloneJob,google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  /// [google.cloud.vmmigration.v1.CreateCloneJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L859}
  /// [google.cloud.vmmigration.v1.CloneJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::CloneJob>> CreateCloneJob(
      std::string const& parent,
      google::cloud::vmmigration::v1::CloneJob const& clone_job,
      std::string const& clone_job_id, Options options = {});

  ///
  /// Initiates a Clone of a specific migrating VM.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CreateCloneJobRequest,google/cloud/vmmigration/v1/vmmigration.proto#L859}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CloneJob,google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  /// [google.cloud.vmmigration.v1.CreateCloneJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L859}
  /// [google.cloud.vmmigration.v1.CloneJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::CloneJob>> CreateCloneJob(
      google::cloud::vmmigration::v1::CreateCloneJobRequest const& request,
      Options options = {});

  ///
  /// Initiates the cancellation of a running clone job.
  ///
  /// @param name  Required. The clone job id
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CancelCloneJobResponse,google/cloud/vmmigration/v1/vmmigration.proto#L902}
  ///
  /// [google.cloud.vmmigration.v1.CancelCloneJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L891}
  /// [google.cloud.vmmigration.v1.CancelCloneJobResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L902}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::CancelCloneJobResponse>>
  CancelCloneJob(std::string const& name, Options options = {});

  ///
  /// Initiates the cancellation of a running clone job.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CancelCloneJobRequest,google/cloud/vmmigration/v1/vmmigration.proto#L891}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CancelCloneJobResponse,google/cloud/vmmigration/v1/vmmigration.proto#L902}
  ///
  /// [google.cloud.vmmigration.v1.CancelCloneJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L891}
  /// [google.cloud.vmmigration.v1.CancelCloneJobResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L902}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::CancelCloneJobResponse>>
  CancelCloneJob(
      google::cloud::vmmigration::v1::CancelCloneJobRequest const& request,
      Options options = {});

  ///
  /// Lists CloneJobs of a given migrating VM.
  ///
  /// @param parent  Required. The parent, which owns this collection of source
  /// VMs.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CloneJob,google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  /// [google.cloud.vmmigration.v1.ListCloneJobsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L907}
  /// [google.cloud.vmmigration.v1.CloneJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  StreamRange<google::cloud::vmmigration::v1::CloneJob> ListCloneJobs(
      std::string const& parent, Options options = {});

  ///
  /// Lists CloneJobs of a given migrating VM.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ListCloneJobsRequest,google/cloud/vmmigration/v1/vmmigration.proto#L907}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CloneJob,google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  /// [google.cloud.vmmigration.v1.ListCloneJobsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L907}
  /// [google.cloud.vmmigration.v1.CloneJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  StreamRange<google::cloud::vmmigration::v1::CloneJob> ListCloneJobs(
      google::cloud::vmmigration::v1::ListCloneJobsRequest request,
      Options options = {});

  ///
  /// Gets details of a single CloneJob.
  ///
  /// @param name  Required. The name of the CloneJob.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CloneJob,google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  /// [google.cloud.vmmigration.v1.GetCloneJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L950}
  /// [google.cloud.vmmigration.v1.CloneJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  StatusOr<google::cloud::vmmigration::v1::CloneJob> GetCloneJob(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single CloneJob.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::GetCloneJobRequest,google/cloud/vmmigration/v1/vmmigration.proto#L950}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CloneJob,google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  /// [google.cloud.vmmigration.v1.GetCloneJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L950}
  /// [google.cloud.vmmigration.v1.CloneJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L735}
  ///
  StatusOr<google::cloud::vmmigration::v1::CloneJob> GetCloneJob(
      google::cloud::vmmigration::v1::GetCloneJobRequest const& request,
      Options options = {});

  ///
  /// Initiates a Cutover of a specific migrating VM.
  /// The returned LRO is completed when the cutover job resource is created
  /// and the job is initiated.
  ///
  /// @param parent  Required. The Cutover's parent.
  /// @param cutover_job  Required. The cutover request body.
  /// @param cutover_job_id  Required. The cutover job identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CutoverJob,google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  /// [google.cloud.vmmigration.v1.CreateCutoverJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2478}
  /// [google.cloud.vmmigration.v1.CutoverJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::CutoverJob>> CreateCutoverJob(
      std::string const& parent,
      google::cloud::vmmigration::v1::CutoverJob const& cutover_job,
      std::string const& cutover_job_id, Options options = {});

  ///
  /// Initiates a Cutover of a specific migrating VM.
  /// The returned LRO is completed when the cutover job resource is created
  /// and the job is initiated.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CreateCutoverJobRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2478}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CutoverJob,google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  /// [google.cloud.vmmigration.v1.CreateCutoverJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2478}
  /// [google.cloud.vmmigration.v1.CutoverJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::CutoverJob>> CreateCutoverJob(
      google::cloud::vmmigration::v1::CreateCutoverJobRequest const& request,
      Options options = {});

  ///
  /// Initiates the cancellation of a running cutover job.
  ///
  /// @param name  Required. The cutover job id
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CancelCutoverJobResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2521}
  ///
  /// [google.cloud.vmmigration.v1.CancelCutoverJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2510}
  /// [google.cloud.vmmigration.v1.CancelCutoverJobResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2521}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::CancelCutoverJobResponse>>
  CancelCutoverJob(std::string const& name, Options options = {});

  ///
  /// Initiates the cancellation of a running cutover job.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CancelCutoverJobRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2510}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CancelCutoverJobResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2521}
  ///
  /// [google.cloud.vmmigration.v1.CancelCutoverJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2510}
  /// [google.cloud.vmmigration.v1.CancelCutoverJobResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2521}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::CancelCutoverJobResponse>>
  CancelCutoverJob(
      google::cloud::vmmigration::v1::CancelCutoverJobRequest const& request,
      Options options = {});

  ///
  /// Lists CutoverJobs of a given migrating VM.
  ///
  /// @param parent  Required. The parent, which owns this collection of
  /// migrating VMs.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CutoverJob,google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  /// [google.cloud.vmmigration.v1.ListCutoverJobsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2526}
  /// [google.cloud.vmmigration.v1.CutoverJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  StreamRange<google::cloud::vmmigration::v1::CutoverJob> ListCutoverJobs(
      std::string const& parent, Options options = {});

  ///
  /// Lists CutoverJobs of a given migrating VM.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ListCutoverJobsRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2526}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CutoverJob,google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  /// [google.cloud.vmmigration.v1.ListCutoverJobsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2526}
  /// [google.cloud.vmmigration.v1.CutoverJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  StreamRange<google::cloud::vmmigration::v1::CutoverJob> ListCutoverJobs(
      google::cloud::vmmigration::v1::ListCutoverJobsRequest request,
      Options options = {});

  ///
  /// Gets details of a single CutoverJob.
  ///
  /// @param name  Required. The name of the CutoverJob.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CutoverJob,google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  /// [google.cloud.vmmigration.v1.GetCutoverJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2569}
  /// [google.cloud.vmmigration.v1.CutoverJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  StatusOr<google::cloud::vmmigration::v1::CutoverJob> GetCutoverJob(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single CutoverJob.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::GetCutoverJobRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2569}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::CutoverJob,google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  /// [google.cloud.vmmigration.v1.GetCutoverJobRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2569}
  /// [google.cloud.vmmigration.v1.CutoverJob]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L795}
  ///
  StatusOr<google::cloud::vmmigration::v1::CutoverJob> GetCutoverJob(
      google::cloud::vmmigration::v1::GetCutoverJobRequest const& request,
      Options options = {});

  ///
  /// Lists Groups in a given project and location.
  ///
  /// @param parent  Required. The parent, which owns this collection of groups.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Group,google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  /// [google.cloud.vmmigration.v1.ListGroupsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2296}
  /// [google.cloud.vmmigration.v1.Group]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  StreamRange<google::cloud::vmmigration::v1::Group> ListGroups(
      std::string const& parent, Options options = {});

  ///
  /// Lists Groups in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ListGroupsRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2296}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Group,google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  /// [google.cloud.vmmigration.v1.ListGroupsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2296}
  /// [google.cloud.vmmigration.v1.Group]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  StreamRange<google::cloud::vmmigration::v1::Group> ListGroups(
      google::cloud::vmmigration::v1::ListGroupsRequest request,
      Options options = {});

  ///
  /// Gets details of a single Group.
  ///
  /// @param name  Required. The group name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Group,google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  /// [google.cloud.vmmigration.v1.GetGroupRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2339}
  /// [google.cloud.vmmigration.v1.Group]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  StatusOr<google::cloud::vmmigration::v1::Group> GetGroup(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single Group.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::GetGroupRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2339}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Group,google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  /// [google.cloud.vmmigration.v1.GetGroupRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2339}
  /// [google.cloud.vmmigration.v1.Group]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  StatusOr<google::cloud::vmmigration::v1::Group> GetGroup(
      google::cloud::vmmigration::v1::GetGroupRequest const& request,
      Options options = {});

  ///
  /// Creates a new Group in a given project and location.
  ///
  /// @param parent  Required. The Group's parent.
  /// @param group  Required. The create request body.
  /// @param group_id  Required. The group identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Group,google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  /// [google.cloud.vmmigration.v1.CreateGroupRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2350}
  /// [google.cloud.vmmigration.v1.Group]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::Group>> CreateGroup(
      std::string const& parent,
      google::cloud::vmmigration::v1::Group const& group,
      std::string const& group_id, Options options = {});

  ///
  /// Creates a new Group in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CreateGroupRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2350}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Group,google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  /// [google.cloud.vmmigration.v1.CreateGroupRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2350}
  /// [google.cloud.vmmigration.v1.Group]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::Group>> CreateGroup(
      google::cloud::vmmigration::v1::CreateGroupRequest const& request,
      Options options = {});

  ///
  /// Updates the parameters of a single Group.
  ///
  /// @param group  Required. The update request body.
  /// @param update_mask  Field mask is used to specify the fields to be
  /// overwritten in the
  ///  Group resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If
  ///  the user does not provide a mask then all fields will be overwritten.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Group,google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  /// [google.cloud.vmmigration.v1.UpdateGroupRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2382}
  /// [google.cloud.vmmigration.v1.Group]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::Group>> UpdateGroup(
      google::cloud::vmmigration::v1::Group const& group,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the parameters of a single Group.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::UpdateGroupRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2382}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::Group,google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  /// [google.cloud.vmmigration.v1.UpdateGroupRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2382}
  /// [google.cloud.vmmigration.v1.Group]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2273}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::Group>> UpdateGroup(
      google::cloud::vmmigration::v1::UpdateGroupRequest const& request,
      Options options = {});

  ///
  /// Deletes a single Group.
  ///
  /// @param name  Required. The Group name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteGroupRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2410}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteGroup(std::string const& name, Options options = {});

  ///
  /// Deletes a single Group.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::DeleteGroupRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2410}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteGroupRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2410}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteGroup(google::cloud::vmmigration::v1::DeleteGroupRequest const& request,
              Options options = {});

  ///
  /// Adds a MigratingVm to a Group.
  ///
  /// @param group  Required. The full path name of the Group to add to.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::AddGroupMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2452}
  ///
  /// [google.cloud.vmmigration.v1.AddGroupMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2436}
  /// [google.cloud.vmmigration.v1.AddGroupMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2452}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::AddGroupMigrationResponse>>
  AddGroupMigration(std::string const& group, Options options = {});

  ///
  /// Adds a MigratingVm to a Group.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::AddGroupMigrationRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2436}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::AddGroupMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2452}
  ///
  /// [google.cloud.vmmigration.v1.AddGroupMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2436}
  /// [google.cloud.vmmigration.v1.AddGroupMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2452}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::AddGroupMigrationResponse>>
  AddGroupMigration(
      google::cloud::vmmigration::v1::AddGroupMigrationRequest const& request,
      Options options = {});

  ///
  /// Removes a MigratingVm from a Group.
  ///
  /// @param group  Required. The name of the Group.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::RemoveGroupMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2473}
  ///
  /// [google.cloud.vmmigration.v1.RemoveGroupMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2457}
  /// [google.cloud.vmmigration.v1.RemoveGroupMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2473}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::RemoveGroupMigrationResponse>>
  RemoveGroupMigration(std::string const& group, Options options = {});

  ///
  /// Removes a MigratingVm from a Group.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::RemoveGroupMigrationRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2457}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::RemoveGroupMigrationResponse,google/cloud/vmmigration/v1/vmmigration.proto#L2473}
  ///
  /// [google.cloud.vmmigration.v1.RemoveGroupMigrationRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2457}
  /// [google.cloud.vmmigration.v1.RemoveGroupMigrationResponse]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2473}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::RemoveGroupMigrationResponse>>
  RemoveGroupMigration(
      google::cloud::vmmigration::v1::RemoveGroupMigrationRequest const&
          request,
      Options options = {});

  ///
  /// Lists TargetProjects in a given project.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param parent  Required. The parent, which owns this collection of
  /// targets.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::TargetProject,google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  /// [google.cloud.vmmigration.v1.ListTargetProjectsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2143}
  /// [google.cloud.vmmigration.v1.TargetProject]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  StreamRange<google::cloud::vmmigration::v1::TargetProject> ListTargetProjects(
      std::string const& parent, Options options = {});

  ///
  /// Lists TargetProjects in a given project.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::ListTargetProjectsRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2143}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::TargetProject,google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  /// [google.cloud.vmmigration.v1.ListTargetProjectsRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2143}
  /// [google.cloud.vmmigration.v1.TargetProject]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  StreamRange<google::cloud::vmmigration::v1::TargetProject> ListTargetProjects(
      google::cloud::vmmigration::v1::ListTargetProjectsRequest request,
      Options options = {});

  ///
  /// Gets details of a single TargetProject.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param name  Required. The TargetProject name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::TargetProject,google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  /// [google.cloud.vmmigration.v1.GetTargetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2132}
  /// [google.cloud.vmmigration.v1.TargetProject]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  StatusOr<google::cloud::vmmigration::v1::TargetProject> GetTargetProject(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single TargetProject.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::GetTargetProjectRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2132}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::TargetProject,google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  /// [google.cloud.vmmigration.v1.GetTargetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2132}
  /// [google.cloud.vmmigration.v1.TargetProject]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  StatusOr<google::cloud::vmmigration::v1::TargetProject> GetTargetProject(
      google::cloud::vmmigration::v1::GetTargetProjectRequest const& request,
      Options options = {});

  ///
  /// Creates a new TargetProject in a given project.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param parent  Required. The TargetProject's parent.
  /// @param target_project  Required. The create request body.
  /// @param target_project_id  Required. The target_project identifier.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::TargetProject,google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  /// [google.cloud.vmmigration.v1.CreateTargetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2186}
  /// [google.cloud.vmmigration.v1.TargetProject]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::TargetProject>>
  CreateTargetProject(
      std::string const& parent,
      google::cloud::vmmigration::v1::TargetProject const& target_project,
      std::string const& target_project_id, Options options = {});

  ///
  /// Creates a new TargetProject in a given project.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::CreateTargetProjectRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2186}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::TargetProject,google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  /// [google.cloud.vmmigration.v1.CreateTargetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2186}
  /// [google.cloud.vmmigration.v1.TargetProject]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::TargetProject>>
  CreateTargetProject(
      google::cloud::vmmigration::v1::CreateTargetProjectRequest const& request,
      Options options = {});

  ///
  /// Updates the parameters of a single TargetProject.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param target_project  Required. The update request body.
  /// @param update_mask  Field mask is used to specify the fields to be
  /// overwritten in the
  ///  TargetProject resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If
  ///  the user does not provide a mask then all fields will be overwritten.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::TargetProject,google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  /// [google.cloud.vmmigration.v1.UpdateTargetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2218}
  /// [google.cloud.vmmigration.v1.TargetProject]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::TargetProject>>
  UpdateTargetProject(
      google::cloud::vmmigration::v1::TargetProject const& target_project,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the parameters of a single TargetProject.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::UpdateTargetProjectRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2218}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::TargetProject,google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  /// [google.cloud.vmmigration.v1.UpdateTargetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2218}
  /// [google.cloud.vmmigration.v1.TargetProject]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2108}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::TargetProject>>
  UpdateTargetProject(
      google::cloud::vmmigration::v1::UpdateTargetProjectRequest const& request,
      Options options = {});

  ///
  /// Deletes a single TargetProject.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param name  Required. The TargetProject name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteTargetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2246}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteTargetProject(std::string const& name, Options options = {});

  ///
  /// Deletes a single TargetProject.
  ///
  /// NOTE: TargetProject is a global resource; hence the only supported value
  /// for location is `global`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vmmigration::v1::DeleteTargetProjectRequest,google/cloud/vmmigration/v1/vmmigration.proto#L2246}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vmmigration::v1::OperationMetadata,google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  /// [google.cloud.vmmigration.v1.DeleteTargetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2246}
  /// [google.cloud.vmmigration.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vmmigration/v1/vmmigration.proto#L2580}
  ///
  future<StatusOr<google::cloud::vmmigration::v1::OperationMetadata>>
  DeleteTargetProject(
      google::cloud::vmmigration::v1::DeleteTargetProjectRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<VmMigrationConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmmigration
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMMIGRATION_VM_MIGRATION_CLIENT_H
