// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/product_search_service.proto

#include "google/cloud/vision/product_search_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace vision {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ProductSearchConnectionIdempotencyPolicy::
    ~ProductSearchConnectionIdempotencyPolicy() = default;

namespace {
class DefaultProductSearchConnectionIdempotencyPolicy
    : public ProductSearchConnectionIdempotencyPolicy {
 public:
  ~DefaultProductSearchConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ProductSearchConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultProductSearchConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency CreateProductSet(
      google::cloud::vision::v1::CreateProductSetRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListProductSets(
      google::cloud::vision::v1::ListProductSetsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetProductSet(
      google::cloud::vision::v1::GetProductSetRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateProductSet(
      google::cloud::vision::v1::UpdateProductSetRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteProductSet(
      google::cloud::vision::v1::DeleteProductSetRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateProduct(
      google::cloud::vision::v1::CreateProductRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListProducts(
      google::cloud::vision::v1::ListProductsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetProduct(
      google::cloud::vision::v1::GetProductRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateProduct(
      google::cloud::vision::v1::UpdateProductRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteProduct(
      google::cloud::vision::v1::DeleteProductRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateReferenceImage(
      google::cloud::vision::v1::CreateReferenceImageRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteReferenceImage(
      google::cloud::vision::v1::DeleteReferenceImageRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListReferenceImages(
      google::cloud::vision::v1::ListReferenceImagesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetReferenceImage(
      google::cloud::vision::v1::GetReferenceImageRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency AddProductToProductSet(
      google::cloud::vision::v1::AddProductToProductSetRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RemoveProductFromProductSet(
      google::cloud::vision::v1::RemoveProductFromProductSetRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListProductsInProductSet(
      google::cloud::vision::v1::ListProductsInProductSetRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ImportProductSets(
      google::cloud::vision::v1::ImportProductSetsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency PurgeProducts(
      google::cloud::vision::v1::PurgeProductsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ProductSearchConnectionIdempotencyPolicy>
MakeDefaultProductSearchConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultProductSearchConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision
}  // namespace cloud
}  // namespace google
