// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/product_search_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_PRODUCT_SEARCH_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_PRODUCT_SEARCH_CLIENT_H

#include "google/cloud/vision/product_search_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace vision {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages Products and ProductSets of reference images for use in product
/// search. It uses the following resource model:
///
/// - The API has a collection of
/// [ProductSet][google.cloud.vision.v1.ProductSet] resources, named
/// `projects/*/locations/*/productSets/*`, which acts as a way to put different
/// products into groups to limit identification.
///
/// In parallel,
///
/// - The API has a collection of [Product][google.cloud.vision.v1.Product]
/// resources, named
///   `projects/*/locations/*/products/*`
///
/// - Each [Product][google.cloud.vision.v1.Product] has a collection of
/// [ReferenceImage][google.cloud.vision.v1.ReferenceImage] resources, named
///   `projects/*/locations/*/products/*/referenceImages/*`
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ProductSearchClient {
 public:
  explicit ProductSearchClient(
      std::shared_ptr<ProductSearchConnection> connection,
      Options options = {});
  ~ProductSearchClient();

  //@{
  // @name Copy and move support
  ProductSearchClient(ProductSearchClient const&) = default;
  ProductSearchClient& operator=(ProductSearchClient const&) = default;
  ProductSearchClient(ProductSearchClient&&) = default;
  ProductSearchClient& operator=(ProductSearchClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ProductSearchClient const& a,
                         ProductSearchClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ProductSearchClient const& a,
                         ProductSearchClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates and returns a new ProductSet resource.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
  ///   4096 characters.
  ///
  /// @param parent  Required. The project in which the ProductSet should be
  /// created.
  ///  Format is `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param product_set  Required. The ProductSet to create.
  /// @param product_set_id  A user-supplied resource id for this ProductSet. If
  /// set, the server will
  ///  attempt to use this value as the resource id. If it is already in use, an
  ///  error is returned with code ALREADY_EXISTS. Must be at most 128
  ///  characters long. It cannot contain the character `/`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ProductSet,google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  /// [google.cloud.vision.v1.CreateProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L584}
  /// [google.cloud.vision.v1.ProductSet]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  StatusOr<google::cloud::vision::v1::ProductSet> CreateProductSet(
      std::string const& parent,
      google::cloud::vision::v1::ProductSet const& product_set,
      std::string const& product_set_id, Options options = {});

  ///
  /// Creates and returns a new ProductSet resource.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
  ///   4096 characters.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::CreateProductSetRequest,google/cloud/vision/v1/product_search_service.proto#L584}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ProductSet,google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  /// [google.cloud.vision.v1.CreateProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L584}
  /// [google.cloud.vision.v1.ProductSet]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  StatusOr<google::cloud::vision::v1::ProductSet> CreateProductSet(
      google::cloud::vision::v1::CreateProductSetRequest const& request,
      Options options = {});

  ///
  /// Lists ProductSets in an unspecified order.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
  ///   than 1.
  ///
  /// @param parent  Required. The project from which ProductSets should be
  /// listed.
  ///  Format is `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ProductSet,google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  /// [google.cloud.vision.v1.ListProductSetsRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L606}
  /// [google.cloud.vision.v1.ProductSet]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  StreamRange<google::cloud::vision::v1::ProductSet> ListProductSets(
      std::string const& parent, Options options = {});

  ///
  /// Lists ProductSets in an unspecified order.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
  ///   than 1.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::ListProductSetsRequest,google/cloud/vision/v1/product_search_service.proto#L606}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ProductSet,google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  /// [google.cloud.vision.v1.ListProductSetsRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L606}
  /// [google.cloud.vision.v1.ProductSet]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  StreamRange<google::cloud::vision::v1::ProductSet> ListProductSets(
      google::cloud::vision::v1::ListProductSetsRequest request,
      Options options = {});

  ///
  /// Gets information associated with a ProductSet.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the ProductSet does not exist.
  ///
  /// @param name  Required. Resource name of the ProductSet to get.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ProductSet,google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  /// [google.cloud.vision.v1.GetProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L635}
  /// [google.cloud.vision.v1.ProductSet]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  StatusOr<google::cloud::vision::v1::ProductSet> GetProductSet(
      std::string const& name, Options options = {});

  ///
  /// Gets information associated with a ProductSet.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the ProductSet does not exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::GetProductSetRequest,google/cloud/vision/v1/product_search_service.proto#L635}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ProductSet,google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  /// [google.cloud.vision.v1.GetProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L635}
  /// [google.cloud.vision.v1.ProductSet]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  StatusOr<google::cloud::vision::v1::ProductSet> GetProductSet(
      google::cloud::vision::v1::GetProductSetRequest const& request,
      Options options = {});

  ///
  /// Makes changes to a ProductSet resource.
  /// Only display_name can be updated currently.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the ProductSet does not exist.
  /// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
  ///   missing from the request or longer than 4096 characters.
  ///
  /// @param product_set  Required. The ProductSet resource which replaces the
  /// one on the server.
  /// @param update_mask  The [FieldMask][google.protobuf.FieldMask] that
  /// specifies which fields to
  ///  update.
  ///  If update_mask isn't specified, all mutable fields are to be updated.
  ///  Valid mask path is `display_name`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ProductSet,google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  /// [google.cloud.vision.v1.UpdateProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L649}
  /// [google.cloud.vision.v1.ProductSet]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  StatusOr<google::cloud::vision::v1::ProductSet> UpdateProductSet(
      google::cloud::vision::v1::ProductSet const& product_set,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Makes changes to a ProductSet resource.
  /// Only display_name can be updated currently.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the ProductSet does not exist.
  /// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
  ///   missing from the request or longer than 4096 characters.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::UpdateProductSetRequest,google/cloud/vision/v1/product_search_service.proto#L649}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ProductSet,google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  /// [google.cloud.vision.v1.UpdateProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L649}
  /// [google.cloud.vision.v1.ProductSet]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L423}
  ///
  StatusOr<google::cloud::vision::v1::ProductSet> UpdateProductSet(
      google::cloud::vision::v1::UpdateProductSetRequest const& request,
      Options options = {});

  ///
  /// Permanently deletes a ProductSet. Products and ReferenceImages in the
  /// ProductSet are not deleted.
  ///
  /// The actual image files are not deleted from Google Cloud Storage.
  ///
  /// @param name  Required. Resource name of the ProductSet to delete.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.DeleteProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L661}
  ///
  Status DeleteProductSet(std::string const& name, Options options = {});

  ///
  /// Permanently deletes a ProductSet. Products and ReferenceImages in the
  /// ProductSet are not deleted.
  ///
  /// The actual image files are not deleted from Google Cloud Storage.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::DeleteProductSetRequest,google/cloud/vision/v1/product_search_service.proto#L661}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.DeleteProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L661}
  ///
  Status DeleteProductSet(
      google::cloud::vision::v1::DeleteProductSetRequest const& request,
      Options options = {});

  ///
  /// Creates and returns a new product resource.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
  ///   characters.
  /// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
  ///
  /// @param parent  Required. The project in which the Product should be
  /// created.
  ///  Format is
  ///  `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param product  Required. The product to create.
  /// @param product_id  A user-supplied resource id for this Product. If set,
  /// the server will
  ///  attempt to use this value as the resource id. If it is already in use, an
  ///  error is returned with code ALREADY_EXISTS. Must be at most 128
  ///  characters long. It cannot contain the character `/`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.CreateProductRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L489}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StatusOr<google::cloud::vision::v1::Product> CreateProduct(
      std::string const& parent,
      google::cloud::vision::v1::Product const& product,
      std::string const& product_id, Options options = {});

  ///
  /// Creates and returns a new product resource.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
  ///   characters.
  /// * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if product_category is missing or invalid.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::CreateProductRequest,google/cloud/vision/v1/product_search_service.proto#L489}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.CreateProductRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L489}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StatusOr<google::cloud::vision::v1::Product> CreateProduct(
      google::cloud::vision::v1::CreateProductRequest const& request,
      Options options = {});

  ///
  /// Lists products in an unspecified order.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less
  /// than 1.
  ///
  /// @param parent  Required. The project OR ProductSet from which Products
  /// should be listed.
  ///  Format:
  ///  `projects/PROJECT_ID/locations/LOC_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.ListProductsRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L512}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StreamRange<google::cloud::vision::v1::Product> ListProducts(
      std::string const& parent, Options options = {});

  ///
  /// Lists products in an unspecified order.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less
  /// than 1.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::ListProductsRequest,google/cloud/vision/v1/product_search_service.proto#L512}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.ListProductsRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L512}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StreamRange<google::cloud::vision::v1::Product> ListProducts(
      google::cloud::vision::v1::ListProductsRequest request,
      Options options = {});

  ///
  /// Gets information associated with a Product.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product does not exist.
  ///
  /// @param name  Required. Resource name of the Product to get.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.GetProductRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L542}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StatusOr<google::cloud::vision::v1::Product> GetProduct(
      std::string const& name, Options options = {});

  ///
  /// Gets information associated with a Product.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product does not exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::GetProductRequest,google/cloud/vision/v1/product_search_service.proto#L542}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.GetProductRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L542}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StatusOr<google::cloud::vision::v1::Product> GetProduct(
      google::cloud::vision::v1::GetProductRequest const& request,
      Options options = {});

  ///
  /// Makes changes to a Product resource.
  /// Only the `display_name`, `description`, and `labels` fields can be updated
  /// right now.
  ///
  /// If labels are updated, the change will not be reflected in queries until
  /// the next index time.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product does not exist.
  /// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
  /// is
  ///   missing from the request or longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if description is present in update_mask but is
  ///   longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
  ///
  /// @param product  Required. The Product resource which replaces the one on
  /// the server.
  ///  product.name is immutable.
  /// @param update_mask  The [FieldMask][google.protobuf.FieldMask] that
  /// specifies which fields
  ///  to update.
  ///  If update_mask isn't specified, all mutable fields are to be updated.
  ///  Valid mask paths include `product_labels`, `display_name`, and
  ///  `description`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.UpdateProductRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L556}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StatusOr<google::cloud::vision::v1::Product> UpdateProduct(
      google::cloud::vision::v1::Product const& product,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Makes changes to a Product resource.
  /// Only the `display_name`, `description`, and `labels` fields can be updated
  /// right now.
  ///
  /// If labels are updated, the change will not be reflected in queries until
  /// the next index time.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product does not exist.
  /// * Returns INVALID_ARGUMENT if display_name is present in update_mask but
  /// is
  ///   missing from the request or longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if description is present in update_mask but is
  ///   longer than 4096 characters.
  /// * Returns INVALID_ARGUMENT if product_category is present in update_mask.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::UpdateProductRequest,google/cloud/vision/v1/product_search_service.proto#L556}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.UpdateProductRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L556}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StatusOr<google::cloud::vision::v1::Product> UpdateProduct(
      google::cloud::vision::v1::UpdateProductRequest const& request,
      Options options = {});

  ///
  /// Permanently deletes a product and its reference images.
  ///
  /// Metadata of the product and all its images will be deleted right away, but
  /// search queries against ProductSets containing the product may still work
  /// until all related caches are refreshed.
  ///
  /// @param name  Required. Resource name of product to delete.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.DeleteProductRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L570}
  ///
  Status DeleteProduct(std::string const& name, Options options = {});

  ///
  /// Permanently deletes a product and its reference images.
  ///
  /// Metadata of the product and all its images will be deleted right away, but
  /// search queries against ProductSets containing the product may still work
  /// until all related caches are refreshed.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::DeleteProductRequest,google/cloud/vision/v1/product_search_service.proto#L570}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.DeleteProductRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L570}
  ///
  Status DeleteProduct(
      google::cloud::vision::v1::DeleteProductRequest const& request,
      Options options = {});

  ///
  /// Creates and returns a new ReferenceImage resource.
  ///
  /// The `bounding_poly` field is optional. If `bounding_poly` is not
  /// specified, the system will try to detect regions of interest in the image
  /// that are compatible with the product_category on the parent product. If it
  /// is specified, detection is ALWAYS skipped. The system converts polygons
  /// into non-rotated rectangles.
  ///
  /// Note that the pipeline will resize the image if the image resolution is
  /// too large to process (above 50MP).
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
  ///   characters.
  /// * Returns INVALID_ARGUMENT if the product does not exist.
  /// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
  ///   compatible with the parent product's product_category is detected.
  /// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10
  /// polygons.
  ///
  /// @param parent  Required. Resource name of the product in which to create
  /// the reference image.
  ///  Format is
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
  /// @param reference_image  Required. The reference image to create.
  ///  If an image ID is specified, it is ignored.
  /// @param reference_image_id  A user-supplied resource id for the
  /// ReferenceImage to be added. If set,
  ///  the server will attempt to use this value as the resource id. If it is
  ///  already in use, an error is returned with code ALREADY_EXISTS. Must be at
  ///  most 128 characters long. It cannot contain the character `/`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ReferenceImage,google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  /// [google.cloud.vision.v1.CreateReferenceImageRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L675}
  /// [google.cloud.vision.v1.ReferenceImage]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  StatusOr<google::cloud::vision::v1::ReferenceImage> CreateReferenceImage(
      std::string const& parent,
      google::cloud::vision::v1::ReferenceImage const& reference_image,
      std::string const& reference_image_id, Options options = {});

  ///
  /// Creates and returns a new ReferenceImage resource.
  ///
  /// The `bounding_poly` field is optional. If `bounding_poly` is not
  /// specified, the system will try to detect regions of interest in the image
  /// that are compatible with the product_category on the parent product. If it
  /// is specified, detection is ALWAYS skipped. The system converts polygons
  /// into non-rotated rectangles.
  ///
  /// Note that the pipeline will resize the image if the image resolution is
  /// too large to process (above 50MP).
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
  ///   characters.
  /// * Returns INVALID_ARGUMENT if the product does not exist.
  /// * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
  ///   compatible with the parent product's product_category is detected.
  /// * Returns INVALID_ARGUMENT if bounding_poly contains more than 10
  /// polygons.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::CreateReferenceImageRequest,google/cloud/vision/v1/product_search_service.proto#L675}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ReferenceImage,google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  /// [google.cloud.vision.v1.CreateReferenceImageRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L675}
  /// [google.cloud.vision.v1.ReferenceImage]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  StatusOr<google::cloud::vision::v1::ReferenceImage> CreateReferenceImage(
      google::cloud::vision::v1::CreateReferenceImageRequest const& request,
      Options options = {});

  ///
  /// Permanently deletes a reference image.
  ///
  /// The image metadata will be deleted right away, but search queries
  /// against ProductSets containing the image may still work until all related
  /// caches are refreshed.
  ///
  /// The actual image files are not deleted from Google Cloud Storage.
  ///
  /// @param name  Required. The resource name of the reference image to delete.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.DeleteReferenceImageRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L748}
  ///
  Status DeleteReferenceImage(std::string const& name, Options options = {});

  ///
  /// Permanently deletes a reference image.
  ///
  /// The image metadata will be deleted right away, but search queries
  /// against ProductSets containing the image may still work until all related
  /// caches are refreshed.
  ///
  /// The actual image files are not deleted from Google Cloud Storage.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::DeleteReferenceImageRequest,google/cloud/vision/v1/product_search_service.proto#L748}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.DeleteReferenceImageRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L748}
  ///
  Status DeleteReferenceImage(
      google::cloud::vision::v1::DeleteReferenceImageRequest const& request,
      Options options = {});

  ///
  /// Lists reference images.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the parent product does not exist.
  /// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
  ///   than 1.
  ///
  /// @param parent  Required. Resource name of the product containing the
  /// reference images.
  ///  Format is
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ReferenceImage,google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  /// [google.cloud.vision.v1.ListReferenceImagesRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L699}
  /// [google.cloud.vision.v1.ReferenceImage]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  StreamRange<google::cloud::vision::v1::ReferenceImage> ListReferenceImages(
      std::string const& parent, Options options = {});

  ///
  /// Lists reference images.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the parent product does not exist.
  /// * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
  ///   than 1.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::ListReferenceImagesRequest,google/cloud/vision/v1/product_search_service.proto#L699}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ReferenceImage,google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  /// [google.cloud.vision.v1.ListReferenceImagesRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L699}
  /// [google.cloud.vision.v1.ReferenceImage]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  StreamRange<google::cloud::vision::v1::ReferenceImage> ListReferenceImages(
      google::cloud::vision::v1::ListReferenceImagesRequest request,
      Options options = {});

  ///
  /// Gets information associated with a ReferenceImage.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the specified image does not exist.
  ///
  /// @param name  Required. The resource name of the ReferenceImage to get.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ReferenceImage,google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  /// [google.cloud.vision.v1.GetReferenceImageRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L734}
  /// [google.cloud.vision.v1.ReferenceImage]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  StatusOr<google::cloud::vision::v1::ReferenceImage> GetReferenceImage(
      std::string const& name, Options options = {});

  ///
  /// Gets information associated with a ReferenceImage.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the specified image does not exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::GetReferenceImageRequest,google/cloud/vision/v1/product_search_service.proto#L734}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ReferenceImage,google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  /// [google.cloud.vision.v1.GetReferenceImageRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L734}
  /// [google.cloud.vision.v1.ReferenceImage]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L458}
  ///
  StatusOr<google::cloud::vision::v1::ReferenceImage> GetReferenceImage(
      google::cloud::vision::v1::GetReferenceImageRequest const& request,
      Options options = {});

  ///
  /// Adds a Product to the specified ProductSet. If the Product is already
  /// present, no change is made.
  ///
  /// One Product can be added to at most 100 ProductSets.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
  ///
  /// @param name  Required. The resource name for the ProductSet to modify.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param product  Required. The resource name for the Product to be added to
  /// this ProductSet.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.AddProductToProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L762}
  ///
  Status AddProductToProductSet(std::string const& name,
                                std::string const& product,
                                Options options = {});

  ///
  /// Adds a Product to the specified ProductSet. If the Product is already
  /// present, no change is made.
  ///
  /// One Product can be added to at most 100 ProductSets.
  ///
  /// Possible errors:
  ///
  /// * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::AddProductToProductSetRequest,google/cloud/vision/v1/product_search_service.proto#L762}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.AddProductToProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L762}
  ///
  Status AddProductToProductSet(
      google::cloud::vision::v1::AddProductToProductSetRequest const& request,
      Options options = {});

  ///
  /// Removes a Product from the specified ProductSet.
  ///
  /// @param name  Required. The resource name for the ProductSet to modify.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param product  Required. The resource name for the Product to be removed
  /// from this ProductSet.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.RemoveProductFromProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L787}
  ///
  Status RemoveProductFromProductSet(std::string const& name,
                                     std::string const& product,
                                     Options options = {});

  ///
  /// Removes a Product from the specified ProductSet.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::RemoveProductFromProductSetRequest,google/cloud/vision/v1/product_search_service.proto#L787}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.vision.v1.RemoveProductFromProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L787}
  ///
  Status RemoveProductFromProductSet(
      google::cloud::vision::v1::RemoveProductFromProductSetRequest const&
          request,
      Options options = {});

  ///
  /// Lists the Products in a ProductSet, in an unspecified order. If the
  /// ProductSet does not exist, the products field of the response will be
  /// empty.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less
  /// than 1.
  ///
  /// @param name  Required. The ProductSet resource for which to retrieve
  /// Products.
  ///  Format is:
  ///  `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.ListProductsInProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L812}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StreamRange<google::cloud::vision::v1::Product> ListProductsInProductSet(
      std::string const& name, Options options = {});

  ///
  /// Lists the Products in a ProductSet, in an unspecified order. If the
  /// ProductSet does not exist, the products field of the response will be
  /// empty.
  ///
  /// Possible errors:
  ///
  /// * Returns INVALID_ARGUMENT if page_size is greater than 100 or less
  /// than 1.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::ListProductsInProductSetRequest,google/cloud/vision/v1/product_search_service.proto#L812}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::Product,google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  /// [google.cloud.vision.v1.ListProductsInProductSetRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L812}
  /// [google.cloud.vision.v1.Product]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L365}
  ///
  StreamRange<google::cloud::vision::v1::Product> ListProductsInProductSet(
      google::cloud::vision::v1::ListProductsInProductSetRequest request,
      Options options = {});

  ///
  /// Asynchronous API that imports a list of reference images to specified
  /// product sets based on a list of image information.
  ///
  /// The [google.longrunning.Operation][google.longrunning.Operation] API can
  /// be used to keep track of the progress and results of the request.
  /// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
  /// `Operation.response` contains `ImportProductSetsResponse`. (results)
  ///
  /// The input source of this method is a csv file on Google Cloud Storage.
  /// For the format of the csv file please see
  /// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
  ///
  /// @param parent  Required. The project in which the ProductSets should be
  /// imported.
  ///  Format is `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param input_config  Required. The input content for the list of requests.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ImportProductSetsResponse,google/cloud/vision/v1/product_search_service.proto#L939}
  ///
  /// [google.cloud.vision.v1.ImportProductSetsRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L919}
  /// [google.cloud.vision.v1.ImportProductSetsResponse]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L939}
  ///
  future<StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>
  ImportProductSets(
      std::string const& parent,
      google::cloud::vision::v1::ImportProductSetsInputConfig const&
          input_config,
      Options options = {});

  ///
  /// Asynchronous API that imports a list of reference images to specified
  /// product sets based on a list of image information.
  ///
  /// The [google.longrunning.Operation][google.longrunning.Operation] API can
  /// be used to keep track of the progress and results of the request.
  /// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
  /// `Operation.response` contains `ImportProductSetsResponse`. (results)
  ///
  /// The input source of this method is a csv file on Google Cloud Storage.
  /// For the format of the csv file please see
  /// [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::ImportProductSetsRequest,google/cloud/vision/v1/product_search_service.proto#L919}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::ImportProductSetsResponse,google/cloud/vision/v1/product_search_service.proto#L939}
  ///
  /// [google.cloud.vision.v1.ImportProductSetsRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L919}
  /// [google.cloud.vision.v1.ImportProductSetsResponse]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L939}
  ///
  future<StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>
  ImportProductSets(
      google::cloud::vision::v1::ImportProductSetsRequest const& request,
      Options options = {});

  ///
  /// Asynchronous API to delete all Products in a ProductSet or all Products
  /// that are in no ProductSet.
  ///
  /// If a Product is a member of the specified ProductSet in addition to other
  /// ProductSets, the Product will still be deleted.
  ///
  /// It is recommended to not delete the specified ProductSet until after this
  /// operation has completed. It is also recommended to not add any of the
  /// Products involved in the batch delete to a new ProductSet while this
  /// operation is running because those Products may still end up deleted.
  ///
  /// It's not possible to undo the PurgeProducts operation. Therefore, it is
  /// recommended to keep the csv files used in ImportProductSets (if that was
  /// how you originally built the Product Set) before starting PurgeProducts,
  /// in case you need to re-import the data after deletion.
  ///
  /// If the plan is to purge all of the Products from a ProductSet and then
  /// re-use the empty ProductSet to re-import new Products into the empty
  /// ProductSet, you must wait until the PurgeProducts operation has finished
  /// for that ProductSet.
  ///
  /// The [google.longrunning.Operation][google.longrunning.Operation] API can
  /// be used to keep track of the progress and results of the request.
  /// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
  ///
  /// @param parent  Required. The project and location in which the Products
  /// should be deleted.
  ///  Format is `projects/PROJECT_ID/locations/LOC_ID`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::BatchOperationMetadata,google/cloud/vision/v1/product_search_service.proto#L956}
  ///
  /// [google.cloud.vision.v1.PurgeProductsRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L998}
  /// [google.cloud.vision.v1.BatchOperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L956}
  ///
  future<StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>
  PurgeProducts(std::string const& parent, Options options = {});

  ///
  /// Asynchronous API to delete all Products in a ProductSet or all Products
  /// that are in no ProductSet.
  ///
  /// If a Product is a member of the specified ProductSet in addition to other
  /// ProductSets, the Product will still be deleted.
  ///
  /// It is recommended to not delete the specified ProductSet until after this
  /// operation has completed. It is also recommended to not add any of the
  /// Products involved in the batch delete to a new ProductSet while this
  /// operation is running because those Products may still end up deleted.
  ///
  /// It's not possible to undo the PurgeProducts operation. Therefore, it is
  /// recommended to keep the csv files used in ImportProductSets (if that was
  /// how you originally built the Product Set) before starting PurgeProducts,
  /// in case you need to re-import the data after deletion.
  ///
  /// If the plan is to purge all of the Products from a ProductSet and then
  /// re-use the empty ProductSet to re-import new Products into the empty
  /// ProductSet, you must wait until the PurgeProducts operation has finished
  /// for that ProductSet.
  ///
  /// The [google.longrunning.Operation][google.longrunning.Operation] API can
  /// be used to keep track of the progress and results of the request.
  /// `Operation.metadata` contains `BatchOperationMetadata`. (progress)
  ///
  /// @param request
  /// @googleapis_link{google::cloud::vision::v1::PurgeProductsRequest,google/cloud/vision/v1/product_search_service.proto#L998}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::vision::v1::BatchOperationMetadata,google/cloud/vision/v1/product_search_service.proto#L956}
  ///
  /// [google.cloud.vision.v1.PurgeProductsRequest]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L998}
  /// [google.cloud.vision.v1.BatchOperationMetadata]:
  /// @googleapis_reference_link{google/cloud/vision/v1/product_search_service.proto#L956}
  ///
  future<StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>
  PurgeProducts(google::cloud::vision::v1::PurgeProductsRequest const& request,
                Options options = {});

 private:
  std::shared_ptr<ProductSearchConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_PRODUCT_SEARCH_CLIENT_H
