// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/product_search_service.proto

#include "google/cloud/vision/internal/product_search_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/vision/v1/product_search_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace vision_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ProductSearchMetadata::ProductSearchMetadata(
    std::shared_ptr<ProductSearchStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchMetadata::CreateProductSet(
    grpc::ClientContext& context,
    google::cloud::vision::v1::CreateProductSetRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateProductSet(context, request);
}

StatusOr<google::cloud::vision::v1::ListProductSetsResponse>
ProductSearchMetadata::ListProductSets(
    grpc::ClientContext& context,
    google::cloud::vision::v1::ListProductSetsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListProductSets(context, request);
}

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchMetadata::GetProductSet(
    grpc::ClientContext& context,
    google::cloud::vision::v1::GetProductSetRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetProductSet(context, request);
}

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchMetadata::UpdateProductSet(
    grpc::ClientContext& context,
    google::cloud::vision::v1::UpdateProductSetRequest const& request) {
  SetMetadata(context, "product_set.name=" + request.product_set().name());
  return child_->UpdateProductSet(context, request);
}

Status ProductSearchMetadata::DeleteProductSet(
    grpc::ClientContext& context,
    google::cloud::vision::v1::DeleteProductSetRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteProductSet(context, request);
}

StatusOr<google::cloud::vision::v1::Product>
ProductSearchMetadata::CreateProduct(
    grpc::ClientContext& context,
    google::cloud::vision::v1::CreateProductRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateProduct(context, request);
}

StatusOr<google::cloud::vision::v1::ListProductsResponse>
ProductSearchMetadata::ListProducts(
    grpc::ClientContext& context,
    google::cloud::vision::v1::ListProductsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListProducts(context, request);
}

StatusOr<google::cloud::vision::v1::Product> ProductSearchMetadata::GetProduct(
    grpc::ClientContext& context,
    google::cloud::vision::v1::GetProductRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetProduct(context, request);
}

StatusOr<google::cloud::vision::v1::Product>
ProductSearchMetadata::UpdateProduct(
    grpc::ClientContext& context,
    google::cloud::vision::v1::UpdateProductRequest const& request) {
  SetMetadata(context, "product.name=" + request.product().name());
  return child_->UpdateProduct(context, request);
}

Status ProductSearchMetadata::DeleteProduct(
    grpc::ClientContext& context,
    google::cloud::vision::v1::DeleteProductRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteProduct(context, request);
}

StatusOr<google::cloud::vision::v1::ReferenceImage>
ProductSearchMetadata::CreateReferenceImage(
    grpc::ClientContext& context,
    google::cloud::vision::v1::CreateReferenceImageRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateReferenceImage(context, request);
}

Status ProductSearchMetadata::DeleteReferenceImage(
    grpc::ClientContext& context,
    google::cloud::vision::v1::DeleteReferenceImageRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteReferenceImage(context, request);
}

StatusOr<google::cloud::vision::v1::ListReferenceImagesResponse>
ProductSearchMetadata::ListReferenceImages(
    grpc::ClientContext& context,
    google::cloud::vision::v1::ListReferenceImagesRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListReferenceImages(context, request);
}

StatusOr<google::cloud::vision::v1::ReferenceImage>
ProductSearchMetadata::GetReferenceImage(
    grpc::ClientContext& context,
    google::cloud::vision::v1::GetReferenceImageRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetReferenceImage(context, request);
}

Status ProductSearchMetadata::AddProductToProductSet(
    grpc::ClientContext& context,
    google::cloud::vision::v1::AddProductToProductSetRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->AddProductToProductSet(context, request);
}

Status ProductSearchMetadata::RemoveProductFromProductSet(
    grpc::ClientContext& context,
    google::cloud::vision::v1::RemoveProductFromProductSetRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->RemoveProductFromProductSet(context, request);
}

StatusOr<google::cloud::vision::v1::ListProductsInProductSetResponse>
ProductSearchMetadata::ListProductsInProductSet(
    grpc::ClientContext& context,
    google::cloud::vision::v1::ListProductsInProductSetRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->ListProductsInProductSet(context, request);
}

future<StatusOr<google::longrunning::Operation>>
ProductSearchMetadata::AsyncImportProductSets(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::vision::v1::ImportProductSetsRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncImportProductSets(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
ProductSearchMetadata::AsyncPurgeProducts(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::vision::v1::PurgeProductsRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncPurgeProducts(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
ProductSearchMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> ProductSearchMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void ProductSearchMetadata::SetMetadata(grpc::ClientContext& context,
                                        std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void ProductSearchMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision_internal
}  // namespace cloud
}  // namespace google
