// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/product_search_service.proto

#include "google/cloud/vision/internal/product_search_connection_impl.h"
#include "google/cloud/vision/internal/product_search_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace vision_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ProductSearchConnectionImpl::ProductSearchConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<vision_internal::ProductSearchStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), vision_internal::ProductSearchDefaultOptions(
                                  ProductSearchConnection::options()))) {}

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchConnectionImpl::CreateProductSet(
    google::cloud::vision::v1::CreateProductSetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateProductSet(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vision::v1::CreateProductSetRequest const& request) {
        return stub_->CreateProductSet(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::vision::v1::ProductSet>
ProductSearchConnectionImpl::ListProductSets(
    google::cloud::vision::v1::ListProductSetsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<vision::ProductSearchRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListProductSets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vision::v1::ProductSet>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::vision::v1::ListProductSetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vision::v1::ListProductSetsRequest const&
                       request) {
              return stub->ListProductSets(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vision::v1::ListProductSetsResponse r) {
        std::vector<google::cloud::vision::v1::ProductSet> result(
            r.product_sets().size());
        auto& messages = *r.mutable_product_sets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchConnectionImpl::GetProductSet(
    google::cloud::vision::v1::GetProductSetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetProductSet(request),
      [this](grpc::ClientContext& context,
             google::cloud::vision::v1::GetProductSetRequest const& request) {
        return stub_->GetProductSet(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchConnectionImpl::UpdateProductSet(
    google::cloud::vision::v1::UpdateProductSetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateProductSet(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vision::v1::UpdateProductSetRequest const& request) {
        return stub_->UpdateProductSet(context, request);
      },
      request, __func__);
}

Status ProductSearchConnectionImpl::DeleteProductSet(
    google::cloud::vision::v1::DeleteProductSetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteProductSet(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vision::v1::DeleteProductSetRequest const& request) {
        return stub_->DeleteProductSet(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::vision::v1::Product>
ProductSearchConnectionImpl::CreateProduct(
    google::cloud::vision::v1::CreateProductRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateProduct(request),
      [this](grpc::ClientContext& context,
             google::cloud::vision::v1::CreateProductRequest const& request) {
        return stub_->CreateProduct(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::vision::v1::Product>
ProductSearchConnectionImpl::ListProducts(
    google::cloud::vision::v1::ListProductsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<vision::ProductSearchRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListProducts(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vision::v1::Product>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::cloud::vision::v1::ListProductsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::vision::v1::ListProductsRequest const& request) {
              return stub->ListProducts(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vision::v1::ListProductsResponse r) {
        std::vector<google::cloud::vision::v1::Product> result(
            r.products().size());
        auto& messages = *r.mutable_products();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::vision::v1::Product>
ProductSearchConnectionImpl::GetProduct(
    google::cloud::vision::v1::GetProductRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetProduct(request),
      [this](grpc::ClientContext& context,
             google::cloud::vision::v1::GetProductRequest const& request) {
        return stub_->GetProduct(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::vision::v1::Product>
ProductSearchConnectionImpl::UpdateProduct(
    google::cloud::vision::v1::UpdateProductRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateProduct(request),
      [this](grpc::ClientContext& context,
             google::cloud::vision::v1::UpdateProductRequest const& request) {
        return stub_->UpdateProduct(context, request);
      },
      request, __func__);
}

Status ProductSearchConnectionImpl::DeleteProduct(
    google::cloud::vision::v1::DeleteProductRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteProduct(request),
      [this](grpc::ClientContext& context,
             google::cloud::vision::v1::DeleteProductRequest const& request) {
        return stub_->DeleteProduct(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::vision::v1::ReferenceImage>
ProductSearchConnectionImpl::CreateReferenceImage(
    google::cloud::vision::v1::CreateReferenceImageRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateReferenceImage(request),
      [this](grpc::ClientContext& context,
             google::cloud::vision::v1::CreateReferenceImageRequest const&
                 request) {
        return stub_->CreateReferenceImage(context, request);
      },
      request, __func__);
}

Status ProductSearchConnectionImpl::DeleteReferenceImage(
    google::cloud::vision::v1::DeleteReferenceImageRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteReferenceImage(request),
      [this](grpc::ClientContext& context,
             google::cloud::vision::v1::DeleteReferenceImageRequest const&
                 request) {
        return stub_->DeleteReferenceImage(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::vision::v1::ReferenceImage>
ProductSearchConnectionImpl::ListReferenceImages(
    google::cloud::vision::v1::ListReferenceImagesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<vision::ProductSearchRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListReferenceImages(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vision::v1::ReferenceImage>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::vision::v1::ListReferenceImagesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vision::v1::ListReferenceImagesRequest const&
                       request) {
              return stub->ListReferenceImages(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vision::v1::ListReferenceImagesResponse r) {
        std::vector<google::cloud::vision::v1::ReferenceImage> result(
            r.reference_images().size());
        auto& messages = *r.mutable_reference_images();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::vision::v1::ReferenceImage>
ProductSearchConnectionImpl::GetReferenceImage(
    google::cloud::vision::v1::GetReferenceImageRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetReferenceImage(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vision::v1::GetReferenceImageRequest const& request) {
        return stub_->GetReferenceImage(context, request);
      },
      request, __func__);
}

Status ProductSearchConnectionImpl::AddProductToProductSet(
    google::cloud::vision::v1::AddProductToProductSetRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->AddProductToProductSet(request),
      [this](grpc::ClientContext& context,
             google::cloud::vision::v1::AddProductToProductSetRequest const&
                 request) {
        return stub_->AddProductToProductSet(context, request);
      },
      request, __func__);
}

Status ProductSearchConnectionImpl::RemoveProductFromProductSet(
    google::cloud::vision::v1::RemoveProductFromProductSetRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->RemoveProductFromProductSet(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::vision::v1::RemoveProductFromProductSetRequest const&
              request) {
        return stub_->RemoveProductFromProductSet(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::vision::v1::Product>
ProductSearchConnectionImpl::ListProductsInProductSet(
    google::cloud::vision::v1::ListProductsInProductSetRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<vision::ProductSearchRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListProductsInProductSet(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::vision::v1::Product>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::vision::v1::ListProductsInProductSetRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::vision::v1::
                       ListProductsInProductSetRequest const& request) {
              return stub->ListProductsInProductSet(context, request);
            },
            r, function_name);
      },
      [](google::cloud::vision::v1::ListProductsInProductSetResponse r) {
        std::vector<google::cloud::vision::v1::Product> result(
            r.products().size());
        auto& messages = *r.mutable_products();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>
ProductSearchConnectionImpl::ImportProductSets(
    google::cloud::vision::v1::ImportProductSetsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vision::v1::ImportProductSetsResponse>(
      background_->cq(), request,
      [stub](
          google::cloud::CompletionQueue& cq,
          std::unique_ptr<grpc::ClientContext> context,
          google::cloud::vision::v1::ImportProductSetsRequest const& request) {
        return stub->AsyncImportProductSets(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::vision::v1::ImportProductSetsResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ImportProductSets(request), polling_policy(),
      __func__);
}

future<StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>
ProductSearchConnectionImpl::PurgeProducts(
    google::cloud::vision::v1::PurgeProductsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::vision::v1::BatchOperationMetadata>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::vision::v1::PurgeProductsRequest const& request) {
        return stub->AsyncPurgeProducts(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::vision::v1::BatchOperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->PurgeProducts(request), polling_policy(), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision_internal
}  // namespace cloud
}  // namespace google
