// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/image_annotator.proto

#include "google/cloud/vision/internal/image_annotator_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/vision/v1/image_annotator.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace vision_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ImageAnnotatorMetadata::ImageAnnotatorMetadata(
    std::shared_ptr<ImageAnnotatorStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::vision::v1::BatchAnnotateImagesResponse>
ImageAnnotatorMetadata::BatchAnnotateImages(
    grpc::ClientContext& context,
    google::cloud::vision::v1::BatchAnnotateImagesRequest const& request) {
  SetMetadata(context, {});
  return child_->BatchAnnotateImages(context, request);
}

StatusOr<google::cloud::vision::v1::BatchAnnotateFilesResponse>
ImageAnnotatorMetadata::BatchAnnotateFiles(
    grpc::ClientContext& context,
    google::cloud::vision::v1::BatchAnnotateFilesRequest const& request) {
  SetMetadata(context, {});
  return child_->BatchAnnotateFiles(context, request);
}

future<StatusOr<google::longrunning::Operation>>
ImageAnnotatorMetadata::AsyncAsyncBatchAnnotateImages(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::vision::v1::AsyncBatchAnnotateImagesRequest const& request) {
  SetMetadata(*context, {});
  return child_->AsyncAsyncBatchAnnotateImages(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
ImageAnnotatorMetadata::AsyncAsyncBatchAnnotateFiles(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::vision::v1::AsyncBatchAnnotateFilesRequest const& request) {
  SetMetadata(*context, {});
  return child_->AsyncAsyncBatchAnnotateFiles(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
ImageAnnotatorMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> ImageAnnotatorMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void ImageAnnotatorMetadata::SetMetadata(grpc::ClientContext& context,
                                         std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void ImageAnnotatorMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision_internal
}  // namespace cloud
}  // namespace google
