// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/image_annotator.proto

#include "google/cloud/vision/image_annotator_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace vision {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ImageAnnotatorConnectionIdempotencyPolicy::
    ~ImageAnnotatorConnectionIdempotencyPolicy() = default;

namespace {
class DefaultImageAnnotatorConnectionIdempotencyPolicy
    : public ImageAnnotatorConnectionIdempotencyPolicy {
 public:
  ~DefaultImageAnnotatorConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ImageAnnotatorConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultImageAnnotatorConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency BatchAnnotateImages(
      google::cloud::vision::v1::BatchAnnotateImagesRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency BatchAnnotateFiles(
      google::cloud::vision::v1::BatchAnnotateFilesRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency AsyncBatchAnnotateImages(
      google::cloud::vision::v1::AsyncBatchAnnotateImagesRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency AsyncBatchAnnotateFiles(
      google::cloud::vision::v1::AsyncBatchAnnotateFilesRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ImageAnnotatorConnectionIdempotencyPolicy>
MakeDefaultImageAnnotatorConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultImageAnnotatorConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision
}  // namespace cloud
}  // namespace google
