// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_TRANSLATION_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_TRANSLATION_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/cloud/translate/v3/translation_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace translate {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TranslationServiceConnectionIdempotencyPolicy {
 public:
  virtual ~TranslationServiceConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<TranslationServiceConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency TranslateText(
      google::cloud::translation::v3::TranslateTextRequest const& request) = 0;

  virtual google::cloud::Idempotency DetectLanguage(
      google::cloud::translation::v3::DetectLanguageRequest const& request) = 0;

  virtual google::cloud::Idempotency GetSupportedLanguages(
      google::cloud::translation::v3::GetSupportedLanguagesRequest const&
          request) = 0;

  virtual google::cloud::Idempotency TranslateDocument(
      google::cloud::translation::v3::TranslateDocumentRequest const&
          request) = 0;

  virtual google::cloud::Idempotency BatchTranslateText(
      google::cloud::translation::v3::BatchTranslateTextRequest const&
          request) = 0;

  virtual google::cloud::Idempotency BatchTranslateDocument(
      google::cloud::translation::v3::BatchTranslateDocumentRequest const&
          request) = 0;

  virtual google::cloud::Idempotency CreateGlossary(
      google::cloud::translation::v3::CreateGlossaryRequest const& request) = 0;

  virtual google::cloud::Idempotency ListGlossaries(
      google::cloud::translation::v3::ListGlossariesRequest request) = 0;

  virtual google::cloud::Idempotency GetGlossary(
      google::cloud::translation::v3::GetGlossaryRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteGlossary(
      google::cloud::translation::v3::DeleteGlossaryRequest const& request) = 0;
};

std::unique_ptr<TranslationServiceConnectionIdempotencyPolicy>
MakeDefaultTranslationServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_TRANSLATION_CONNECTION_IDEMPOTENCY_POLICY_H
