// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#include "google/cloud/translate/translation_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace translate {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TranslationServiceConnectionIdempotencyPolicy::
    ~TranslationServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultTranslationServiceConnectionIdempotencyPolicy
    : public TranslationServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultTranslationServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<TranslationServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultTranslationServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency TranslateText(
      google::cloud::translation::v3::TranslateTextRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DetectLanguage(
      google::cloud::translation::v3::DetectLanguageRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetSupportedLanguages(
      google::cloud::translation::v3::GetSupportedLanguagesRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency TranslateDocument(
      google::cloud::translation::v3::TranslateDocumentRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency BatchTranslateText(
      google::cloud::translation::v3::BatchTranslateTextRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency BatchTranslateDocument(
      google::cloud::translation::v3::BatchTranslateDocumentRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateGlossary(
      google::cloud::translation::v3::CreateGlossaryRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListGlossaries(
      google::cloud::translation::v3::ListGlossariesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetGlossary(
      google::cloud::translation::v3::GetGlossaryRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency DeleteGlossary(
      google::cloud::translation::v3::DeleteGlossaryRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<TranslationServiceConnectionIdempotencyPolicy>
MakeDefaultTranslationServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultTranslationServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate
}  // namespace cloud
}  // namespace google
