// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_TRANSLATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_TRANSLATION_CLIENT_H

#include "google/cloud/translate/translation_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace translate {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Provides natural language translation operations.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class TranslationServiceClient {
 public:
  explicit TranslationServiceClient(
      std::shared_ptr<TranslationServiceConnection> connection,
      Options options = {});
  ~TranslationServiceClient();

  //@{
  // @name Copy and move support
  TranslationServiceClient(TranslationServiceClient const&) = default;
  TranslationServiceClient& operator=(TranslationServiceClient const&) =
      default;
  TranslationServiceClient(TranslationServiceClient&&) = default;
  TranslationServiceClient& operator=(TranslationServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(TranslationServiceClient const& a,
                         TranslationServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(TranslationServiceClient const& a,
                         TranslationServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Translates input text and returns translated text.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to
  /// a caller's
  ///  project.
  ///  Format: `projects/{project-number-or-id}` or
  ///  `projects/{project-number-or-id}/locations/{location-id}`.
  ///  For global calls, use `projects/{project-number-or-id}/locations/global`
  ///  or `projects/{project-number-or-id}`. Non-global location is required for
  ///  requests using AutoML models or custom glossaries. Models and glossaries
  ///  must be within the same region (have same location-id), otherwise an
  ///  INVALID_ARGUMENT (400) error is returned.
  /// @param target_language_code  Required. The BCP-47 language code to use for
  /// translation of the input
  ///  text, set to one of the language codes listed in Language Support.
  /// @param contents  Required. The content of the input in string format.
  ///  We recommend the total content be less than 30k codepoints. The max
  ///  length of this field is 1024. Use BatchTranslateText for larger text.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::TranslateTextResponse,google/cloud/translate/v3/translation_service.proto#L279}
  ///
  /// [google.cloud.translation.v3.TranslateTextRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L200}
  /// [google.cloud.translation.v3.TranslateTextResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L279}
  ///
  StatusOr<google::cloud::translation::v3::TranslateTextResponse> TranslateText(
      std::string const& parent, std::string const& target_language_code,
      std::vector<std::string> const& contents, Options options = {});

  ///
  /// Translates input text and returns translated text.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to
  /// a caller's
  ///  project.
  ///  Format: `projects/{project-number-or-id}` or
  ///  `projects/{project-number-or-id}/locations/{location-id}`.
  ///  For global calls, use `projects/{project-number-or-id}/locations/global`
  ///  or `projects/{project-number-or-id}`. Non-global location is required for
  ///  requests using AutoML models or custom glossaries. Models and glossaries
  ///  must be within the same region (have same location-id), otherwise an
  ///  INVALID_ARGUMENT (400) error is returned.
  /// @param model  Optional. The `model` type requested for this translation.
  ///  The format depends on model type:
  ///  - AutoML Translation models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
  ///  - General (built-in) models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
  ///
  ///  For global (non-regionalized) requests, use `location-id` `global`.
  ///  For example,
  ///  `projects/{project-number-or-id}/locations/global/models/general/nmt`.
  ///  If not provided, the default Google model (NMT) will be used.
  /// @param mime_type  Optional. The format of the source text, for example,
  /// "text/html",
  ///   "text/plain". If left blank, the MIME type defaults to "text/html".
  /// @param source_language_code  Optional. The BCP-47 language code of the
  /// input text if
  ///  known, for example, "en-US" or "sr-Latn". Supported language codes are
  ///  listed in Language Support. If the source language isn't specified, the
  ///  API attempts to identify the source language automatically and returns
  ///  the source language within the response.
  /// @param target_language_code  Required. The BCP-47 language code to use for
  /// translation of the input
  ///  text, set to one of the language codes listed in Language Support.
  /// @param contents  Required. The content of the input in string format.
  ///  We recommend the total content be less than 30k codepoints. The max
  ///  length of this field is 1024. Use BatchTranslateText for larger text.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::TranslateTextResponse,google/cloud/translate/v3/translation_service.proto#L279}
  ///
  /// [google.cloud.translation.v3.TranslateTextRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L200}
  /// [google.cloud.translation.v3.TranslateTextResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L279}
  ///
  StatusOr<google::cloud::translation::v3::TranslateTextResponse> TranslateText(
      std::string const& parent, std::string const& model,
      std::string const& mime_type, std::string const& source_language_code,
      std::string const& target_language_code,
      std::vector<std::string> const& contents, Options options = {});

  ///
  /// Translates input text and returns translated text.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::TranslateTextRequest,google/cloud/translate/v3/translation_service.proto#L200}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::TranslateTextResponse,google/cloud/translate/v3/translation_service.proto#L279}
  ///
  /// [google.cloud.translation.v3.TranslateTextRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L200}
  /// [google.cloud.translation.v3.TranslateTextResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L279}
  ///
  StatusOr<google::cloud::translation::v3::TranslateTextResponse> TranslateText(
      google::cloud::translation::v3::TranslateTextRequest const& request,
      Options options = {});

  ///
  /// Detects the language of text within a request.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to
  /// a caller's
  ///  project.
  ///  Format: `projects/{project-number-or-id}/locations/{location-id}` or
  ///  `projects/{project-number-or-id}`.
  ///  For global calls, use `projects/{project-number-or-id}/locations/global`
  ///  or `projects/{project-number-or-id}`. Only models within the same region
  ///  (has same location-id) can be used. Otherwise an INVALID_ARGUMENT (400)
  ///  error is returned.
  /// @param model  Optional. The language detection model to be used.
  ///  Format:
  ///  `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/{model-id}`
  ///  Only one language detection model is currently supported:
  ///  `projects/{project-number-or-id}/locations/{location-id}/models/language-detection/default`.
  ///  If not specified, the default model is used.
  /// @param mime_type  Optional. The format of the source text, for example,
  /// "text/html",
  ///  "text/plain". If left blank, the MIME type defaults to "text/html".
  /// @param content  The content of the input stored as a string.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::DetectLanguageResponse,google/cloud/translate/v3/translation_service.proto#L384}
  ///
  /// [google.cloud.translation.v3.DetectLanguageRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L321}
  /// [google.cloud.translation.v3.DetectLanguageResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L384}
  ///
  StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
  DetectLanguage(std::string const& parent, std::string const& model,
                 std::string const& mime_type, std::string const& content,
                 Options options = {});

  ///
  /// Detects the language of text within a request.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::DetectLanguageRequest,google/cloud/translate/v3/translation_service.proto#L321}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::DetectLanguageResponse,google/cloud/translate/v3/translation_service.proto#L384}
  ///
  /// [google.cloud.translation.v3.DetectLanguageRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L321}
  /// [google.cloud.translation.v3.DetectLanguageResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L384}
  ///
  StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
  DetectLanguage(
      google::cloud::translation::v3::DetectLanguageRequest const& request,
      Options options = {});

  ///
  /// Returns a list of supported languages for translation.
  ///
  /// @param parent  Required. Project or location to make a call. Must refer to
  /// a caller's
  ///  project.
  ///  Format: `projects/{project-number-or-id}` or
  ///  `projects/{project-number-or-id}/locations/{location-id}`.
  ///  For global calls, use `projects/{project-number-or-id}/locations/global`
  ///  or `projects/{project-number-or-id}`. Non-global location is required for
  ///  AutoML models. Only models within the same region (have same location-id)
  ///  can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
  /// @param model  Optional. Get supported languages of this model.
  ///  The format depends on model type:
  ///  - AutoML Translation models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
  ///  - General (built-in) models:
  ///    `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
  ///
  ///  Returns languages supported by the specified model.
  ///  If missing, we get supported languages of Google general NMT model.
  /// @param display_language_code  Optional. The language to use to return
  /// localized, human readable names
  ///  of supported languages. If missing, then display names are not returned
  ///  in a response.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::SupportedLanguages,google/cloud/translate/v3/translation_service.proto#L434}
  ///
  /// [google.cloud.translation.v3.GetSupportedLanguagesRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L391}
  /// [google.cloud.translation.v3.SupportedLanguages]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L434}
  ///
  StatusOr<google::cloud::translation::v3::SupportedLanguages>
  GetSupportedLanguages(std::string const& parent, std::string const& model,
                        std::string const& display_language_code,
                        Options options = {});

  ///
  /// Returns a list of supported languages for translation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::GetSupportedLanguagesRequest,google/cloud/translate/v3/translation_service.proto#L391}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::SupportedLanguages,google/cloud/translate/v3/translation_service.proto#L434}
  ///
  /// [google.cloud.translation.v3.GetSupportedLanguagesRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L391}
  /// [google.cloud.translation.v3.SupportedLanguages]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L434}
  ///
  StatusOr<google::cloud::translation::v3::SupportedLanguages>
  GetSupportedLanguages(
      google::cloud::translation::v3::GetSupportedLanguagesRequest const&
          request,
      Options options = {});

  ///
  /// Translates documents in synchronous mode.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::TranslateDocumentRequest,google/cloud/translate/v3/translation_service.proto#L686}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::TranslateDocumentResponse,google/cloud/translate/v3/translation_service.proto#L777}
  ///
  /// [google.cloud.translation.v3.TranslateDocumentRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L686}
  /// [google.cloud.translation.v3.TranslateDocumentResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L777}
  ///
  StatusOr<google::cloud::translation::v3::TranslateDocumentResponse>
  TranslateDocument(
      google::cloud::translation::v3::TranslateDocumentRequest const& request,
      Options options = {});

  ///
  /// Translates a large volume of text in asynchronous batch mode.
  /// This function provides real-time output as the inputs are being processed.
  /// If caller cancels a request, the partial results (for an input file, it's
  /// all or nothing) may still be available on the specified output location.
  ///
  /// This call returns immediately and you can
  /// use google.longrunning.Operation.name to poll the status of the call.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::BatchTranslateTextRequest,google/cloud/translate/v3/translation_service.proto#L801}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::BatchTranslateResponse,google/cloud/translate/v3/translation_service.proto#L921}
  ///
  /// [google.cloud.translation.v3.BatchTranslateTextRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L801}
  /// [google.cloud.translation.v3.BatchTranslateResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L921}
  ///
  future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
  BatchTranslateText(
      google::cloud::translation::v3::BatchTranslateTextRequest const& request,
      Options options = {});

  ///
  /// Translates a large volume of document in asynchronous batch mode.
  /// This function provides real-time output as the inputs are being processed.
  /// If caller cancels a request, the partial results (for an input file, it's
  /// all or nothing) may still be available on the specified output location.
  ///
  /// This call returns immediately and you can use
  /// google.longrunning.Operation.name to poll the status of the call.
  ///
  /// @param parent  Required. Location to make a regional call.
  ///  Format: `projects/{project-number-or-id}/locations/{location-id}`.
  ///  The `global` location is not supported for batch translation.
  ///  Only AutoML Translation models or glossaries within the same region (have
  ///  the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
  ///  error is returned.
  /// @param source_language_code  Required. The BCP-47 language code of the
  /// input document if known, for
  ///  example, "en-US" or "sr-Latn". Supported language codes are listed in
  ///  Language Support (https://cloud.google.com/translate/docs/languages).
  /// @param target_language_codes  Required. The BCP-47 language code to use
  /// for translation of the input
  ///  document. Specify up to 10 language codes here.
  /// @param input_configs  Required. Input configurations.
  ///  The total number of files matched should be <= 100.
  ///  The total content size to translate should be <= 100M Unicode codepoints.
  ///  The files must use UTF-8 encoding.
  /// @param output_config  Required. Output configuration.
  ///  If 2 input configs match to the same file (that is, same input path),
  ///  we don't generate output for duplicate inputs.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::BatchTranslateDocumentResponse,google/cloud/translate/v3/translation_service.proto#L1359}
  ///
  /// [google.cloud.translation.v3.BatchTranslateDocumentRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1199}
  /// [google.cloud.translation.v3.BatchTranslateDocumentResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1359}
  ///
  future<
      StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
  BatchTranslateDocument(
      std::string const& parent, std::string const& source_language_code,
      std::vector<std::string> const& target_language_codes,
      std::vector<
          google::cloud::translation::v3::BatchDocumentInputConfig> const&
          input_configs,
      google::cloud::translation::v3::BatchDocumentOutputConfig const&
          output_config,
      Options options = {});

  ///
  /// Translates a large volume of document in asynchronous batch mode.
  /// This function provides real-time output as the inputs are being processed.
  /// If caller cancels a request, the partial results (for an input file, it's
  /// all or nothing) may still be available on the specified output location.
  ///
  /// This call returns immediately and you can use
  /// google.longrunning.Operation.name to poll the status of the call.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::BatchTranslateDocumentRequest,google/cloud/translate/v3/translation_service.proto#L1199}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::BatchTranslateDocumentResponse,google/cloud/translate/v3/translation_service.proto#L1359}
  ///
  /// [google.cloud.translation.v3.BatchTranslateDocumentRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1199}
  /// [google.cloud.translation.v3.BatchTranslateDocumentResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1359}
  ///
  future<
      StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
  BatchTranslateDocument(
      google::cloud::translation::v3::BatchTranslateDocumentRequest const&
          request,
      Options options = {});

  ///
  /// Creates a glossary and returns the long-running operation. Returns
  /// NOT_FOUND, if the project doesn't exist.
  ///
  /// @param parent  Required. The project name.
  /// @param glossary  Required. The glossary to create.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::Glossary,google/cloud/translate/v3/translation_service.proto#L970}
  ///
  /// [google.cloud.translation.v3.CreateGlossaryRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1025}
  /// [google.cloud.translation.v3.Glossary]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L970}
  ///
  future<StatusOr<google::cloud::translation::v3::Glossary>> CreateGlossary(
      std::string const& parent,
      google::cloud::translation::v3::Glossary const& glossary,
      Options options = {});

  ///
  /// Creates a glossary and returns the long-running operation. Returns
  /// NOT_FOUND, if the project doesn't exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::CreateGlossaryRequest,google/cloud/translate/v3/translation_service.proto#L1025}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::Glossary,google/cloud/translate/v3/translation_service.proto#L970}
  ///
  /// [google.cloud.translation.v3.CreateGlossaryRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1025}
  /// [google.cloud.translation.v3.Glossary]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L970}
  ///
  future<StatusOr<google::cloud::translation::v3::Glossary>> CreateGlossary(
      google::cloud::translation::v3::CreateGlossaryRequest const& request,
      Options options = {});

  ///
  /// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
  /// exist.
  ///
  /// @param parent  Required. The name of the project from which to list all of
  /// the glossaries.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::Glossary,google/cloud/translate/v3/translation_service.proto#L970}
  ///
  /// [google.cloud.translation.v3.ListGlossariesRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1061}
  /// [google.cloud.translation.v3.Glossary]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L970}
  ///
  StreamRange<google::cloud::translation::v3::Glossary> ListGlossaries(
      std::string const& parent, Options options = {});

  ///
  /// Lists glossaries in a project. Returns NOT_FOUND, if the project doesn't
  /// exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::ListGlossariesRequest,google/cloud/translate/v3/translation_service.proto#L1061}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::Glossary,google/cloud/translate/v3/translation_service.proto#L970}
  ///
  /// [google.cloud.translation.v3.ListGlossariesRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1061}
  /// [google.cloud.translation.v3.Glossary]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L970}
  ///
  StreamRange<google::cloud::translation::v3::Glossary> ListGlossaries(
      google::cloud::translation::v3::ListGlossariesRequest request,
      Options options = {});

  ///
  /// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
  /// exist.
  ///
  /// @param name  Required. The name of the glossary to retrieve.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::Glossary,google/cloud/translate/v3/translation_service.proto#L970}
  ///
  /// [google.cloud.translation.v3.GetGlossaryRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1039}
  /// [google.cloud.translation.v3.Glossary]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L970}
  ///
  StatusOr<google::cloud::translation::v3::Glossary> GetGlossary(
      std::string const& name, Options options = {});

  ///
  /// Gets a glossary. Returns NOT_FOUND, if the glossary doesn't
  /// exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::GetGlossaryRequest,google/cloud/translate/v3/translation_service.proto#L1039}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::Glossary,google/cloud/translate/v3/translation_service.proto#L970}
  ///
  /// [google.cloud.translation.v3.GetGlossaryRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1039}
  /// [google.cloud.translation.v3.Glossary]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L970}
  ///
  StatusOr<google::cloud::translation::v3::Glossary> GetGlossary(
      google::cloud::translation::v3::GetGlossaryRequest const& request,
      Options options = {});

  ///
  /// Deletes a glossary, or cancels glossary construction
  /// if the glossary isn't created yet.
  /// Returns NOT_FOUND, if the glossary doesn't exist.
  ///
  /// @param name  Required. The name of the glossary to delete.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::DeleteGlossaryResponse,google/cloud/translate/v3/translation_service.proto#L1185}
  ///
  /// [google.cloud.translation.v3.DeleteGlossaryRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1050}
  /// [google.cloud.translation.v3.DeleteGlossaryResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1185}
  ///
  future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
  DeleteGlossary(std::string const& name, Options options = {});

  ///
  /// Deletes a glossary, or cancels glossary construction
  /// if the glossary isn't created yet.
  /// Returns NOT_FOUND, if the glossary doesn't exist.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::translation::v3::DeleteGlossaryRequest,google/cloud/translate/v3/translation_service.proto#L1050}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::translation::v3::DeleteGlossaryResponse,google/cloud/translate/v3/translation_service.proto#L1185}
  ///
  /// [google.cloud.translation.v3.DeleteGlossaryRequest]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1050}
  /// [google.cloud.translation.v3.DeleteGlossaryResponse]:
  /// @googleapis_reference_link{google/cloud/translate/v3/translation_service.proto#L1185}
  ///
  future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
  DeleteGlossary(
      google::cloud::translation::v3::DeleteGlossaryRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<TranslationServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TRANSLATE_TRANSLATION_CLIENT_H
